# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include lexruntimev2_service.R
NULL

#' Removes session information for a specified bot, alias, and user ID
#'
#' @description
#' Removes session information for a specified bot, alias, and user ID.
#'
#' See [https://www.paws-r-sdk.com/docs/lexruntimev2_delete_session/](https://www.paws-r-sdk.com/docs/lexruntimev2_delete_session/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot that contains the session data.
#' @param botAliasId &#91;required&#93; The alias identifier in use for the bot that contains the session data.
#' @param localeId &#91;required&#93; The locale where the session is in use.
#' @param sessionId &#91;required&#93; The identifier of the session to delete.
#'
#' @keywords internal
#'
#' @rdname lexruntimev2_delete_session
lexruntimev2_delete_session <- function(botId, botAliasId, localeId, sessionId) {
  op <- new_operation(
    name = "DeleteSession",
    http_method = "DELETE",
    http_path = "/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lexruntimev2$delete_session_input(botId = botId, botAliasId = botAliasId, localeId = localeId, sessionId = sessionId)
  output <- .lexruntimev2$delete_session_output()
  config <- get_config()
  svc <- .lexruntimev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexruntimev2$operations$delete_session <- lexruntimev2_delete_session

#' Returns session information for a specified bot, alias, and user
#'
#' @description
#' Returns session information for a specified bot, alias, and user.
#'
#' See [https://www.paws-r-sdk.com/docs/lexruntimev2_get_session/](https://www.paws-r-sdk.com/docs/lexruntimev2_get_session/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot that contains the session data.
#' @param botAliasId &#91;required&#93; The alias identifier in use for the bot that contains the session data.
#' @param localeId &#91;required&#93; The locale where the session is in use.
#' @param sessionId &#91;required&#93; The identifier of the session to return.
#'
#' @keywords internal
#'
#' @rdname lexruntimev2_get_session
lexruntimev2_get_session <- function(botId, botAliasId, localeId, sessionId) {
  op <- new_operation(
    name = "GetSession",
    http_method = "GET",
    http_path = "/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lexruntimev2$get_session_input(botId = botId, botAliasId = botAliasId, localeId = localeId, sessionId = sessionId)
  output <- .lexruntimev2$get_session_output()
  config <- get_config()
  svc <- .lexruntimev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexruntimev2$operations$get_session <- lexruntimev2_get_session

#' Creates a new session or modifies an existing session with an Amazon Lex
#' V2 bot
#'
#' @description
#' Creates a new session or modifies an existing session with an Amazon Lex V2 bot. Use this operation to enable your application to set the state of the bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexruntimev2_put_session/](https://www.paws-r-sdk.com/docs/lexruntimev2_put_session/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot that receives the session data.
#' @param botAliasId &#91;required&#93; The alias identifier of the bot that receives the session data.
#' @param localeId &#91;required&#93; The locale where the session is in use.
#' @param sessionId &#91;required&#93; The identifier of the session that receives the session data.
#' @param messages A list of messages to send to the user. Messages are sent in the order
#' that they are defined in the list.
#' @param sessionState &#91;required&#93; Sets the state of the session with the user. You can use this to set the
#' current intent, attributes, context, and dialog action. Use the dialog
#' action to determine the next step that Amazon Lex V2 should use in the
#' conversation with the user.
#' @param requestAttributes Request-specific information passed between Amazon Lex V2 and the client
#' application.
#' 
#' The namespace `x-amz-lex:` is reserved for special attributes. Don't
#' create any request attributes with the prefix `x-amz-lex:`.
#' @param responseContentType The message that Amazon Lex V2 returns in the response can be either
#' text or speech depending on the value of this parameter.
#' 
#' -   If the value is `text/plain; charset=utf-8`, Amazon Lex V2 returns
#'     text in the response.
#'
#' @keywords internal
#'
#' @rdname lexruntimev2_put_session
lexruntimev2_put_session <- function(botId, botAliasId, localeId, sessionId, messages = NULL, sessionState, requestAttributes = NULL, responseContentType = NULL) {
  op <- new_operation(
    name = "PutSession",
    http_method = "POST",
    http_path = "/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lexruntimev2$put_session_input(botId = botId, botAliasId = botAliasId, localeId = localeId, sessionId = sessionId, messages = messages, sessionState = sessionState, requestAttributes = requestAttributes, responseContentType = responseContentType)
  output <- .lexruntimev2$put_session_output()
  config <- get_config()
  svc <- .lexruntimev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexruntimev2$operations$put_session <- lexruntimev2_put_session

#' Sends user input to Amazon Lex V2
#'
#' @description
#' Sends user input to Amazon Lex V2. Client applications use this API to send requests to Amazon Lex V2 at runtime. Amazon Lex V2 then interprets the user input using the machine learning model that it build for the bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexruntimev2_recognize_text/](https://www.paws-r-sdk.com/docs/lexruntimev2_recognize_text/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot that processes the request.
#' @param botAliasId &#91;required&#93; The alias identifier in use for the bot that processes the request.
#' @param localeId &#91;required&#93; The locale where the session is in use.
#' @param sessionId &#91;required&#93; The identifier of the user session that is having the conversation.
#' @param text &#91;required&#93; The text that the user entered. Amazon Lex V2 interprets this text.
#' @param sessionState The current state of the dialog between the user and the bot.
#' @param requestAttributes Request-specific information passed between the client application and
#' Amazon Lex V2
#' 
#' The namespace `x-amz-lex:` is reserved for special attributes. Don't
#' create any request attributes with the prefix `x-amz-lex:`.
#'
#' @keywords internal
#'
#' @rdname lexruntimev2_recognize_text
lexruntimev2_recognize_text <- function(botId, botAliasId, localeId, sessionId, text, sessionState = NULL, requestAttributes = NULL) {
  op <- new_operation(
    name = "RecognizeText",
    http_method = "POST",
    http_path = "/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}/text",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lexruntimev2$recognize_text_input(botId = botId, botAliasId = botAliasId, localeId = localeId, sessionId = sessionId, text = text, sessionState = sessionState, requestAttributes = requestAttributes)
  output <- .lexruntimev2$recognize_text_output()
  config <- get_config()
  svc <- .lexruntimev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexruntimev2$operations$recognize_text <- lexruntimev2_recognize_text

#' Sends user input to Amazon Lex V2
#'
#' @description
#' Sends user input to Amazon Lex V2. You can send text or speech. Clients use this API to send text and audio requests to Amazon Lex V2 at runtime. Amazon Lex V2 interprets the user input using the machine learning model built for the bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexruntimev2_recognize_utterance/](https://www.paws-r-sdk.com/docs/lexruntimev2_recognize_utterance/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot that should receive the request.
#' @param botAliasId &#91;required&#93; The alias identifier in use for the bot that should receive the request.
#' @param localeId &#91;required&#93; The locale where the session is in use.
#' @param sessionId &#91;required&#93; The identifier of the session in use.
#' @param sessionState Sets the state of the session with the user. You can use this to set the
#' current intent, attributes, context, and dialog action. Use the dialog
#' action to determine the next step that Amazon Lex V2 should use in the
#' conversation with the user.
#' 
#' The `sessionState` field must be compressed using gzip and then base64
#' encoded before sending to Amazon Lex V2.
#' @param requestAttributes Request-specific information passed between the client application and
#' Amazon Lex V2
#' 
#' The namespace `x-amz-lex:` is reserved for special attributes. Don't
#' create any request attributes for prefix `x-amz-lex:`.
#' 
#' The `requestAttributes` field must be compressed using gzip and then
#' base64 encoded before sending to Amazon Lex V2.
#' @param requestContentType &#91;required&#93; Indicates the format for audio input or that the content is text. The
#' header must start with one of the following prefixes:
#' 
#' -   PCM format, audio data must be in little-endian byte order.
#' 
#'     -   audio/l16; rate=16000; channels=1
#' 
#'     -   audio/x-l16; sample-rate=16000; channel-count=1
#' 
#'     -   audio/lpcm; sample-rate=8000; sample-size-bits=16;
#'         channel-count=1; is-big-endian=false
#' 
#' -   Opus format
#' 
#'     -   audio/x-cbr-opus-with-preamble;preamble-size=0;bit-rate=256000;frame-size-milliseconds=4
#' 
#' -   Text format
#' 
#'     -   text/plain; charset=utf-8
#' @param responseContentType The message that Amazon Lex V2 returns in the response can be either
#' text or speech based on the `responseContentType` value.
#' 
#' -   If the value is `text/plain;charset=utf-8`, Amazon Lex V2 returns
#'     text in the response.
#' 
#' -   If the value begins with `audio/`, Amazon Lex V2 returns speech in
#'     the response. Amazon Lex V2 uses Amazon Polly to generate the speech
#'     using the configuration that you specified in the
#'     `responseContentType` parameter. For example, if you specify
#'     `audio/mpeg` as the value, Amazon Lex V2 returns speech in the MPEG
#'     format.
#' 
#' -   If the value is `audio/pcm`, the speech returned is `audio/pcm` at
#'     16 KHz in 16-bit, little-endian format.
#' 
#' -   The following are the accepted values:
#' 
#'     -   audio/mpeg
#' 
#'     -   audio/ogg
#' 
#'     -   audio/pcm (16 KHz)
#' 
#'     -   audio/* (defaults to mpeg)
#' 
#'     -   text/plain; charset=utf-8
#' @param inputStream User input in PCM or Opus audio format or text format as described in
#' the `requestContentType` parameter.
#'
#' @keywords internal
#'
#' @rdname lexruntimev2_recognize_utterance
lexruntimev2_recognize_utterance <- function(botId, botAliasId, localeId, sessionId, sessionState = NULL, requestAttributes = NULL, requestContentType, responseContentType = NULL, inputStream = NULL) {
  op <- new_operation(
    name = "RecognizeUtterance",
    http_method = "POST",
    http_path = "/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}/utterance",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .lexruntimev2$recognize_utterance_input(botId = botId, botAliasId = botAliasId, localeId = localeId, sessionId = sessionId, sessionState = sessionState, requestAttributes = requestAttributes, requestContentType = requestContentType, responseContentType = responseContentType, inputStream = inputStream)
  output <- .lexruntimev2$recognize_utterance_output()
  config <- get_config()
  svc <- .lexruntimev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexruntimev2$operations$recognize_utterance <- lexruntimev2_recognize_utterance

#' Starts an HTTP/2 bidirectional event stream that enables you to send
#' audio, text, or DTMF input in real time
#'
#' @description
#' Starts an HTTP/2 bidirectional event stream that enables you to send audio, text, or DTMF input in real time. After your application starts a conversation, users send input to Amazon Lex V2 as a stream of events. Amazon Lex V2 processes the incoming events and responds with streaming text or audio events.
#'
#' See [https://www.paws-r-sdk.com/docs/lexruntimev2_start_conversation/](https://www.paws-r-sdk.com/docs/lexruntimev2_start_conversation/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot to process the request.
#' @param botAliasId &#91;required&#93; The alias identifier in use for the bot that processes the request.
#' @param localeId &#91;required&#93; The locale where the session is in use.
#' @param sessionId &#91;required&#93; The identifier of the user session that is having the conversation.
#' @param conversationMode The conversation type that you are using the Amazon Lex V2. If the
#' conversation mode is `AUDIO` you can send both audio and DTMF
#' information. If the mode is `TEXT` you can only send text.
#' @param requestEventStream &#91;required&#93; Represents the stream of events to Amazon Lex V2 from your application.
#' The events are encoded as HTTP/2 data frames.
#'
#' @keywords internal
#'
#' @rdname lexruntimev2_start_conversation
lexruntimev2_start_conversation <- function(botId, botAliasId, localeId, sessionId, conversationMode = NULL, requestEventStream) {
  op <- new_operation(
    name = "StartConversation",
    http_method = "POST",
    http_path = "/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}/conversation",
    host_prefix = "",
    paginator = list(),
    stream_api = TRUE
  )
  input <- .lexruntimev2$start_conversation_input(botId = botId, botAliasId = botAliasId, localeId = localeId, sessionId = sessionId, conversationMode = conversationMode, requestEventStream = requestEventStream)
  output <- .lexruntimev2$start_conversation_output()
  config <- get_config()
  svc <- .lexruntimev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexruntimev2$operations$start_conversation <- lexruntimev2_start_conversation
