# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Elastic  Inference
#'
#' @description
#' Elastic Inference public APIs.
#' 
#' February 15, 2023: Starting April 15, 2023, AWS will not onboard new
#' customers to Amazon Elastic Inference (EI), and will help current
#' customers migrate their workloads to options that offer better price and
#' performance. After April 15, 2023, new customers will not be able to
#' launch instances with Amazon EI accelerators in Amazon SageMaker, Amazon
#' ECS, or Amazon EC2. However, customers who have used Amazon EI at least
#' once during the past 30-day period are considered current customers and
#' will be able to continue using the service.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- elasticinference(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- elasticinference()
#' svc$describe_accelerator_offerings(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=elasticinference_describe_accelerator_offerings]{describe_accelerator_offerings} \tab Describes the locations in which a given accelerator type or set of types is present in a given region\cr
#'  \link[=elasticinference_describe_accelerators]{describe_accelerators} \tab Describes information over a provided set of accelerators belonging to an account\cr
#'  \link[=elasticinference_describe_accelerator_types]{describe_accelerator_types} \tab Describes the accelerator types available in a given region, as well as their characteristics, such as memory and throughput\cr
#'  \link[=elasticinference_list_tags_for_resource]{list_tags_for_resource} \tab Returns all tags of an Elastic Inference Accelerator\cr
#'  \link[=elasticinference_tag_resource]{tag_resource} \tab Adds the specified tags to an Elastic Inference Accelerator\cr
#'  \link[=elasticinference_untag_resource]{untag_resource} \tab Removes the specified tags from an Elastic Inference Accelerator
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname elasticinference
#' @export
elasticinference <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .elasticinference$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.elasticinference <- list()

.elasticinference$operations <- list()

.elasticinference$metadata <- list(
  service_name = "elasticinference",
  endpoints = list("*" = list(endpoint = "api.elastic-inference.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "api.elastic-inference.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "api.elastic-inference.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "api.elastic-inference.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "api.elastic-inference.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "api.elastic-inference.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Elastic Inference",
  api_version = "2017-07-25",
  signing_name = "elastic-inference",
  json_version = "1.1",
  target_prefix = ""
)

.elasticinference$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.elasticinference$metadata, handlers, config, op)
}
