% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_hub_contents}
\alias{sagemaker_list_hub_contents}
\title{List the contents of a hub}
\usage{
sagemaker_list_hub_contents(
  HubName,
  HubContentType,
  NameContains = NULL,
  MaxSchemaVersion = NULL,
  CreationTimeBefore = NULL,
  CreationTimeAfter = NULL,
  SortBy = NULL,
  SortOrder = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{HubName}{[required] The name of the hub to list the contents of.}

\item{HubContentType}{[required] The type of hub content to list.}

\item{NameContains}{Only list hub content if the name contains the specified string.}

\item{MaxSchemaVersion}{The upper bound of the hub content schema verion.}

\item{CreationTimeBefore}{Only list hub content that was created before the time specified.}

\item{CreationTimeAfter}{Only list hub content that was created after the time specified.}

\item{SortBy}{Sort hub content versions by either name or creation time.}

\item{SortOrder}{Sort hubs by ascending or descending order.}

\item{MaxResults}{The maximum amount of hub content to list.}

\item{NextToken}{If the response to a previous
\code{\link[=sagemaker_list_hub_contents]{list_hub_contents}} request was
truncated, the response includes a \code{NextToken}. To retrieve the next set
of hub content, use the token in the next request.}
}
\description{
List the contents of a hub.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_list_hub_contents/} for full documentation.
}
\keyword{internal}
