% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelsv2_operations.R
\name{lexmodelsv2_delete_bot}
\alias{lexmodelsv2_delete_bot}
\title{Deletes all versions of a bot, including the Draft version}
\usage{
lexmodelsv2_delete_bot(botId, skipResourceInUseCheck = NULL)
}
\arguments{
\item{botId}{[required] The identifier of the bot to delete.}

\item{skipResourceInUseCheck}{By default, Amazon Lex checks if any other resource, such as an alias or
bot network, is using the bot version before it is deleted and throws a
\code{ResourceInUseException} exception if the bot is being used by another
resource. Set this parameter to \code{true} to skip this check and remove the
bot even if it is being used by another resource.}
}
\description{
Deletes all versions of a bot, including the \code{Draft} version. To delete a specific version, use the \code{\link[=lexmodelsv2_delete_bot_version]{delete_bot_version}} operation.

See \url{https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_bot/} for full documentation.
}
\keyword{internal}
