% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_monitoring_alert_history}
\alias{sagemaker_list_monitoring_alert_history}
\title{Gets a list of past alerts in a model monitoring schedule}
\usage{
sagemaker_list_monitoring_alert_history(
  MonitoringScheduleName = NULL,
  MonitoringAlertName = NULL,
  SortBy = NULL,
  SortOrder = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  CreationTimeBefore = NULL,
  CreationTimeAfter = NULL,
  StatusEquals = NULL
)
}
\arguments{
\item{MonitoringScheduleName}{The name of a monitoring schedule.}

\item{MonitoringAlertName}{The name of a monitoring alert.}

\item{SortBy}{The field used to sort results. The default is \code{CreationTime}.}

\item{SortOrder}{The sort order, whether \code{Ascending} or \code{Descending}, of the alert
history. The default is \code{Descending}.}

\item{NextToken}{If the result of the previous
\code{\link[=sagemaker_list_monitoring_alert_history]{list_monitoring_alert_history}}
request was truncated, the response includes a \code{NextToken}. To retrieve
the next set of alerts in the history, use the token in the next
request.}

\item{MaxResults}{The maximum number of results to display. The default is 100.}

\item{CreationTimeBefore}{A filter that returns only alerts created on or before the specified
time.}

\item{CreationTimeAfter}{A filter that returns only alerts created on or after the specified
time.}

\item{StatusEquals}{A filter that retrieves only alerts with a specific status.}
}
\description{
Gets a list of past alerts in a model monitoring schedule.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_list_monitoring_alert_history/} for full documentation.
}
\keyword{internal}
