% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_training_job}
\alias{sagemaker_create_training_job}
\title{Starts a model training job}
\usage{
sagemaker_create_training_job(
  TrainingJobName,
  HyperParameters = NULL,
  AlgorithmSpecification,
  RoleArn,
  InputDataConfig = NULL,
  OutputDataConfig,
  ResourceConfig,
  VpcConfig = NULL,
  StoppingCondition,
  Tags = NULL,
  EnableNetworkIsolation = NULL,
  EnableInterContainerTrafficEncryption = NULL,
  EnableManagedSpotTraining = NULL,
  CheckpointConfig = NULL,
  DebugHookConfig = NULL,
  DebugRuleConfigurations = NULL,
  TensorBoardOutputConfig = NULL,
  ExperimentConfig = NULL,
  ProfilerConfig = NULL,
  ProfilerRuleConfigurations = NULL,
  Environment = NULL,
  RetryStrategy = NULL,
  RemoteDebugConfig = NULL,
  InfraCheckConfig = NULL
)
}
\arguments{
\item{TrainingJobName}{[required] The name of the training job. The name must be unique within an Amazon
Web Services Region in an Amazon Web Services account.}

\item{HyperParameters}{Algorithm-specific parameters that influence the quality of the model.
You set hyperparameters before you start the learning process. For a
list of hyperparameters for each training algorithm provided by
SageMaker, see
\href{https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html}{Algorithms}.

You can specify a maximum of 100 hyperparameters. Each hyperparameter is
a key-value pair. Each key and value is limited to 256 characters, as
specified by the \verb{Length Constraint}.

Do not include any security-sensitive information including account
access IDs, secrets or tokens in any hyperparameter field. If the use of
security-sensitive credentials are detected, SageMaker will reject your
training job request and return an exception error.}

\item{AlgorithmSpecification}{[required] The registry path of the Docker image that contains the training
algorithm and algorithm-specific metadata, including the input mode. For
more information about algorithms provided by SageMaker, see
\href{https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html}{Algorithms}.
For information about providing your own algorithms, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/docker-containers.html}{Using Your Own Algorithms with Amazon SageMaker}.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume
to perform tasks on your behalf.

During model training, SageMaker needs your permission to read input
data from an S3 bucket, download a Docker image that contains training
code, write model artifacts to an S3 bucket, write logs to Amazon
CloudWatch Logs, and publish metrics to Amazon CloudWatch. You grant
permissions for all of these tasks to an IAM role. For more information,
see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html}{SageMaker Roles}.

To be able to pass this role to SageMaker, the caller of this API must
have the \code{iam:PassRole} permission.}

\item{InputDataConfig}{An array of \code{Channel} objects. Each channel is a named input source.
\code{InputDataConfig} describes the input data and its location.

Algorithms can accept input data from one or more channels. For example,
an algorithm might have two channels of input data, \code{training_data} and
\code{validation_data}. The configuration for each channel provides the S3,
EFS, or FSx location where the input data is stored. It also provides
information about the stored data: the MIME type, compression method,
and whether the data is wrapped in RecordIO format.

Depending on the input mode that the algorithm supports, SageMaker
either copies input data files from an S3 bucket to a local directory in
the Docker container, or makes it available as input streams. For
example, if you specify an EFS location, input data files are available
as input streams. They do not need to be downloaded.

Your input must be in the same Amazon Web Services region as your
training job.}

\item{OutputDataConfig}{[required] Specifies the path to the S3 location where you want to store model
artifacts. SageMaker creates subfolders for the artifacts.}

\item{ResourceConfig}{[required] The resources, including the ML compute instances and ML storage
volumes, to use for model training.

ML storage volumes store model artifacts and incremental states.
Training algorithms might also use ML storage volumes for scratch space.
If you want SageMaker to use the ML storage volume to store the training
data, choose \code{File} as the \code{TrainingInputMode} in the algorithm
specification. For distributed training algorithms, specify an instance
count greater than 1.}

\item{VpcConfig}{A
\href{https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html}{VpcConfig}
object that specifies the VPC that you want your training job to connect
to. Control access to and from your training container by configuring
the VPC. For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html}{Protect Training Jobs by Using an Amazon Virtual Private Cloud}.}

\item{StoppingCondition}{[required] Specifies a limit to how long a model training job can run. It also
specifies how long a managed Spot training job has to complete. When the
job reaches the time limit, SageMaker ends the training job. Use this
API to cap model training costs.

To stop a job, SageMaker sends the algorithm the \code{SIGTERM} signal, which
delays job termination for 120 seconds. Algorithms can use this
120-second window to save the model artifacts, so the results of
training are not lost.}

\item{Tags}{An array of key-value pairs. You can use tags to categorize your Amazon
Web Services resources in different ways, for example, by purpose,
owner, or environment. For more information, see \href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web Services Resources}.}

\item{EnableNetworkIsolation}{Isolates the training container. No inbound or outbound network calls
can be made, except for calls between peers within a training cluster
for distributed training. If you enable network isolation for training
jobs that are configured to use a VPC, SageMaker downloads and uploads
customer data and model artifacts through the specified VPC, but the
training container does not have network access.}

\item{EnableInterContainerTrafficEncryption}{To encrypt all communications between ML compute instances in
distributed training, choose \code{True}. Encryption provides greater
security for distributed training, but training might take longer. How
long it takes depends on the amount of communication between compute
instances, especially if you use a deep learning algorithm in
distributed training. For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html}{Protect Communications Between ML Compute Instances in a Distributed Training Job}.}

\item{EnableManagedSpotTraining}{To train models using managed spot training, choose \code{True}. Managed spot
training provides a fully managed and scalable infrastructure for
training machine learning models. this option is useful when training
jobs can be interrupted and when there is flexibility when the training
job is run.

The complete and intermediate results of jobs are stored in an Amazon S3
bucket, and can be used as a starting point to train models
incrementally. Amazon SageMaker provides metrics and logs in CloudWatch.
They can be used to see when managed spot training jobs are running,
interrupted, resumed, or completed.}

\item{CheckpointConfig}{Contains information about the output location for managed spot training
checkpoint data.}

\item{DebugHookConfig}{}

\item{DebugRuleConfigurations}{Configuration information for Amazon SageMaker Debugger rules for
debugging output tensors.}

\item{TensorBoardOutputConfig}{}

\item{ExperimentConfig}{}

\item{ProfilerConfig}{}

\item{ProfilerRuleConfigurations}{Configuration information for Amazon SageMaker Debugger rules for
profiling system and framework metrics.}

\item{Environment}{The environment variables to set in the Docker container.}

\item{RetryStrategy}{The number of times to retry the job when the job fails due to an
\code{InternalServerError}.}

\item{RemoteDebugConfig}{Configuration for remote debugging. To learn more about the remote
debugging functionality of SageMaker, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/train-remote-debugging.html}{Access a training container through Amazon Web Services Systems Manager (SSM) for remote debugging}.}

\item{InfraCheckConfig}{Contains information about the infrastructure health check configuration
for the training job.}
}
\description{
Starts a model training job. After training completes, SageMaker saves the resulting model artifacts to an Amazon S3 location that you specify.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_training_job/} for full documentation.
}
\keyword{internal}
