% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_feature_group}
\alias{sagemaker_create_feature_group}
\title{Create a new FeatureGroup}
\usage{
sagemaker_create_feature_group(
  FeatureGroupName,
  RecordIdentifierFeatureName,
  EventTimeFeatureName,
  FeatureDefinitions,
  OnlineStoreConfig = NULL,
  OfflineStoreConfig = NULL,
  RoleArn = NULL,
  Description = NULL,
  Tags = NULL
)
}
\arguments{
\item{FeatureGroupName}{[required] The name of the \code{FeatureGroup}. The name must be unique within an Amazon
Web Services Region in an Amazon Web Services account. The name:
\itemize{
\item Must start and end with an alphanumeric character.
\item Can only contain alphanumeric character and hyphens. Spaces are not
allowed.
}}

\item{RecordIdentifierFeatureName}{[required] The name of the \code{Feature} whose value uniquely identifies a \code{Record}
defined in the \code{FeatureStore}. Only the latest record per identifier
value will be stored in the \code{OnlineStore}. \code{RecordIdentifierFeatureName}
must be one of feature definitions' names.

You use the \code{RecordIdentifierFeatureName} to access data in a
\code{FeatureStore}.

This name:
\itemize{
\item Must start and end with an alphanumeric character.
\item Can only contains alphanumeric characters, hyphens, underscores.
Spaces are not allowed.
}}

\item{EventTimeFeatureName}{[required] The name of the feature that stores the \code{EventTime} of a \code{Record} in a
\code{FeatureGroup}.

An \code{EventTime} is a point in time when a new event occurs that
corresponds to the creation or update of a \code{Record} in a \code{FeatureGroup}.
All \code{Records} in the \code{FeatureGroup} must have a corresponding
\code{EventTime}.

An \code{EventTime} can be a \code{String} or \code{Fractional}.
\itemize{
\item \code{Fractional}: \code{EventTime} feature values must be a Unix timestamp in
seconds.
\item \code{String}: \code{EventTime} feature values must be an ISO-8601 string in
the format. The following formats are supported
\verb{yyyy-MM-dd'T'HH:mm:ssZ} and \verb{yyyy-MM-dd'T'HH:mm:ss.SSSZ} where
\code{yyyy}, \code{MM}, and \code{dd} represent the year, month, and day
respectively and \code{HH}, \code{mm}, \code{ss}, and if applicable, \code{SSS}
represent the hour, month, second and milliseconds respsectively.
\code{'T'} and \code{Z} are constants.
}}

\item{FeatureDefinitions}{[required] A list of \code{Feature} names and types. \code{Name} and \code{Type} is compulsory per
\code{Feature}.

Valid feature \code{FeatureType}s are \code{Integral}, \code{Fractional} and \code{String}.

\code{FeatureName}s cannot be any of the following: \code{is_deleted},
\code{write_time}, \code{api_invocation_time}

You can create up to 2,500 \code{FeatureDefinition}s per \code{FeatureGroup}.}

\item{OnlineStoreConfig}{You can turn the \code{OnlineStore} on or off by specifying \code{True} for the
\code{EnableOnlineStore} flag in \code{OnlineStoreConfig}.

You can also include an Amazon Web Services KMS key ID (\code{KMSKeyId}) for
at-rest encryption of the \code{OnlineStore}.

The default value is \code{False}.}

\item{OfflineStoreConfig}{Use this to configure an \code{OfflineFeatureStore}. This parameter allows
you to specify:
\itemize{
\item The Amazon Simple Storage Service (Amazon S3) location of an
\code{OfflineStore}.
\item A configuration for an Amazon Web Services Glue or Amazon Web
Services Hive data catalog.
\item An KMS encryption key to encrypt the Amazon S3 location used for
\code{OfflineStore}. If KMS encryption key is not specified, by default
we encrypt all data at rest using Amazon Web Services KMS key. By
defining your \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-key.html}{bucket-level key}
for SSE, you can reduce Amazon Web Services KMS requests costs by up
to 99 percent.
\item Format for the offline store table. Supported formats are Glue
(Default) and \href{https://iceberg.apache.org/}{Apache Iceberg}.
}

To learn more about this parameter, see
\href{https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OfflineStoreConfig.html}{OfflineStoreConfig}.}

\item{RoleArn}{The Amazon Resource Name (ARN) of the IAM execution role used to persist
data into the \code{OfflineStore} if an \code{OfflineStoreConfig} is provided.}

\item{Description}{A free-form description of a \code{FeatureGroup}.}

\item{Tags}{Tags used to identify \code{Features} in each \code{FeatureGroup}.}
}
\description{
Create a new \code{FeatureGroup}. A \code{FeatureGroup} is a group of \code{Features} defined in the \code{FeatureStore} to describe a \code{Record}.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_feature_group/} for full documentation.
}
\keyword{internal}
