% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookoutequipment_operations.R
\name{lookoutequipment_list_sensor_statistics}
\alias{lookoutequipment_list_sensor_statistics}
\title{Lists statistics about the data collected for each of the sensors that
have been successfully ingested in the particular dataset}
\usage{
lookoutequipment_list_sensor_statistics(
  DatasetName,
  IngestionJobId = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{DatasetName}{[required] The name of the dataset associated with the list of Sensor Statistics.}

\item{IngestionJobId}{The ingestion job id associated with the list of Sensor Statistics. To
get sensor statistics for a particular ingestion job id, both dataset
name and ingestion job id must be submitted as inputs.}

\item{MaxResults}{Specifies the maximum number of sensors for which to retrieve
statistics.}

\item{NextToken}{An opaque pagination token indicating where to continue the listing of
sensor statistics.}
}
\description{
Lists statistics about the data collected for each of the sensors that have been successfully ingested in the particular dataset. Can also be used to retreive Sensor Statistics for a previous ingestion job.

See \url{https://www.paws-r-sdk.com/docs/lookoutequipment_list_sensor_statistics/} for full documentation.
}
\keyword{internal}
