% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelsv2_operations.R
\name{lexmodelsv2_list_custom_vocabulary_items}
\alias{lexmodelsv2_list_custom_vocabulary_items}
\title{Paginated list of custom vocabulary items for a given bot locale's
custom vocabulary}
\usage{
lexmodelsv2_list_custom_vocabulary_items(
  botId,
  botVersion,
  localeId,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{botId}{[required] The identifier of the version of the bot associated with this custom
vocabulary.}

\item{botVersion}{[required] The bot version of the bot to the list custom vocabulary request.}

\item{localeId}{[required] The identifier of the language and locale where this custom vocabulary
is used. The string must match one of the supported locales. For more
information, see Supported languages
(https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).}

\item{maxResults}{The maximum number of items returned by the list operation.}

\item{nextToken}{The nextToken identifier to the list custom vocabulary request.}
}
\description{
Paginated list of custom vocabulary items for a given bot locale's custom vocabulary.

See \url{https://www.paws-r-sdk.com/docs/lexmodelsv2_list_custom_vocabulary_items/} for full documentation.
}
\keyword{internal}
