% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrock_operations.R
\name{bedrock_create_model_customization_job}
\alias{bedrock_create_model_customization_job}
\title{Creates a fine-tuning job to customize a base model}
\usage{
bedrock_create_model_customization_job(
  jobName,
  customModelName,
  roleArn,
  clientRequestToken = NULL,
  baseModelIdentifier,
  customizationType = NULL,
  customModelKmsKeyId = NULL,
  jobTags = NULL,
  customModelTags = NULL,
  trainingDataConfig,
  validationDataConfig = NULL,
  outputDataConfig,
  hyperParameters,
  vpcConfig = NULL
)
}
\arguments{
\item{jobName}{[required] Enter a unique name for the fine-tuning job.}

\item{customModelName}{[required] Enter a name for the custom model.}

\item{roleArn}{[required] The Amazon Resource Name (ARN) of an IAM role that Amazon Bedrock can
assume to perform tasks on your behalf. For example, during model
training, Amazon Bedrock needs your permission to read input data from
an S3 bucket, write model artifacts to an S3 bucket. To pass this role
to Amazon Bedrock, the caller of this API must have the \code{iam:PassRole}
permission.}

\item{clientRequestToken}{Unique token value that you can provide. The GetModelCustomizationJob
response includes the same token value.}

\item{baseModelIdentifier}{[required] Name of the base model.}

\item{customizationType}{The customization type.}

\item{customModelKmsKeyId}{The custom model is encrypted at rest using this key.}

\item{jobTags}{Assign tags to the job.}

\item{customModelTags}{Assign tags to the custom model.}

\item{trainingDataConfig}{[required] Information about the training dataset.}

\item{validationDataConfig}{Information about the validation dataset.}

\item{outputDataConfig}{[required] S3 location for the output data.}

\item{hyperParameters}{[required] Parameters related to tuning the model.}

\item{vpcConfig}{VPC configuration (optional). Configuration parameters for the private
Virtual Private Cloud (VPC) that contains the resources you are using
for this job.}
}
\description{
Creates a fine-tuning job to customize a base model.

See \url{https://www.paws-r-sdk.com/docs/bedrock_create_model_customization_job/} for full documentation.
}
\keyword{internal}
