% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textract_operations.R
\name{textract_detect_document_text}
\alias{textract_detect_document_text}
\title{Detects text in the input document}
\usage{
textract_detect_document_text(Document)
}
\arguments{
\item{Document}{[required] The input document as base64-encoded bytes or an Amazon S3 object. If
you use the AWS CLI to call Amazon Textract operations, you can't pass
image bytes. The document must be an image in JPEG or PNG format.

If you're using an AWS SDK to call Amazon Textract, you might not need
to base64-encode image bytes that are passed using the \code{Bytes} field.}
}
\description{
Detects text in the input document. Amazon Textract can detect lines of text and the words that make up a line of text. The input document must be in one of the following image formats: JPEG, PNG, PDF, or TIFF. \code{\link[=textract_detect_document_text]{detect_document_text}} returns the detected text in an array of Block objects.

See \url{https://www.paws-r-sdk.com/docs/textract_detect_document_text/} for full documentation.
}
\keyword{internal}
