% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_resource_catalogs}
\alias{sagemaker_list_resource_catalogs}
\title{Lists Amazon SageMaker Catalogs based on given filters and orders}
\usage{
sagemaker_list_resource_catalogs(
  NameContains = NULL,
  CreationTimeAfter = NULL,
  CreationTimeBefore = NULL,
  SortOrder = NULL,
  SortBy = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{NameContains}{A string that partially matches one or more \code{ResourceCatalog}s names.
Filters \code{ResourceCatalog} by name.}

\item{CreationTimeAfter}{Use this parameter to search for \code{ResourceCatalog}s created after a
specific date and time.}

\item{CreationTimeBefore}{Use this parameter to search for \code{ResourceCatalog}s created before a
specific date and time.}

\item{SortOrder}{The order in which the resource catalogs are listed.}

\item{SortBy}{The value on which the resource catalog list is sorted.}

\item{MaxResults}{The maximum number of results returned by
\code{\link[=sagemaker_list_resource_catalogs]{list_resource_catalogs}}.}

\item{NextToken}{A token to resume pagination of
\code{\link[=sagemaker_list_resource_catalogs]{list_resource_catalogs}} results.}
}
\description{
Lists Amazon SageMaker Catalogs based on given filters and orders. The maximum number of \code{ResourceCatalog}s viewable is 1000.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_list_resource_catalogs/} for full documentation.
}
\keyword{internal}
