% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_list_dataset_entries}
\alias{rekognition_list_dataset_entries}
\title{Lists the entries (images) within a dataset}
\usage{
rekognition_list_dataset_entries(
  DatasetArn,
  ContainsLabels = NULL,
  Labeled = NULL,
  SourceRefContains = NULL,
  HasErrors = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{DatasetArn}{[required] The Amazon Resource Name (ARN) for the dataset that you want to use.}

\item{ContainsLabels}{Specifies a label filter for the response. The response includes an
entry only if one or more of the labels in \code{ContainsLabels} exist in the
entry.}

\item{Labeled}{Specify \code{true} to get only the JSON Lines where the image is labeled.
Specify \code{false} to get only the JSON Lines where the image isn't
labeled. If you don't specify \code{Labeled},
\code{\link[=rekognition_list_dataset_entries]{list_dataset_entries}} returns JSON
Lines for labeled and unlabeled images.}

\item{SourceRefContains}{If specified, \code{\link[=rekognition_list_dataset_entries]{list_dataset_entries}}
only returns JSON Lines where the value of \code{SourceRefContains} is part
of the \code{source-ref} field. The \code{source-ref} field contains the Amazon S3
location of the image. You can use \code{SouceRefContains} for tasks such as
getting the JSON Line for a single image, or gettting JSON Lines for all
images within a specific folder.}

\item{HasErrors}{Specifies an error filter for the response. Specify \code{True} to only
include entries that have errors.}

\item{NextToken}{If the previous response was incomplete (because there is more results
to retrieve), Amazon Rekognition Custom Labels returns a pagination
token in the response. You can use this pagination token to retrieve the
next set of results.}

\item{MaxResults}{The maximum number of results to return per paginated call. The largest
value you can specify is 100. If you specify a value greater than 100, a
ValidationException error occurs. The default value is 100.}
}
\description{
Lists the entries (images) within a dataset. An entry is a JSON Line that contains the information for a single image, including the image location, assigned labels, and object location bounding boxes. For more information, see \href{https://docs.aws.amazon.com/rekognition/latest/customlabels-dg/}{Creating a manifest file}.

See \url{https://www.paws-r-sdk.com/docs/rekognition_list_dataset_entries/} for full documentation.
}
\keyword{internal}
