% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelsv2_operations.R
\name{lexmodelsv2_start_import}
\alias{lexmodelsv2_start_import}
\title{Starts importing a bot, bot locale, or custom vocabulary from a zip
archive that you uploaded to an S3 bucket}
\usage{
lexmodelsv2_start_import(
  importId,
  resourceSpecification,
  mergeStrategy,
  filePassword = NULL
)
}
\arguments{
\item{importId}{[required] The unique identifier for the import. It is included in the response
from the \code{\link[=lexmodelsv2_create_upload_url]{create_upload_url}} operation.}

\item{resourceSpecification}{[required] Parameters for creating the bot, bot locale or custom vocabulary.}

\item{mergeStrategy}{[required] The strategy to use when there is a name conflict between the imported
resource and an existing resource. When the merge strategy is
\code{FailOnConflict} existing resources are not overwritten and the import
fails.}

\item{filePassword}{The password used to encrypt the zip archive that contains the resource
definition. You should always encrypt the zip archive to protect it
during transit between your site and Amazon Lex.}
}
\description{
Starts importing a bot, bot locale, or custom vocabulary from a zip archive that you uploaded to an S3 bucket.

See \url{https://www.paws-r-sdk.com/docs/lexmodelsv2_start_import/} for full documentation.
}
\keyword{internal}
