% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_create_vocabulary}
\alias{transcribeservice_create_vocabulary}
\title{Creates a new custom vocabulary that you can use to change the way
Amazon Transcribe handles transcription of an audio file}
\usage{
transcribeservice_create_vocabulary(VocabularyName, LanguageCode,
  Phrases, VocabularyFileUri)
}
\arguments{
\item{VocabularyName}{[required] The name of the vocabulary. The name must be unique within an AWS
account. The name is case-sensitive.}

\item{LanguageCode}{[required] The language code of the vocabulary entries.}

\item{Phrases}{An array of strings that contains the vocabulary entries.}

\item{VocabularyFileUri}{The S3 location of the text file that contains the definition of the
custom vocabulary. The URI must be in the same region as the API
endpoint that you are calling. The general form is

\verb{https://s3.&lt;aws-region&gt;.amazonaws.com/&lt;bucket-name&gt;/&lt;keyprefix&gt;/&lt;objectkey&gt;}

For example:

\verb{https://s3.us-east-1.amazonaws.com/examplebucket/vocab.txt}

For more information about S3 object names, see \href{http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys}{Object Keys}
in the \emph{Amazon S3 Developer Guide}.

For more information about custom vocabularies, see \href{http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary}{Custom Vocabularies}.}
}
\description{
Creates a new custom vocabulary that you can use to change the way
Amazon Transcribe handles transcription of an audio file.
}
\section{Request syntax}{
\preformatted{svc$create_vocabulary(
  VocabularyName = "string",
  LanguageCode = "en-US"|"es-US"|"en-AU"|"fr-CA"|"en-GB"|"de-DE"|"pt-BR"|"fr-FR"|"it-IT"|"ko-KR"|"es-ES"|"en-IN"|"hi-IN"|"ar-SA"|"ru-RU"|"zh-CN"|"nl-NL"|"id-ID"|"ta-IN"|"fa-IR"|"en-IE"|"en-AB"|"en-WL"|"pt-PT"|"te-IN"|"tr-TR"|"de-CH"|"he-IL"|"ms-MY"|"ja-JP"|"ar-AE",
  Phrases = list(
    "string"
  ),
  VocabularyFileUri = "string"
)
}
}

\keyword{internal}
