% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_update_trial_component}
\alias{sagemaker_update_trial_component}
\title{Updates one or more properties of a trial component}
\usage{
sagemaker_update_trial_component(TrialComponentName, DisplayName,
  Status, StartTime, EndTime, Parameters, ParametersToRemove,
  InputArtifacts, InputArtifactsToRemove, OutputArtifacts,
  OutputArtifactsToRemove)
}
\arguments{
\item{TrialComponentName}{[required] The name of the component to update.}

\item{DisplayName}{The name of the component as displayed. The name doesn\'t need to be
unique. If \code{DisplayName} isn\'t specified, \code{TrialComponentName} is
displayed.}

\item{Status}{The new status of the component.}

\item{StartTime}{When the component started.}

\item{EndTime}{When the component ended.}

\item{Parameters}{Replaces all of the component\'s hyperparameters with the specified
hyperparameters.}

\item{ParametersToRemove}{The hyperparameters to remove from the component.}

\item{InputArtifacts}{Replaces all of the component\'s input artifacts with the specified
artifacts.}

\item{InputArtifactsToRemove}{The input artifacts to remove from the component.}

\item{OutputArtifacts}{Replaces all of the component\'s output artifacts with the specified
artifacts.}

\item{OutputArtifactsToRemove}{The output artifacts to remove from the component.}
}
\description{
Updates one or more properties of a trial component.
}
\section{Request syntax}{
\preformatted{svc$update_trial_component(
  TrialComponentName = "string",
  DisplayName = "string",
  Status = list(
    PrimaryStatus = "InProgress"|"Completed"|"Failed",
    Message = "string"
  ),
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  Parameters = list(
    list(
      StringValue = "string",
      NumberValue = 123.0
    )
  ),
  ParametersToRemove = list(
    "string"
  ),
  InputArtifacts = list(
    list(
      MediaType = "string",
      Value = "string"
    )
  ),
  InputArtifactsToRemove = list(
    "string"
  ),
  OutputArtifacts = list(
    list(
      MediaType = "string",
      Value = "string"
    )
  ),
  OutputArtifactsToRemove = list(
    "string"
  )
)
}
}

\keyword{internal}
