% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_detect_moderation_labels}
\alias{rekognition_detect_moderation_labels}
\title{Detects explicit or suggestive adult content in a specified JPEG or PNG
format image}
\usage{
rekognition_detect_moderation_labels(Image, MinConfidence)
}
\arguments{
\item{Image}{[required] The input image as base64-encoded bytes or an S3 object. If you use the
AWS CLI to call Amazon Rekognition operations, passing base64-encoded
image bytes is not supported.

If you are using an AWS SDK to call Amazon Rekognition, you might not
need to base64-encode image bytes passed using the \code{Bytes} field. For
more information, see Images in the Amazon Rekognition developer guide.}

\item{MinConfidence}{Specifies the minimum confidence level for the labels to return. Amazon
Rekognition doesn't return any labels with a confidence level lower
than this specified value.

If you don't specify \code{MinConfidence}, the operation returns labels with
confidence values greater than or equal to 50 percent.}
}
\description{
Detects explicit or suggestive adult content in a specified JPEG or PNG
format image. Use \code{DetectModerationLabels} to moderate images depending
on your requirements. For example, you might want to filter images that
contain nudity, but not images containing suggestive content.
}
\details{
To filter images, use the labels returned by \code{DetectModerationLabels} to
determine which types of content are appropriate.

For information about moderation labels, see Detecting Unsafe Content in
the Amazon Rekognition Developer Guide.

You pass the input image either as base64-encoded image bytes or as a
reference to an image in an Amazon S3 bucket. If you use the AWS CLI to
call Amazon Rekognition operations, passing image bytes is not
supported. The image must be either a PNG or JPEG formatted file.
}
\section{Request syntax}{
\preformatted{svc$detect_moderation_labels(
  Image = list(
    Bytes = raw,
    S3Object = list(
      Bucket = "string",
      Name = "string",
      Version = "string"
    )
  ),
  MinConfidence = 123.0
)
}
}

\keyword{internal}
