% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate_operations.R
\name{translate_list_text_translation_jobs}
\alias{translate_list_text_translation_jobs}
\title{Gets a list of the batch translation jobs that you have submitted}
\usage{
translate_list_text_translation_jobs(Filter, NextToken, MaxResults)
}
\arguments{
\item{Filter}{The parameters that specify which batch translation jobs to retrieve.
Filters include job name, job status, and submission time. You can only
set one filter at a time.}

\item{NextToken}{The token to request the next page of results.}

\item{MaxResults}{The maximum number of results to return in each page. The default value
is 100.}
}
\value{
A list with the following syntax:\preformatted{list(
  TextTranslationJobPropertiesList = list(
    list(
      JobId = "string",
      JobName = "string",
      JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"COMPLETED_WITH_ERROR"|"FAILED"|"STOP_REQUESTED"|"STOPPED",
      JobDetails = list(
        TranslatedDocumentsCount = 123,
        DocumentsWithErrorsCount = 123,
        InputDocumentsCount = 123
      ),
      SourceLanguageCode = "string",
      TargetLanguageCodes = list(
        "string"
      ),
      TerminologyNames = list(
        "string"
      ),
      ParallelDataNames = list(
        "string"
      ),
      Message = "string",
      SubmittedTime = as.POSIXct(
        "2015-01-01"
      ),
      EndTime = as.POSIXct(
        "2015-01-01"
      ),
      InputDataConfig = list(
        S3Uri = "string",
        ContentType = "string"
      ),
      OutputDataConfig = list(
        S3Uri = "string"
      ),
      DataAccessRoleArn = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Gets a list of the batch translation jobs that you have submitted.
}
\section{Request syntax}{
\preformatted{svc$list_text_translation_jobs(
  Filter = list(
    JobName = "string",
    JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"COMPLETED_WITH_ERROR"|"FAILED"|"STOP_REQUESTED"|"STOPPED",
    SubmittedBeforeTime = as.POSIXct(
      "2015-01-01"
    ),
    SubmittedAfterTime = as.POSIXct(
      "2015-01-01"
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
