% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_update_training_job}
\alias{sagemaker_update_training_job}
\title{Update a model training job to request a new Debugger profiling
configuration}
\usage{
sagemaker_update_training_job(TrainingJobName, ProfilerConfig,
  ProfilerRuleConfigurations)
}
\arguments{
\item{TrainingJobName}{[required] The name of a training job to update the Debugger profiling
configuration.}

\item{ProfilerConfig}{Configuration information for Debugger system monitoring, framework
profiling, and storage paths.}

\item{ProfilerRuleConfigurations}{Configuration information for Debugger rules for profiling system and
framework metrics.}
}
\description{
Update a model training job to request a new Debugger profiling
configuration.
}
\section{Request syntax}{
\preformatted{svc$update_training_job(
  TrainingJobName = "string",
  ProfilerConfig = list(
    S3OutputPath = "string",
    ProfilingIntervalInMilliseconds = 123,
    ProfilingParameters = list(
      "string"
    ),
    DisableProfiler = TRUE|FALSE
  ),
  ProfilerRuleConfigurations = list(
    list(
      RuleConfigurationName = "string",
      LocalPath = "string",
      S3OutputPath = "string",
      RuleEvaluatorImage = "string",
      InstanceType = "ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.r5.large"|"ml.r5.xlarge"|"ml.r5.2xlarge"|"ml.r5.4xlarge"|"ml.r5.8xlarge"|"ml.r5.12xlarge"|"ml.r5.16xlarge"|"ml.r5.24xlarge",
      VolumeSizeInGB = 123,
      RuleParameters = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
