% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_trial_components}
\alias{sagemaker_list_trial_components}
\title{Lists the trial components in your account}
\usage{
sagemaker_list_trial_components(ExperimentName, TrialName, SourceArn,
  CreatedAfter, CreatedBefore, SortBy, SortOrder, MaxResults, NextToken)
}
\arguments{
\item{ExperimentName}{A filter that returns only components that are part of the specified
experiment. If you specify \code{ExperimentName}, you can't filter by
\code{SourceArn} or \code{TrialName}.}

\item{TrialName}{A filter that returns only components that are part of the specified
trial. If you specify \code{TrialName}, you can't filter by \code{ExperimentName}
or \code{SourceArn}.}

\item{SourceArn}{A filter that returns only components that have the specified source
Amazon Resource Name (ARN). If you specify \code{SourceArn}, you can't filter
by \code{ExperimentName} or \code{TrialName}.}

\item{CreatedAfter}{A filter that returns only components created after the specified time.}

\item{CreatedBefore}{A filter that returns only components created before the specified time.}

\item{SortBy}{The property used to sort results. The default value is \code{CreationTime}.}

\item{SortOrder}{The sort order. The default value is \code{Descending}.}

\item{MaxResults}{The maximum number of components to return in the response. The default
value is 10.}

\item{NextToken}{If the previous call to \code{ListTrialComponents} didn't return the full set
of components, the call returns a token for getting the next set of
components.}
}
\description{
Lists the trial components in your account. You can sort the list by
trial component name or creation time. You can filter the list to show
only components that were created in a specific time range. You can also
filter on one of the following:
\itemize{
\item \code{ExperimentName}
\item \code{SourceArn}
\item \code{TrialName}
}
}
\section{Request syntax}{
\preformatted{svc$list_trial_components(
  ExperimentName = "string",
  TrialName = "string",
  SourceArn = "string",
  CreatedAfter = as.POSIXct(
    "2015-01-01"
  ),
  CreatedBefore = as.POSIXct(
    "2015-01-01"
  ),
  SortBy = "Name"|"CreationTime",
  SortOrder = "Ascending"|"Descending",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
