% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_projects}
\alias{sagemaker_list_projects}
\title{Gets a list of the projects in an AWS account}
\usage{
sagemaker_list_projects(CreationTimeAfter, CreationTimeBefore,
  MaxResults, NameContains, NextToken, SortBy, SortOrder)
}
\arguments{
\item{CreationTimeAfter}{A filter that returns the projects that were created after a specified
time.}

\item{CreationTimeBefore}{A filter that returns the projects that were created before a specified
time.}

\item{MaxResults}{The maximum number of projects to return in the response.}

\item{NameContains}{A filter that returns the projects whose name contains a specified
string.}

\item{NextToken}{If the result of the previous \code{ListProjects} request was truncated, the
response includes a \code{NextToken}. To retrieve the next set of projects,
use the token in the next request.}

\item{SortBy}{The field by which to sort results. The default is \code{CreationTime}.}

\item{SortOrder}{The sort order for results. The default is \code{Ascending}.}
}
\description{
Gets a list of the projects in an AWS account.
}
\section{Request syntax}{
\preformatted{svc$list_projects(
  CreationTimeAfter = as.POSIXct(
    "2015-01-01"
  ),
  CreationTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  MaxResults = 123,
  NameContains = "string",
  NextToken = "string",
  SortBy = "Name"|"CreationTime",
  SortOrder = "Ascending"|"Descending"
)
}
}

\keyword{internal}
