% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_artifact}
\alias{sagemaker_create_artifact}
\title{Creates an artifact}
\usage{
sagemaker_create_artifact(ArtifactName, Source, ArtifactType,
  Properties, MetadataProperties, Tags)
}
\arguments{
\item{ArtifactName}{The name of the artifact. Must be unique to your account in an AWS
Region.}

\item{Source}{[required] The ID, ID type, and URI of the source.}

\item{ArtifactType}{[required] The artifact type.}

\item{Properties}{A list of properties to add to the artifact.}

\item{MetadataProperties}{}

\item{Tags}{A list of tags to apply to the artifact.}
}
\description{
Creates an \emph{artifact}. An artifact is a lineage tracking entity that
represents a URI addressable object or data. Some examples are the S3
URI of a dataset and the ECR registry path of an image. For more
information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html}{Amazon SageMaker ML Lineage Tracking}.
}
\section{Request syntax}{
\preformatted{svc$create_artifact(
  ArtifactName = "string",
  Source = list(
    SourceUri = "string",
    SourceTypes = list(
      list(
        SourceIdType = "MD5Hash"|"S3ETag"|"S3Version"|"Custom",
        Value = "string"
      )
    )
  ),
  ArtifactType = "string",
  Properties = list(
    "string"
  ),
  MetadataProperties = list(
    CommitId = "string",
    Repository = "string",
    GeneratedBy = "string",
    ProjectId = "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
