% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelbuildingservice_operations.R
\name{lexmodelbuildingservice_get_bot_versions}
\alias{lexmodelbuildingservice_get_bot_versions}
\title{Gets information about all of the versions of a bot}
\usage{
lexmodelbuildingservice_get_bot_versions(name, nextToken, maxResults)
}
\arguments{
\item{name}{[required] The name of the bot for which versions should be returned.}

\item{nextToken}{A pagination token for fetching the next page of bot versions. If the
response to this call is truncated, Amazon Lex returns a pagination
token in the response. To fetch the next page of versions, specify the
pagination token in the next request.}

\item{maxResults}{The maximum number of bot versions to return in the response. The
default is 10.}
}
\description{
Gets information about all of the versions of a bot.

The \code{GetBotVersions} operation returns a \code{BotMetadata} object for each
version of a bot. For example, if a bot has three numbered versions, the
\code{GetBotVersions} operation returns four \code{BotMetadata} objects in the
response, one for each numbered version and one for the \verb{$LATEST}
version.

The \code{GetBotVersions} operation always returns at least one version, the
\verb{$LATEST} version.

This operation requires permissions for the \code{lex:GetBotVersions} action.
}
\section{Request syntax}{
\preformatted{svc$get_bot_versions(
  name = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
