# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include textract_service.R
NULL

#' Analyzes an input document for relationships in the detected text and
#' tables
#'
#' Analyzes an input document for relationships in the detected text and
#' tables.
#' 
#' Two types of information are returned:
#' 
#' -   Words and lines that are related to nearby lines and words. The
#'     related information is returned in two Block objects: a KEY Block
#'     object and a VALUE Block object. For example, *Name: Ana Silva
#'     Carolina* contains a key and value. *Name:* is the key. *Ana Silva
#'     Carolina* is the value.
#' 
#' -   Table and table cell data. A TABLE Block contains information about
#'     a detected table. A CELL block is returned for each cell in a table.
#' 
#' You can choose which type of analysis to perform by specifying the
#' `FeatureTypes` list.
#' 
#' The output is returned in a list of `BLOCK` objects (Blocks). For more
#' information, see how-it-works-analyzing.
#' 
#' `AnalyzeDocument` is a synchronous operation. To analyze documents
#' asynchronously, use StartDocumentAnalysis.
#'
#' @usage
#' textract_analyze_document(Document, FeatureTypes)
#'
#' @param Document &#91;required&#93; The input document as base64-encoded bytes or an Amazon S3 object. If
#' you use the AWS CLI to call Amazon Textract operations, you can\'t pass
#' image bytes. The document must be an image in JPG or PNG format.
#' @param FeatureTypes &#91;required&#93; A list of the types of analysis to perform. Add TABLES to the list to
#' return information about the tables detected in the input document. Add
#' FORMS to return detected fields and the associated text. To perform both
#' types of analysis, add TABLES and FORMS to `FeatureTypes`.
#'
#' @section Request syntax:
#' ```
#' svc$analyze_document(
#'   Document = list(
#'     Bytes = raw,
#'     S3Object = list(
#'       Bucket = "string",
#'       Name = "string",
#'       Version = "string"
#'     )
#'   ),
#'   FeatureTypes = list(
#'     "TABLES"|"FORMS"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname textract_analyze_document
textract_analyze_document <- function(Document, FeatureTypes) {
  op <- new_operation(
    name = "AnalyzeDocument",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .textract$analyze_document_input(Document = Document, FeatureTypes = FeatureTypes)
  output <- .textract$analyze_document_output()
  svc <- .textract$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$analyze_document <- textract_analyze_document

#' Detects text in the input document
#'
#' Detects text in the input document. Amazon Textract can detect lines of
#' text and the words that make up a line of text. The input document must
#' be an image in JPG or PNG format. `DetectDocumentText` returns the
#' detected text in an array of Block objects. For more information, see
#' how-it-works-detecting.
#' 
#' `DetectDocumentText` is a synchronous operation. To analyze documents
#' asynchronously, use StartDocumentTextDetection.
#'
#' @usage
#' textract_detect_document_text(Document)
#'
#' @param Document &#91;required&#93; The input document as base64-encoded bytes or an Amazon S3 object. If
#' you use the AWS CLI to call Amazon Textract operations, you can\'t pass
#' image bytes. The document must be an image in JPG or PNG format.
#'
#' @section Request syntax:
#' ```
#' svc$detect_document_text(
#'   Document = list(
#'     Bytes = raw,
#'     S3Object = list(
#'       Bucket = "string",
#'       Name = "string",
#'       Version = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname textract_detect_document_text
textract_detect_document_text <- function(Document) {
  op <- new_operation(
    name = "DetectDocumentText",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .textract$detect_document_text_input(Document = Document)
  output <- .textract$detect_document_text_output()
  svc <- .textract$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$detect_document_text <- textract_detect_document_text

#' Gets the results for an Amazon Textract asynchronous operation that
#' analyzes text in a document image
#'
#' Gets the results for an Amazon Textract asynchronous operation that
#' analyzes text in a document image.
#' 
#' You start asynchronous text analysis by calling StartDocumentAnalysis,
#' which returns a job identifier (`JobId`). When the text analysis
#' operation finishes, Amazon Textract publishes a completion status to the
#' Amazon Simple Notification Service (Amazon SNS) topic that\'s registered
#' in the initial call to `StartDocumentAnalysis`. To get the results of
#' the text-detection operation, first check that the status value
#' published to the Amazon SNS topic is `SUCCEEDED`. If so, call
#' `GetDocumentAnalysis`, and pass the job identifier (`JobId`) from the
#' initial call to `StartDocumentAnalysis`.
#' 
#' `GetDocumentAnalysis` returns an array of Block objects. For more
#' information, see how-it-works-analyzing.
#' 
#' Use the `MaxResults` parameter to limit the number of blocks returned.
#' If there are more results than specified in `MaxResults`, the value of
#' `NextToken` in the operation response contains a pagination token for
#' getting the next set of results. To get the next page of results, call
#' `GetDocumentAnalysis`, and populate the `NextToken` request parameter
#' with the token value that\'s returned from the previous call to
#' `GetDocumentAnalysis`.
#'
#' @usage
#' textract_get_document_analysis(JobId, MaxResults, NextToken)
#'
#' @param JobId &#91;required&#93; A unique identifier for the text-detection job. The `JobId` is returned
#' from `StartDocumentAnalysis`.
#' @param MaxResults The maximum number of results to return per paginated call. The largest
#' value that you can specify is 1,000. If you specify a value greater than
#' 1,000, a maximum of 1,000 results is returned. The default value is
#' 1,000.
#' @param NextToken If the previous response was incomplete (because there are more blocks
#' to retrieve), Amazon Textract returns a pagination token in the
#' response. You can use this pagination token to retrieve the next set of
#' blocks.
#'
#' @section Request syntax:
#' ```
#' svc$get_document_analysis(
#'   JobId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname textract_get_document_analysis
textract_get_document_analysis <- function(JobId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetDocumentAnalysis",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .textract$get_document_analysis_input(JobId = JobId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .textract$get_document_analysis_output()
  svc <- .textract$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$get_document_analysis <- textract_get_document_analysis

#' Gets the results for an Amazon Textract asynchronous operation that
#' detects text in a document image
#'
#' Gets the results for an Amazon Textract asynchronous operation that
#' detects text in a document image. Amazon Textract can detect lines of
#' text and the words that make up a line of text.
#' 
#' You start asynchronous text detection by calling
#' StartDocumentTextDetection, which returns a job identifier (`JobId`).
#' When the text detection operation finishes, Amazon Textract publishes a
#' completion status to the Amazon Simple Notification Service (Amazon SNS)
#' topic that\'s registered in the initial call to
#' `StartDocumentTextDetection`. To get the results of the text-detection
#' operation, first check that the status value published to the Amazon SNS
#' topic is `SUCCEEDED`. If so, call `GetDocumentTextDetection`, and pass
#' the job identifier (`JobId`) from the initial call to
#' `StartDocumentTextDetection`.
#' 
#' `GetDocumentTextDetection` returns an array of Block objects. For more
#' information, see how-it-works-detecting.
#' 
#' Use the MaxResults parameter to limit the number of blocks that are
#' returned. If there are more results than specified in `MaxResults`, the
#' value of `NextToken` in the operation response contains a pagination
#' token for getting the next set of results. To get the next page of
#' results, call `GetDocumentTextDetection`, and populate the `NextToken`
#' request parameter with the token value that\'s returned from the
#' previous call to `GetDocumentTextDetection`.
#' 
#' For more information, see Document Text Detection in the Amazon Textract
#' Developer Guide.
#'
#' @usage
#' textract_get_document_text_detection(JobId, MaxResults, NextToken)
#'
#' @param JobId &#91;required&#93; A unique identifier for the text detection job. The `JobId` is returned
#' from `StartDocumentTextDetection`.
#' @param MaxResults The maximum number of results to return per paginated call. The largest
#' value you can specify is 1,000. If you specify a value greater than
#' 1,000, a maximum of 1,000 results is returned. The default value is
#' 1,000.
#' @param NextToken If the previous response was incomplete (because there are more blocks
#' to retrieve), Amazon Textract returns a pagination token in the
#' response. You can use this pagination token to retrieve the next set of
#' blocks.
#'
#' @section Request syntax:
#' ```
#' svc$get_document_text_detection(
#'   JobId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname textract_get_document_text_detection
textract_get_document_text_detection <- function(JobId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetDocumentTextDetection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .textract$get_document_text_detection_input(JobId = JobId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .textract$get_document_text_detection_output()
  svc <- .textract$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$get_document_text_detection <- textract_get_document_text_detection

#' Starts asynchronous analysis of text for relationships in the text and
#' tables that are detected in a document
#'
#' Starts asynchronous analysis of text for relationships in the text and
#' tables that are detected in a document. Amazon Textract returns for two
#' types of information:
#' 
#' -   Words and lines that are related to nearby lines and words. The
#'     related information is returned in two Block objects: A KEY Block
#'     object and a VALUE Block object. For example, *Name: Ana Silva
#'     Carolina* contains a key and value. *Name:* is the key. *Ana Silva
#'     Carolina* is the value.
#' 
#' -   Table and table cell data. A TABLE block contains information about
#'     a detected table. A CELL block is returned for each cell in a table.
#' 
#' Amazon Textract can analyze text in document images and PDF files that
#' are stored in an Amazon S3 bucket. Use DocumentLocation to specify the
#' bucket name and file name of the document image.
#' 
#' `StartDocumentAnalysis` returns a job identifier (`JobId`) that you use
#' to get the results of the operation. When text analysis is finished,
#' Amazon Textract publishes a completion status to the Amazon Simple
#' Notification Service (Amazon SNS) topic that you specify in
#' `NotificationChannel`. To get the results of the text analysis
#' operation, first check that the status value published to the Amazon SNS
#' topic is `SUCCEEDED`. If so, call GetDocumentAnalysis, and pass the job
#' identifier (`JobId`) from the initial call to `StartDocumentAnalysis`.
#'
#' @usage
#' textract_start_document_analysis(DocumentLocation, FeatureTypes,
#'   ClientRequestToken, JobTag, NotificationChannel)
#'
#' @param DocumentLocation &#91;required&#93; The location of the document to be processed.
#' @param FeatureTypes &#91;required&#93; A list of the types of analysis to perform. Add TABLES to the list to
#' return information about the tables that are detected in the input
#' document. Add FORMS to return detected fields and the associated text.
#' To perform both types of analysis, add TABLES and FORMS to
#' `FeatureTypes`.
#' @param ClientRequestToken The idempotent token that you use to identify the start request. If you
#' use the same token with multiple `StartDocumentAnalysis` requests, the
#' same `JobId` is returned. Use `ClientRequestToken` to prevent the same
#' job from being accidentally started more than once.
#' @param JobTag The unique identifier you specify to identify the job in the completion
#' status that\'s published to the Amazon SNS topic.
#' @param NotificationChannel The Amazon SNS topic ARN that you want Amazon Textract to publish the
#' completion status of the operation to.
#'
#' @section Request syntax:
#' ```
#' svc$start_document_analysis(
#'   DocumentLocation = list(
#'     S3Object = list(
#'       Bucket = "string",
#'       Name = "string",
#'       Version = "string"
#'     )
#'   ),
#'   FeatureTypes = list(
#'     "TABLES"|"FORMS"
#'   ),
#'   ClientRequestToken = "string",
#'   JobTag = "string",
#'   NotificationChannel = list(
#'     SNSTopicArn = "string",
#'     RoleArn = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname textract_start_document_analysis
textract_start_document_analysis <- function(DocumentLocation, FeatureTypes, ClientRequestToken = NULL, JobTag = NULL, NotificationChannel = NULL) {
  op <- new_operation(
    name = "StartDocumentAnalysis",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .textract$start_document_analysis_input(DocumentLocation = DocumentLocation, FeatureTypes = FeatureTypes, ClientRequestToken = ClientRequestToken, JobTag = JobTag, NotificationChannel = NotificationChannel)
  output <- .textract$start_document_analysis_output()
  svc <- .textract$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$start_document_analysis <- textract_start_document_analysis

#' Starts the asynchronous detection of text in a document
#'
#' Starts the asynchronous detection of text in a document. Amazon Textract
#' can detect lines of text and the words that make up a line of text.
#' 
#' Amazon Textract can detect text in document images and PDF files that
#' are stored in an Amazon S3 bucket. Use DocumentLocation to specify the
#' bucket name and the file name of the document image.
#' 
#' `StartTextDetection` returns a job identifier (`JobId`) that you use to
#' get the results of the operation. When text detection is finished,
#' Amazon Textract publishes a completion status to the Amazon Simple
#' Notification Service (Amazon SNS) topic that you specify in
#' `NotificationChannel`. To get the results of the text detection
#' operation, first check that the status value published to the Amazon SNS
#' topic is `SUCCEEDED`. If so, call GetDocumentTextDetection, and pass the
#' job identifier (`JobId`) from the initial call to
#' `StartDocumentTextDetection`.
#' 
#' For more information, see Document Text Detection in the Amazon Textract
#' Developer Guide.
#'
#' @usage
#' textract_start_document_text_detection(DocumentLocation,
#'   ClientRequestToken, JobTag, NotificationChannel)
#'
#' @param DocumentLocation &#91;required&#93; The location of the document to be processed.
#' @param ClientRequestToken The idempotent token that\'s used to identify the start request. If you
#' use the same token with multiple `StartDocumentTextDetection` requests,
#' the same `JobId` is returned. Use `ClientRequestToken` to prevent the
#' same job from being accidentally started more than once.
#' @param JobTag A unique identifier you specify to identify the job in the completion
#' status that\'s published to the Amazon Simple Notification Service
#' (Amazon SNS) topic.
#' @param NotificationChannel The Amazon SNS topic ARN that you want Amazon Textract to publish the
#' completion status of the operation to.
#'
#' @section Request syntax:
#' ```
#' svc$start_document_text_detection(
#'   DocumentLocation = list(
#'     S3Object = list(
#'       Bucket = "string",
#'       Name = "string",
#'       Version = "string"
#'     )
#'   ),
#'   ClientRequestToken = "string",
#'   JobTag = "string",
#'   NotificationChannel = list(
#'     SNSTopicArn = "string",
#'     RoleArn = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname textract_start_document_text_detection
textract_start_document_text_detection <- function(DocumentLocation, ClientRequestToken = NULL, JobTag = NULL, NotificationChannel = NULL) {
  op <- new_operation(
    name = "StartDocumentTextDetection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .textract$start_document_text_detection_input(DocumentLocation = DocumentLocation, ClientRequestToken = ClientRequestToken, JobTag = JobTag, NotificationChannel = NotificationChannel)
  output <- .textract$start_document_text_detection_output()
  svc <- .textract$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.textract$operations$start_document_text_detection <- textract_start_document_text_detection
