# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' Amazon Lex Runtime Service
#'
#' @description
#' Amazon Lex provides both build and runtime endpoints. Each endpoint
#' provides a set of operations (API). Your conversational bot uses the
#' runtime API to understand user utterances (user input text or voice).
#' For example, suppose a user says \"I want pizza\", your bot sends this
#' input to Amazon Lex using the runtime API. Amazon Lex recognizes that
#' the user request is for the OrderPizza intent (one of the intents
#' defined in the bot). Then Amazon Lex engages in user conversation on
#' behalf of the bot to elicit required information (slot values, such as
#' pizza size and crust type), and then performs fulfillment activity (that
#' you configured when you created the bot). You use the build-time API to
#' create and manage your Amazon Lex bot. For a list of build-time
#' operations, see the build-time API, .
#'
#' @examples
#' \donttest{svc <- lexruntimeservice()
#' svc$post_content(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=lexruntimeservice_post_content]{post_content} \tab Sends user input (text or speech) to Amazon Lex\cr
#'  \link[=lexruntimeservice_post_text]{post_text} \tab Sends user input (text-only) to Amazon Lex 
#' }
#'
#' @rdname lexruntimeservice
#' @export
lexruntimeservice <- function() {
  .lexruntimeservice$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.lexruntimeservice <- list()

.lexruntimeservice$operations <- list()

.lexruntimeservice$metadata <- list(
  service_name = "runtime.lex",
  endpoints = list("*" = "runtime.lex.{region}.amazonaws.com", "cn-*" = "runtime.lex.{region}.amazonaws.com.cn"),
  service_id = "Lex Runtime Service",
  api_version = "2016-11-28",
  signing_name = "lex",
  json_version = "1.1",
  target_prefix = ""
)

.lexruntimeservice$handlers <- new_handlers("restjson", "v4")

.lexruntimeservice$service <- function() {
  new_service(.lexruntimeservice$metadata, .lexruntimeservice$handlers)
}
