% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces_operations.R
\name{workspaces_import_workspace_image}
\alias{workspaces_import_workspace_image}
\title{Imports the specified Windows 10 or 11 Bring Your Own License (BYOL)
image into Amazon WorkSpaces}
\usage{
workspaces_import_workspace_image(
  Ec2ImageId,
  IngestionProcess,
  ImageName,
  ImageDescription,
  Tags = NULL,
  Applications = NULL
)
}
\arguments{
\item{Ec2ImageId}{[required] The identifier of the EC2 image.}

\item{IngestionProcess}{[required] The ingestion process to be used when importing the image, depending on
which protocol you want to use for your BYOL Workspace image, either
PCoIP, WorkSpaces Streaming Protocol (WSP), or bring your own protocol
(BYOP). To use WSP, specify a value that ends in \verb{_WSP}. To use PCoIP,
specify a value that does not end in \verb{_WSP}. To use BYOP, specify a
value that ends in \verb{_BYOP}.

For non-GPU-enabled bundles (bundles other than Graphics or
GraphicsPro), specify \code{BYOL_REGULAR}, \code{BYOL_REGULAR_WSP}, or
\code{BYOL_REGULAR_BYOP}, depending on the protocol.

The \code{BYOL_REGULAR_BYOP} and \code{BYOL_GRAPHICS_G4DN_BYOP} values are only
supported by Amazon WorkSpaces Core. Contact your account team to be
allow-listed to use these values. For more information, see \href{https://aws.amazon.com/workspaces-family/core/}{Amazon WorkSpaces Core}.}

\item{ImageName}{[required] The name of the WorkSpace image.}

\item{ImageDescription}{[required] The description of the WorkSpace image.}

\item{Tags}{The tags. Each WorkSpaces resource can have a maximum of 50 tags.}

\item{Applications}{If specified, the version of Microsoft Office to subscribe to. Valid
only for Windows 10 and 11 BYOL images. For more information about
subscribing to Office for BYOL images, see \href{https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html}{Bring Your Own Windows Desktop Licenses}.
\itemize{
\item Although this parameter is an array, only one item is allowed at
this time.
\item During the image import process, non-GPU WSP WorkSpaces with Windows
11 support only \code{Microsoft_Office_2019}. GPU WSP WorkSpaces with
Windows 11 do not support Office installation.
}}
}
\description{
Imports the specified Windows 10 or 11 Bring Your Own License (BYOL) image into Amazon WorkSpaces. The image must be an already licensed Amazon EC2 image that is in your Amazon Web Services account, and you must own the image. For more information about creating BYOL images, see \href{https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html}{Bring Your Own Windows Desktop Licenses}.

See \url{https://www.paws-r-sdk.com/docs/workspaces_import_workspace_image/} for full documentation.
}
\keyword{internal}
