% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_get_report_group_trend}
\alias{codebuild_get_report_group_trend}
\title{Analyzes and accumulates test report values for the specified test
reports}
\usage{
codebuild_get_report_group_trend(
  reportGroupArn,
  numOfReports = NULL,
  trendField
)
}
\arguments{
\item{reportGroupArn}{[required] The ARN of the report group that contains the reports to analyze.}

\item{numOfReports}{The number of reports to analyze. This operation always retrieves the
most recent reports.

If this parameter is omitted, the most recent 100 reports are analyzed.}

\item{trendField}{[required] The test report value to accumulate. This must be one of the following
values:

\strong{Test reports:}

\strong{DURATION}

Accumulate the test run times for the specified reports.

\strong{PASS_RATE}

Accumulate the percentage of tests that passed for the specified test
reports.

\strong{TOTAL}

Accumulate the total number of tests for the specified test reports.

\strong{Code coverage reports:}

\strong{BRANCH_COVERAGE}

Accumulate the branch coverage percentages for the specified test
reports.

\strong{BRANCHES_COVERED}

Accumulate the branches covered values for the specified test reports.

\strong{BRANCHES_MISSED}

Accumulate the branches missed values for the specified test reports.

\strong{LINE_COVERAGE}

Accumulate the line coverage percentages for the specified test reports.

\strong{LINES_COVERED}

Accumulate the lines covered values for the specified test reports.

\strong{LINES_MISSED}

Accumulate the lines not covered values for the specified test reports.}
}
\description{
Analyzes and accumulates test report values for the specified test reports.

See \url{https://www.paws-r-sdk.com/docs/codebuild_get_report_group_trend/} for full documentation.
}
\keyword{internal}
