# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Elastic Disaster Recovery Service
#'
#' @description
#' AWS Elastic Disaster Recovery Service.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- drs(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- drs()
#' svc$associate_source_network_stack(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=drs_associate_source_network_stack]{associate_source_network_stack} \tab Associate a Source Network to an existing CloudFormation Stack and modify launch templates to use this network\cr
#'  \link[=drs_create_extended_source_server]{create_extended_source_server} \tab Create an extended source server in the target Account based on the source server in staging account\cr
#'  \link[=drs_create_launch_configuration_template]{create_launch_configuration_template} \tab Creates a new Launch Configuration Template\cr
#'  \link[=drs_create_replication_configuration_template]{create_replication_configuration_template} \tab Creates a new ReplicationConfigurationTemplate\cr
#'  \link[=drs_create_source_network]{create_source_network} \tab Create a new Source Network resource for a provided VPC ID\cr
#'  \link[=drs_delete_job]{delete_job} \tab Deletes a single Job by ID\cr
#'  \link[=drs_delete_launch_action]{delete_launch_action} \tab Deletes a resource launch action\cr
#'  \link[=drs_delete_launch_configuration_template]{delete_launch_configuration_template} \tab Deletes a single Launch Configuration Template by ID\cr
#'  \link[=drs_delete_recovery_instance]{delete_recovery_instance} \tab Deletes a single Recovery Instance by ID\cr
#'  \link[=drs_delete_replication_configuration_template]{delete_replication_configuration_template} \tab Deletes a single Replication Configuration Template by ID\cr
#'  \link[=drs_delete_source_network]{delete_source_network} \tab Delete Source Network resource\cr
#'  \link[=drs_delete_source_server]{delete_source_server} \tab Deletes a single Source Server by ID\cr
#'  \link[=drs_describe_job_log_items]{describe_job_log_items} \tab Retrieves a detailed Job log with pagination\cr
#'  \link[=drs_describe_jobs]{describe_jobs} \tab Returns a list of Jobs\cr
#'  \link[=drs_describe_launch_configuration_templates]{describe_launch_configuration_templates} \tab Lists all Launch Configuration Templates, filtered by Launch Configuration Template IDs\cr
#'  \link[=drs_describe_recovery_instances]{describe_recovery_instances} \tab Lists all Recovery Instances or multiple Recovery Instances by ID\cr
#'  \link[=drs_describe_recovery_snapshots]{describe_recovery_snapshots} \tab Lists all Recovery Snapshots for a single Source Server\cr
#'  \link[=drs_describe_replication_configuration_templates]{describe_replication_configuration_templates} \tab Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs\cr
#'  \link[=drs_describe_source_networks]{describe_source_networks} \tab Lists all Source Networks or multiple Source Networks filtered by ID\cr
#'  \link[=drs_describe_source_servers]{describe_source_servers} \tab Lists all Source Servers or multiple Source Servers filtered by ID\cr
#'  \link[=drs_disconnect_recovery_instance]{disconnect_recovery_instance} \tab Disconnect a Recovery Instance from Elastic Disaster Recovery\cr
#'  \link[=drs_disconnect_source_server]{disconnect_source_server} \tab Disconnects a specific Source Server from Elastic Disaster Recovery\cr
#'  \link[=drs_export_source_network_cfn_template]{export_source_network_cfn_template} \tab Export the Source Network CloudFormation template to an S3 bucket\cr
#'  \link[=drs_get_failback_replication_configuration]{get_failback_replication_configuration} \tab Lists all Failback ReplicationConfigurations, filtered by Recovery Instance ID\cr
#'  \link[=drs_get_launch_configuration]{get_launch_configuration} \tab Gets a LaunchConfiguration, filtered by Source Server IDs\cr
#'  \link[=drs_get_replication_configuration]{get_replication_configuration} \tab Gets a ReplicationConfiguration, filtered by Source Server ID\cr
#'  \link[=drs_initialize_service]{initialize_service} \tab Initialize Elastic Disaster Recovery\cr
#'  \link[=drs_list_extensible_source_servers]{list_extensible_source_servers} \tab Returns a list of source servers on a staging account that are extensible, which means that: a\cr
#'  \link[=drs_list_launch_actions]{list_launch_actions} \tab Lists resource launch actions\cr
#'  \link[=drs_list_staging_accounts]{list_staging_accounts} \tab Returns an array of staging accounts for existing extended source servers\cr
#'  \link[=drs_list_tags_for_resource]{list_tags_for_resource} \tab List all tags for your Elastic Disaster Recovery resources\cr
#'  \link[=drs_put_launch_action]{put_launch_action} \tab Puts a resource launch action\cr
#'  \link[=drs_retry_data_replication]{retry_data_replication} \tab WARNING: RetryDataReplication is deprecated\cr
#'  \link[=drs_reverse_replication]{reverse_replication} \tab Start replication to origin / target region - applies only to protected instances that originated in EC2\cr
#'  \link[=drs_start_failback_launch]{start_failback_launch} \tab Initiates a Job for launching the machine that is being failed back to from the specified Recovery Instance\cr
#'  \link[=drs_start_recovery]{start_recovery} \tab Launches Recovery Instances for the specified Source Servers\cr
#'  \link[=drs_start_replication]{start_replication} \tab Starts replication for a stopped Source Server\cr
#'  \link[=drs_start_source_network_recovery]{start_source_network_recovery} \tab Deploy VPC for the specified Source Network and modify launch templates to use this network\cr
#'  \link[=drs_start_source_network_replication]{start_source_network_replication} \tab Starts replication for a Source Network\cr
#'  \link[=drs_stop_failback]{stop_failback} \tab Stops the failback process for a specified Recovery Instance\cr
#'  \link[=drs_stop_replication]{stop_replication} \tab Stops replication for a Source Server\cr
#'  \link[=drs_stop_source_network_replication]{stop_source_network_replication} \tab Stops replication for a Source Network\cr
#'  \link[=drs_tag_resource]{tag_resource} \tab Adds or overwrites only the specified tags for the specified Elastic Disaster Recovery resource or resources\cr
#'  \link[=drs_terminate_recovery_instances]{terminate_recovery_instances} \tab Initiates a Job for terminating the EC2 resources associated with the specified Recovery Instances, and then will delete the Recovery Instances from the Elastic Disaster Recovery service\cr
#'  \link[=drs_untag_resource]{untag_resource} \tab Deletes the specified set of tags from the specified set of Elastic Disaster Recovery resources\cr
#'  \link[=drs_update_failback_replication_configuration]{update_failback_replication_configuration} \tab Allows you to update the failback replication configuration of a Recovery Instance by ID\cr
#'  \link[=drs_update_launch_configuration]{update_launch_configuration} \tab Updates a LaunchConfiguration by Source Server ID\cr
#'  \link[=drs_update_launch_configuration_template]{update_launch_configuration_template} \tab Updates an existing Launch Configuration Template by ID\cr
#'  \link[=drs_update_replication_configuration]{update_replication_configuration} \tab Allows you to update a ReplicationConfiguration by Source Server ID\cr
#'  \link[=drs_update_replication_configuration_template]{update_replication_configuration_template} \tab Updates a ReplicationConfigurationTemplate by ID
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname drs
#' @export
drs <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .drs$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.drs <- list()

.drs$operations <- list()

.drs$metadata <- list(
  service_name = "drs",
  endpoints = list("*" = list(endpoint = "drs.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "drs.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "drs.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "drs.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "drs",
  api_version = "2020-02-26",
  signing_name = "drs",
  json_version = "1.1",
  target_prefix = ""
)

.drs$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.drs$metadata, handlers, config)
}
