# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloud9_service.R
NULL

#' Creates an Cloud9 development environment, launches an Amazon Elastic
#' Compute Cloud (Amazon EC2) instance, and then connects from the instance
#' to the environment
#'
#' @description
#' Creates an Cloud9 development environment, launches an Amazon Elastic Compute Cloud (Amazon EC2) instance, and then connects from the instance to the environment.
#'
#' See [https://www.paws-r-sdk.com/docs/cloud9_create_environment_ec2/](https://www.paws-r-sdk.com/docs/cloud9_create_environment_ec2/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the environment to create.
#' 
#' This name is visible to other IAM users in the same Amazon Web Services
#' account.
#' @param description The description of the environment to create.
#' @param clientRequestToken A unique, case-sensitive string that helps Cloud9 to ensure this
#' operation completes no more than one time.
#' 
#' For more information, see [Client
#' Tokens](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html)
#' in the *Amazon EC2 API Reference*.
#' @param instanceType &#91;required&#93; The type of instance to connect to the environment (for example,
#' `t2.micro`).
#' @param subnetId The ID of the subnet in Amazon VPC that Cloud9 will use to communicate
#' with the Amazon EC2 instance.
#' @param imageId &#91;required&#93; The identifier for the Amazon Machine Image (AMI) that's used to create
#' the EC2 instance. To choose an AMI for the instance, you must specify a
#' valid AMI alias or a valid Amazon EC2 Systems Manager (SSM) path.
#' 
#' From December 04, 2023, you will be required to include the `imageId`
#' parameter for the
#' [`create_environment_ec2`][cloud9_create_environment_ec2] action. This
#' change will be reflected across all direct methods of communicating with
#' the API, such as Amazon Web Services SDK, Amazon Web Services CLI and
#' Amazon Web Services CloudFormation. This change will only affect direct
#' API consumers, and not Cloud9 console users.
#' 
#' From January 22, 2024, Amazon Linux (AL1) will be removed from the list
#' of available image IDs for Cloud9. This is necessary as AL1 will reach
#' the end of maintenance support in December 2023, and as a result will no
#' longer receive security updates. We recommend using Amazon Linux 2023 as
#' the AMI to create your environment as it is fully supported. This change
#' will only affect direct API consumers, and not Cloud9 console users.
#' 
#' Since Ubuntu 18.04 has ended standard support as of May 31, 2023, we
#' recommend you choose Ubuntu 22.04.
#' 
#' **AMI aliases**
#' 
#' -   Amazon Linux: `amazonlinux-1-x86_64`
#' 
#' -   Amazon Linux 2: `amazonlinux-2-x86_64`
#' 
#' -   Amazon Linux 2023 (recommended): `amazonlinux-2023-x86_64`
#' 
#' -   Ubuntu 18.04: `ubuntu-18.04-x86_64`
#' 
#' -   Ubuntu 22.04: `ubuntu-22.04-x86_64`
#' 
#' **SSM paths**
#' 
#' -   Amazon Linux:
#'     `resolve:ssm:/aws/service/cloud9/amis/amazonlinux-1-x86_64`
#' 
#' -   Amazon Linux 2:
#'     `resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64`
#' 
#' -   Amazon Linux 2023 (recommended):
#'     `resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2023-x86_64`
#' 
#' -   Ubuntu 18.04:
#'     `resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64`
#' 
#' -   Ubuntu 22.04:
#'     `resolve:ssm:/aws/service/cloud9/amis/ubuntu-22.04-x86_64`
#' @param automaticStopTimeMinutes The number of minutes until the running instance is shut down after the
#' environment has last been used.
#' @param ownerArn The Amazon Resource Name (ARN) of the environment owner. This ARN can be
#' the ARN of any IAM principal. If this value is not specified, the ARN
#' defaults to this environment's creator.
#' @param tags An array of key-value pairs that will be associated with the new Cloud9
#' development environment.
#' @param connectionType The connection type used for connecting to an Amazon EC2 environment.
#' Valid values are `CONNECT_SSH` (default) and `CONNECT_SSM` (connected
#' through Amazon EC2 Systems Manager).
#' 
#' For more information, see [Accessing no-ingress EC2 instances with
#' Amazon EC2 Systems
#' Manager](https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html)
#' in the *Cloud9 User Guide*.
#' @param dryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @keywords internal
#'
#' @rdname cloud9_create_environment_ec2
cloud9_create_environment_ec2 <- function(name, description = NULL, clientRequestToken = NULL, instanceType, subnetId = NULL, imageId, automaticStopTimeMinutes = NULL, ownerArn = NULL, tags = NULL, connectionType = NULL, dryRun = NULL) {
  op <- new_operation(
    name = "CreateEnvironmentEC2",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$create_environment_ec2_input(name = name, description = description, clientRequestToken = clientRequestToken, instanceType = instanceType, subnetId = subnetId, imageId = imageId, automaticStopTimeMinutes = automaticStopTimeMinutes, ownerArn = ownerArn, tags = tags, connectionType = connectionType, dryRun = dryRun)
  output <- .cloud9$create_environment_ec2_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$create_environment_ec2 <- cloud9_create_environment_ec2

#' Adds an environment member to an Cloud9 development environment
#'
#' @description
#' Adds an environment member to an Cloud9 development environment.
#'
#' See [https://www.paws-r-sdk.com/docs/cloud9_create_environment_membership/](https://www.paws-r-sdk.com/docs/cloud9_create_environment_membership/) for full documentation.
#'
#' @param environmentId &#91;required&#93; The ID of the environment that contains the environment member you want
#' to add.
#' @param userArn &#91;required&#93; The Amazon Resource Name (ARN) of the environment member you want to
#' add.
#' @param permissions &#91;required&#93; The type of environment member permissions you want to associate with
#' this environment member. Available values include:
#' 
#' -   `read-only`: Has read-only access to the environment.
#' 
#' -   `read-write`: Has read-write access to the environment.
#'
#' @keywords internal
#'
#' @rdname cloud9_create_environment_membership
cloud9_create_environment_membership <- function(environmentId, userArn, permissions) {
  op <- new_operation(
    name = "CreateEnvironmentMembership",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$create_environment_membership_input(environmentId = environmentId, userArn = userArn, permissions = permissions)
  output <- .cloud9$create_environment_membership_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$create_environment_membership <- cloud9_create_environment_membership

#' Deletes an Cloud9 development environment
#'
#' @description
#' Deletes an Cloud9 development environment. If an Amazon EC2 instance is connected to the environment, also terminates the instance.
#'
#' See [https://www.paws-r-sdk.com/docs/cloud9_delete_environment/](https://www.paws-r-sdk.com/docs/cloud9_delete_environment/) for full documentation.
#'
#' @param environmentId &#91;required&#93; The ID of the environment to delete.
#'
#' @keywords internal
#'
#' @rdname cloud9_delete_environment
cloud9_delete_environment <- function(environmentId) {
  op <- new_operation(
    name = "DeleteEnvironment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$delete_environment_input(environmentId = environmentId)
  output <- .cloud9$delete_environment_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$delete_environment <- cloud9_delete_environment

#' Deletes an environment member from a development environment
#'
#' @description
#' Deletes an environment member from a development environment.
#'
#' See [https://www.paws-r-sdk.com/docs/cloud9_delete_environment_membership/](https://www.paws-r-sdk.com/docs/cloud9_delete_environment_membership/) for full documentation.
#'
#' @param environmentId &#91;required&#93; The ID of the environment to delete the environment member from.
#' @param userArn &#91;required&#93; The Amazon Resource Name (ARN) of the environment member to delete from
#' the environment.
#'
#' @keywords internal
#'
#' @rdname cloud9_delete_environment_membership
cloud9_delete_environment_membership <- function(environmentId, userArn) {
  op <- new_operation(
    name = "DeleteEnvironmentMembership",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$delete_environment_membership_input(environmentId = environmentId, userArn = userArn)
  output <- .cloud9$delete_environment_membership_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$delete_environment_membership <- cloud9_delete_environment_membership

#' Gets information about environment members for an Cloud9 development
#' environment
#'
#' @description
#' Gets information about environment members for an Cloud9 development environment.
#'
#' See [https://www.paws-r-sdk.com/docs/cloud9_describe_environment_memberships/](https://www.paws-r-sdk.com/docs/cloud9_describe_environment_memberships/) for full documentation.
#'
#' @param userArn The Amazon Resource Name (ARN) of an individual environment member to
#' get information about. If no value is specified, information about all
#' environment members are returned.
#' @param environmentId The ID of the environment to get environment member information about.
#' @param permissions The type of environment member permissions to get information about.
#' Available values include:
#' 
#' -   `owner`: Owns the environment.
#' 
#' -   `read-only`: Has read-only access to the environment.
#' 
#' -   `read-write`: Has read-write access to the environment.
#' 
#' If no value is specified, information about all environment members are
#' returned.
#' @param nextToken During a previous call, if there are more than 25 items in the list,
#' only the first 25 items are returned, along with a unique string called
#' a *next token*. To get the next batch of items in the list, call this
#' operation again, adding the next token to the call. To get all of the
#' items in the list, keep calling this operation with each subsequent next
#' token that is returned, until no more next tokens are returned.
#' @param maxResults The maximum number of environment members to get information about.
#'
#' @keywords internal
#'
#' @rdname cloud9_describe_environment_memberships
cloud9_describe_environment_memberships <- function(userArn = NULL, environmentId = NULL, permissions = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeEnvironmentMemberships",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .cloud9$describe_environment_memberships_input(userArn = userArn, environmentId = environmentId, permissions = permissions, nextToken = nextToken, maxResults = maxResults)
  output <- .cloud9$describe_environment_memberships_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$describe_environment_memberships <- cloud9_describe_environment_memberships

#' Gets status information for an Cloud9 development environment
#'
#' @description
#' Gets status information for an Cloud9 development environment.
#'
#' See [https://www.paws-r-sdk.com/docs/cloud9_describe_environment_status/](https://www.paws-r-sdk.com/docs/cloud9_describe_environment_status/) for full documentation.
#'
#' @param environmentId &#91;required&#93; The ID of the environment to get status information about.
#'
#' @keywords internal
#'
#' @rdname cloud9_describe_environment_status
cloud9_describe_environment_status <- function(environmentId) {
  op <- new_operation(
    name = "DescribeEnvironmentStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$describe_environment_status_input(environmentId = environmentId)
  output <- .cloud9$describe_environment_status_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$describe_environment_status <- cloud9_describe_environment_status

#' Gets information about Cloud9 development environments
#'
#' @description
#' Gets information about Cloud9 development environments.
#'
#' See [https://www.paws-r-sdk.com/docs/cloud9_describe_environments/](https://www.paws-r-sdk.com/docs/cloud9_describe_environments/) for full documentation.
#'
#' @param environmentIds &#91;required&#93; The IDs of individual environments to get information about.
#'
#' @keywords internal
#'
#' @rdname cloud9_describe_environments
cloud9_describe_environments <- function(environmentIds) {
  op <- new_operation(
    name = "DescribeEnvironments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$describe_environments_input(environmentIds = environmentIds)
  output <- .cloud9$describe_environments_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$describe_environments <- cloud9_describe_environments

#' Gets a list of Cloud9 development environment identifiers
#'
#' @description
#' Gets a list of Cloud9 development environment identifiers.
#'
#' See [https://www.paws-r-sdk.com/docs/cloud9_list_environments/](https://www.paws-r-sdk.com/docs/cloud9_list_environments/) for full documentation.
#'
#' @param nextToken During a previous call, if there are more than 25 items in the list,
#' only the first 25 items are returned, along with a unique string called
#' a *next token*. To get the next batch of items in the list, call this
#' operation again, adding the next token to the call. To get all of the
#' items in the list, keep calling this operation with each subsequent next
#' token that is returned, until no more next tokens are returned.
#' @param maxResults The maximum number of environments to get identifiers for.
#'
#' @keywords internal
#'
#' @rdname cloud9_list_environments
cloud9_list_environments <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListEnvironments",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .cloud9$list_environments_input(nextToken = nextToken, maxResults = maxResults)
  output <- .cloud9$list_environments_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$list_environments <- cloud9_list_environments

#' Gets a list of the tags associated with an Cloud9 development
#' environment
#'
#' @description
#' Gets a list of the tags associated with an Cloud9 development environment.
#'
#' See [https://www.paws-r-sdk.com/docs/cloud9_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/cloud9_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the Cloud9 development environment to
#' get the tags for.
#'
#' @keywords internal
#'
#' @rdname cloud9_list_tags_for_resource
cloud9_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .cloud9$list_tags_for_resource_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$list_tags_for_resource <- cloud9_list_tags_for_resource

#' Adds tags to an Cloud9 development environment
#'
#' @description
#' Adds tags to an Cloud9 development environment.
#'
#' See [https://www.paws-r-sdk.com/docs/cloud9_tag_resource/](https://www.paws-r-sdk.com/docs/cloud9_tag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the Cloud9 development environment to
#' add tags to.
#' @param Tags &#91;required&#93; The list of tags to add to the given Cloud9 development environment.
#'
#' @keywords internal
#'
#' @rdname cloud9_tag_resource
cloud9_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .cloud9$tag_resource_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$tag_resource <- cloud9_tag_resource

#' Removes tags from an Cloud9 development environment
#'
#' @description
#' Removes tags from an Cloud9 development environment.
#'
#' See [https://www.paws-r-sdk.com/docs/cloud9_untag_resource/](https://www.paws-r-sdk.com/docs/cloud9_untag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the Cloud9 development environment to
#' remove tags from.
#' @param TagKeys &#91;required&#93; The tag names of the tags to remove from the given Cloud9 development
#' environment.
#'
#' @keywords internal
#'
#' @rdname cloud9_untag_resource
cloud9_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .cloud9$untag_resource_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$untag_resource <- cloud9_untag_resource

#' Changes the settings of an existing Cloud9 development environment
#'
#' @description
#' Changes the settings of an existing Cloud9 development environment.
#'
#' See [https://www.paws-r-sdk.com/docs/cloud9_update_environment/](https://www.paws-r-sdk.com/docs/cloud9_update_environment/) for full documentation.
#'
#' @param environmentId &#91;required&#93; The ID of the environment to change settings.
#' @param name A replacement name for the environment.
#' @param description Any new or replacement description for the environment.
#' @param managedCredentialsAction Allows the environment owner to turn on or turn off the Amazon Web
#' Services managed temporary credentials for an Cloud9 environment by
#' using one of the following values:
#' 
#' -   `ENABLE`
#' 
#' -   `DISABLE`
#' 
#' Only the environment owner can change the status of managed temporary
#' credentials. An `AccessDeniedException` is thrown if an attempt to turn
#' on or turn off managed temporary credentials is made by an account
#' that's not the environment owner.
#'
#' @keywords internal
#'
#' @rdname cloud9_update_environment
cloud9_update_environment <- function(environmentId, name = NULL, description = NULL, managedCredentialsAction = NULL) {
  op <- new_operation(
    name = "UpdateEnvironment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$update_environment_input(environmentId = environmentId, name = name, description = description, managedCredentialsAction = managedCredentialsAction)
  output <- .cloud9$update_environment_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$update_environment <- cloud9_update_environment

#' Changes the settings of an existing environment member for an Cloud9
#' development environment
#'
#' @description
#' Changes the settings of an existing environment member for an Cloud9 development environment.
#'
#' See [https://www.paws-r-sdk.com/docs/cloud9_update_environment_membership/](https://www.paws-r-sdk.com/docs/cloud9_update_environment_membership/) for full documentation.
#'
#' @param environmentId &#91;required&#93; The ID of the environment for the environment member whose settings you
#' want to change.
#' @param userArn &#91;required&#93; The Amazon Resource Name (ARN) of the environment member whose settings
#' you want to change.
#' @param permissions &#91;required&#93; The replacement type of environment member permissions you want to
#' associate with this environment member. Available values include:
#' 
#' -   `read-only`: Has read-only access to the environment.
#' 
#' -   `read-write`: Has read-write access to the environment.
#'
#' @keywords internal
#'
#' @rdname cloud9_update_environment_membership
cloud9_update_environment_membership <- function(environmentId, userArn, permissions) {
  op <- new_operation(
    name = "UpdateEnvironmentMembership",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloud9$update_environment_membership_input(environmentId = environmentId, userArn = userArn, permissions = permissions)
  output <- .cloud9$update_environment_membership_output()
  config <- get_config()
  svc <- .cloud9$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloud9$operations$update_environment_membership <- cloud9_update_environment_membership
