% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drs_operations.R
\name{drs_update_launch_configuration}
\alias{drs_update_launch_configuration}
\title{Updates a LaunchConfiguration by Source Server ID}
\usage{
drs_update_launch_configuration(
  copyPrivateIp = NULL,
  copyTags = NULL,
  launchDisposition = NULL,
  licensing = NULL,
  name = NULL,
  sourceServerID,
  targetInstanceTypeRightSizingMethod = NULL
)
}
\arguments{
\item{copyPrivateIp}{Whether we should copy the Private IP of the Source Server to the
Recovery Instance.}

\item{copyTags}{Whether we want to copy the tags of the Source Server to the EC2 machine
of the Recovery Instance.}

\item{launchDisposition}{The state of the Recovery Instance in EC2 after the recovery operation.}

\item{licensing}{The licensing configuration to be used for this launch configuration.}

\item{name}{The name of the launch configuration.}

\item{sourceServerID}{[required] The ID of the Source Server that we want to retrieve a Launch
Configuration for.}

\item{targetInstanceTypeRightSizingMethod}{Whether Elastic Disaster Recovery should try to automatically choose the
instance type that best matches the OS, CPU, and RAM of your Source
Server.}
}
\description{
Updates a LaunchConfiguration by Source Server ID.

See \url{https://www.paws-r-sdk.com/docs/drs_update_launch_configuration/} for full documentation.
}
\keyword{internal}
