% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codedeploy_operations.R
\name{codedeploy_put_lifecycle_event_hook_execution_status}
\alias{codedeploy_put_lifecycle_event_hook_execution_status}
\title{Sets the result of a Lambda validation function}
\usage{
codedeploy_put_lifecycle_event_hook_execution_status(
  deploymentId = NULL,
  lifecycleEventHookExecutionId = NULL,
  status = NULL
)
}
\arguments{
\item{deploymentId}{The unique ID of a deployment. Pass this ID to a Lambda function that
validates a deployment lifecycle event.}

\item{lifecycleEventHookExecutionId}{The execution ID of a deployment's lifecycle hook. A deployment
lifecycle hook is specified in the \code{hooks} section of the AppSpec file.}

\item{status}{The result of a Lambda function that validates a deployment lifecycle
event. The values listed in \strong{Valid Values} are valid for lifecycle
statuses in general; however, only \code{Succeeded} and \code{Failed} can be
passed successfully in your API call.}
}
\description{
Sets the result of a Lambda validation function. The function validates lifecycle hooks during a deployment that uses the Lambda or Amazon ECS compute platform. For Lambda deployments, the available lifecycle hooks are \code{BeforeAllowTraffic} and \code{AfterAllowTraffic}. For Amazon ECS deployments, the available lifecycle hooks are \code{BeforeInstall}, \code{AfterInstall}, \code{AfterAllowTestTraffic}, \code{BeforeAllowTraffic}, and \code{AfterAllowTraffic}. Lambda validation functions return \code{Succeeded} or \code{Failed}. For more information, see \href{https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-lambda}{AppSpec 'hooks' Section for an Lambda Deployment} and \href{https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-ecs}{AppSpec 'hooks' Section for an Amazon ECS Deployment}.

See \url{https://www.paws-r-sdk.com/docs/codedeploy_put_lifecycle_event_hook_execution_status/} for full documentation.
}
\keyword{internal}
