% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codedeploy_operations.R
\name{codedeploy_create_deployment_group}
\alias{codedeploy_create_deployment_group}
\title{Creates a deployment group to which application revisions are deployed}
\usage{
codedeploy_create_deployment_group(
  applicationName,
  deploymentGroupName,
  deploymentConfigName = NULL,
  ec2TagFilters = NULL,
  onPremisesInstanceTagFilters = NULL,
  autoScalingGroups = NULL,
  serviceRoleArn,
  triggerConfigurations = NULL,
  alarmConfiguration = NULL,
  autoRollbackConfiguration = NULL,
  outdatedInstancesStrategy = NULL,
  deploymentStyle = NULL,
  blueGreenDeploymentConfiguration = NULL,
  loadBalancerInfo = NULL,
  ec2TagSet = NULL,
  ecsServices = NULL,
  onPremisesTagSet = NULL,
  tags = NULL
)
}
\arguments{
\item{applicationName}{[required] The name of an CodeDeploy application associated with the IAM user or
Amazon Web Services account.}

\item{deploymentGroupName}{[required] The name of a new deployment group for the specified application.}

\item{deploymentConfigName}{If specified, the deployment configuration name can be either one of the
predefined configurations provided with CodeDeploy or a custom
deployment configuration that you create by calling the create
deployment configuration operation.

\code{CodeDeployDefault.OneAtATime} is the default deployment configuration.
It is used if a configuration isn't specified for the deployment or
deployment group.

For more information about the predefined deployment configurations in
CodeDeploy, see \href{https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html}{Working with Deployment Configurations in CodeDeploy}
in the \emph{CodeDeploy User Guide}.}

\item{ec2TagFilters}{The Amazon EC2 tags on which to filter. The deployment group includes
Amazon EC2 instances with any of the specified tags. Cannot be used in
the same call as ec2TagSet.}

\item{onPremisesInstanceTagFilters}{The on-premises instance tags on which to filter. The deployment group
includes on-premises instances with any of the specified tags. Cannot be
used in the same call as \code{OnPremisesTagSet}.}

\item{autoScalingGroups}{A list of associated Amazon EC2 Auto Scaling groups.}

\item{serviceRoleArn}{[required] A service role Amazon Resource Name (ARN) that allows CodeDeploy to act
on the user's behalf when interacting with Amazon Web Services services.}

\item{triggerConfigurations}{Information about triggers to create when the deployment group is
created. For examples, see \href{https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-sns-event-notifications-create-trigger.html}{Create a Trigger for an CodeDeploy Event}
in the \emph{CodeDeploy User Guide}.}

\item{alarmConfiguration}{Information to add about Amazon CloudWatch alarms when the deployment
group is created.}

\item{autoRollbackConfiguration}{Configuration information for an automatic rollback that is added when a
deployment group is created.}

\item{outdatedInstancesStrategy}{Indicates what happens when new Amazon EC2 instances are launched
mid-deployment and do not receive the deployed application revision.

If this option is set to \code{UPDATE} or is unspecified, CodeDeploy
initiates one or more 'auto-update outdated instances' deployments to
apply the deployed application revision to the new Amazon EC2 instances.

If this option is set to \code{IGNORE}, CodeDeploy does not initiate a
deployment to update the new Amazon EC2 instances. This may result in
instances having different revisions.}

\item{deploymentStyle}{Information about the type of deployment, in-place or blue/green, that
you want to run and whether to route deployment traffic behind a load
balancer.}

\item{blueGreenDeploymentConfiguration}{Information about blue/green deployment options for a deployment group.}

\item{loadBalancerInfo}{Information about the load balancer used in a deployment.}

\item{ec2TagSet}{Information about groups of tags applied to Amazon EC2 instances. The
deployment group includes only Amazon EC2 instances identified by all
the tag groups. Cannot be used in the same call as \code{ec2TagFilters}.}

\item{ecsServices}{The target Amazon ECS services in the deployment group. This applies
only to deployment groups that use the Amazon ECS compute platform. A
target Amazon ECS service is specified as an Amazon ECS cluster and
service name pair using the format \verb{<clustername>:<servicename>}.}

\item{onPremisesTagSet}{Information about groups of tags applied to on-premises instances. The
deployment group includes only on-premises instances identified by all
of the tag groups. Cannot be used in the same call as
\code{onPremisesInstanceTagFilters}.}

\item{tags}{The metadata that you apply to CodeDeploy deployment groups to help you
organize and categorize them. Each tag consists of a key and an optional
value, both of which you define.}
}
\description{
Creates a deployment group to which application revisions are deployed.

See \url{https://www.paws-r-sdk.com/docs/codedeploy_create_deployment_group/} for full documentation.
}
\keyword{internal}
