# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include codecommit_service.R
NULL

#' Creates an association between an approval rule template and a specified
#' repository
#'
#' @description
#' Creates an association between an approval rule template and a specified repository. Then, the next time a pull request is created in the repository where the destination reference (if specified) matches the destination reference (branch) for the pull request, an approval rule that matches the template conditions is automatically created for that pull request. If no destination references are specified in the template, an approval rule that matches the template contents is created for all pull requests in that repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_associate_approval_rule_template_with_repository/](https://www.paws-r-sdk.com/docs/codecommit_associate_approval_rule_template_with_repository/) for full documentation.
#'
#' @param approvalRuleTemplateName &#91;required&#93; The name for the approval rule template.
#' @param repositoryName &#91;required&#93; The name of the repository that you want to associate with the template.
#'
#' @keywords internal
#'
#' @rdname codecommit_associate_approval_rule_template_with_repository
codecommit_associate_approval_rule_template_with_repository <- function(approvalRuleTemplateName, repositoryName) {
  op <- new_operation(
    name = "AssociateApprovalRuleTemplateWithRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$associate_approval_rule_template_with_repository_input(approvalRuleTemplateName = approvalRuleTemplateName, repositoryName = repositoryName)
  output <- .codecommit$associate_approval_rule_template_with_repository_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$associate_approval_rule_template_with_repository <- codecommit_associate_approval_rule_template_with_repository

#' Creates an association between an approval rule template and one or more
#' specified repositories
#'
#' @description
#' Creates an association between an approval rule template and one or more specified repositories.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_batch_associate_approval_rule_template_with_repositories/](https://www.paws-r-sdk.com/docs/codecommit_batch_associate_approval_rule_template_with_repositories/) for full documentation.
#'
#' @param approvalRuleTemplateName &#91;required&#93; The name of the template you want to associate with one or more
#' repositories.
#' @param repositoryNames &#91;required&#93; The names of the repositories you want to associate with the template.
#' 
#' The length constraint limit is for each string in the array. The array
#' itself can be empty.
#'
#' @keywords internal
#'
#' @rdname codecommit_batch_associ_approv_rule_templa_with_reposi
codecommit_batch_associate_approval_rule_template_with_repositories <- function(approvalRuleTemplateName, repositoryNames) {
  op <- new_operation(
    name = "BatchAssociateApprovalRuleTemplateWithRepositories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$batch_associate_approval_rule_template_with_repositories_input(approvalRuleTemplateName = approvalRuleTemplateName, repositoryNames = repositoryNames)
  output <- .codecommit$batch_associate_approval_rule_template_with_repositories_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$batch_associate_approval_rule_template_with_repositories <- codecommit_batch_associate_approval_rule_template_with_repositories

#' Returns information about one or more merge conflicts in the attempted
#' merge of two commit specifiers using the squash or three-way merge
#' strategy
#'
#' @description
#' Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the squash or three-way merge strategy.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_batch_describe_merge_conflicts/](https://www.paws-r-sdk.com/docs/codecommit_batch_describe_merge_conflicts/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository that contains the merge conflicts you want to
#' review.
#' @param destinationCommitSpecifier &#91;required&#93; The branch, tag, HEAD, or other fully qualified reference used to
#' identify a commit (for example, a branch name or a full commit ID).
#' @param sourceCommitSpecifier &#91;required&#93; The branch, tag, HEAD, or other fully qualified reference used to
#' identify a commit (for example, a branch name or a full commit ID).
#' @param mergeOption &#91;required&#93; The merge option or strategy you want to use to merge the code.
#' @param maxMergeHunks The maximum number of merge hunks to include in the output.
#' @param maxConflictFiles The maximum number of files to include in the output.
#' @param filePaths The path of the target files used to describe the conflicts. If not
#' specified, the default is all conflict files.
#' @param conflictDetailLevel The level of conflict detail to use. If unspecified, the default
#' FILE_LEVEL is used, which returns a not-mergeable result if the same
#' file has differences in both branches. If LINE_LEVEL is specified, a
#' conflict is considered not mergeable if the same file in both branches
#' has differences on the same line.
#' @param conflictResolutionStrategy Specifies which branch to use when resolving conflicts, or whether to
#' attempt automatically merging two versions of a file. The default is
#' NONE, which requires any conflicts to be resolved manually before the
#' merge operation is successful.
#' @param nextToken An enumeration token that, when provided in a request, returns the next
#' batch of the results.
#'
#' @keywords internal
#'
#' @rdname codecommit_batch_describe_merge_conflicts
codecommit_batch_describe_merge_conflicts <- function(repositoryName, destinationCommitSpecifier, sourceCommitSpecifier, mergeOption, maxMergeHunks = NULL, maxConflictFiles = NULL, filePaths = NULL, conflictDetailLevel = NULL, conflictResolutionStrategy = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "BatchDescribeMergeConflicts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$batch_describe_merge_conflicts_input(repositoryName = repositoryName, destinationCommitSpecifier = destinationCommitSpecifier, sourceCommitSpecifier = sourceCommitSpecifier, mergeOption = mergeOption, maxMergeHunks = maxMergeHunks, maxConflictFiles = maxConflictFiles, filePaths = filePaths, conflictDetailLevel = conflictDetailLevel, conflictResolutionStrategy = conflictResolutionStrategy, nextToken = nextToken)
  output <- .codecommit$batch_describe_merge_conflicts_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$batch_describe_merge_conflicts <- codecommit_batch_describe_merge_conflicts

#' Removes the association between an approval rule template and one or
#' more specified repositories
#'
#' @description
#' Removes the association between an approval rule template and one or more specified repositories.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_batch_disassociate_approval_rule_template_from_repositories/](https://www.paws-r-sdk.com/docs/codecommit_batch_disassociate_approval_rule_template_from_repositories/) for full documentation.
#'
#' @param approvalRuleTemplateName &#91;required&#93; The name of the template that you want to disassociate from one or more
#' repositories.
#' @param repositoryNames &#91;required&#93; The repository names that you want to disassociate from the approval
#' rule template.
#' 
#' The length constraint limit is for each string in the array. The array
#' itself can be empty.
#'
#' @keywords internal
#'
#' @rdname codecommit_batch_disass_approv_rule_templa_from_reposi
codecommit_batch_disassociate_approval_rule_template_from_repositories <- function(approvalRuleTemplateName, repositoryNames) {
  op <- new_operation(
    name = "BatchDisassociateApprovalRuleTemplateFromRepositories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$batch_disassociate_approval_rule_template_from_repositories_input(approvalRuleTemplateName = approvalRuleTemplateName, repositoryNames = repositoryNames)
  output <- .codecommit$batch_disassociate_approval_rule_template_from_repositories_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$batch_disassociate_approval_rule_template_from_repositories <- codecommit_batch_disassociate_approval_rule_template_from_repositories

#' Returns information about the contents of one or more commits in a
#' repository
#'
#' @description
#' Returns information about the contents of one or more commits in a repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_batch_get_commits/](https://www.paws-r-sdk.com/docs/codecommit_batch_get_commits/) for full documentation.
#'
#' @param commitIds &#91;required&#93; The full commit IDs of the commits to get information about.
#' 
#' You must supply the full SHA IDs of each commit. You cannot use
#' shortened SHA IDs.
#' @param repositoryName &#91;required&#93; The name of the repository that contains the commits.
#'
#' @keywords internal
#'
#' @rdname codecommit_batch_get_commits
codecommit_batch_get_commits <- function(commitIds, repositoryName) {
  op <- new_operation(
    name = "BatchGetCommits",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$batch_get_commits_input(commitIds = commitIds, repositoryName = repositoryName)
  output <- .codecommit$batch_get_commits_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$batch_get_commits <- codecommit_batch_get_commits

#' Returns information about one or more repositories
#'
#' @description
#' Returns information about one or more repositories.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_batch_get_repositories/](https://www.paws-r-sdk.com/docs/codecommit_batch_get_repositories/) for full documentation.
#'
#' @param repositoryNames &#91;required&#93; The names of the repositories to get information about.
#' 
#' The length constraint limit is for each string in the array. The array
#' itself can be empty.
#'
#' @keywords internal
#'
#' @rdname codecommit_batch_get_repositories
codecommit_batch_get_repositories <- function(repositoryNames) {
  op <- new_operation(
    name = "BatchGetRepositories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$batch_get_repositories_input(repositoryNames = repositoryNames)
  output <- .codecommit$batch_get_repositories_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$batch_get_repositories <- codecommit_batch_get_repositories

#' Creates a template for approval rules that can then be associated with
#' one or more repositories in your AWS account
#'
#' @description
#' Creates a template for approval rules that can then be associated with one or more repositories in your AWS account. When you associate a template with a repository, AWS CodeCommit creates an approval rule that matches the conditions of the template for all pull requests that meet the conditions of the template. For more information, see [`associate_approval_rule_template_with_repository`][codecommit_associate_approval_rule_template_with_repository].
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_create_approval_rule_template/](https://www.paws-r-sdk.com/docs/codecommit_create_approval_rule_template/) for full documentation.
#'
#' @param approvalRuleTemplateName &#91;required&#93; The name of the approval rule template. Provide descriptive names,
#' because this name is applied to the approval rules created automatically
#' in associated repositories.
#' @param approvalRuleTemplateContent &#91;required&#93; The content of the approval rule that is created on pull requests in
#' associated repositories. If you specify one or more destination
#' references (branches), approval rules are created in an associated
#' repository only if their destination references (branches) match those
#' specified in the template.
#' 
#' When you create the content of the approval rule template, you can
#' specify approvers in an approval pool in one of two ways:
#' 
#' -   **CodeCommitApprovers**: This option only requires an AWS account
#'     and a resource. It can be used for both IAM users and federated
#'     access users whose name matches the provided resource name. This is
#'     a very powerful option that offers a great deal of flexibility. For
#'     example, if you specify the AWS account *123456789012* and
#'     *Mary_Major*, all of the following are counted as approvals coming
#'     from that user:
#' 
#'     -   An IAM user in the account
#'         (arn:aws:iam::*123456789012*:user/*Mary_Major*)
#' 
#'     -   A federated user identified in IAM as Mary_Major
#'         (arn:aws:sts::*123456789012*:federated-user/*Mary_Major*)
#' 
#'     This option does not recognize an active session of someone assuming
#'     the role of CodeCommitReview with a role session name of
#'     *Mary_Major*
#'     (arn:aws:sts::*123456789012*:assumed-role/CodeCommitReview/*Mary_Major*)
#'     unless you include a wildcard (*Mary_Major).
#' 
#' -   **Fully qualified ARN**: This option allows you to specify the fully
#'     qualified Amazon Resource Name (ARN) of the IAM user or role.
#' 
#' For more information about IAM ARNs, wildcards, and formats, see [IAM
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
#' in the *IAM User Guide*.
#' @param approvalRuleTemplateDescription The description of the approval rule template. Consider providing a
#' description that explains what this template does and when it might be
#' appropriate to associate it with repositories.
#'
#' @keywords internal
#'
#' @rdname codecommit_create_approval_rule_template
codecommit_create_approval_rule_template <- function(approvalRuleTemplateName, approvalRuleTemplateContent, approvalRuleTemplateDescription = NULL) {
  op <- new_operation(
    name = "CreateApprovalRuleTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$create_approval_rule_template_input(approvalRuleTemplateName = approvalRuleTemplateName, approvalRuleTemplateContent = approvalRuleTemplateContent, approvalRuleTemplateDescription = approvalRuleTemplateDescription)
  output <- .codecommit$create_approval_rule_template_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$create_approval_rule_template <- codecommit_create_approval_rule_template

#' Creates a branch in a repository and points the branch to a commit
#'
#' @description
#' Creates a branch in a repository and points the branch to a commit.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_create_branch/](https://www.paws-r-sdk.com/docs/codecommit_create_branch/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository in which you want to create the new branch.
#' @param branchName &#91;required&#93; The name of the new branch to create.
#' @param commitId &#91;required&#93; The ID of the commit to point the new branch to.
#'
#' @keywords internal
#'
#' @rdname codecommit_create_branch
codecommit_create_branch <- function(repositoryName, branchName, commitId) {
  op <- new_operation(
    name = "CreateBranch",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$create_branch_input(repositoryName = repositoryName, branchName = branchName, commitId = commitId)
  output <- .codecommit$create_branch_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$create_branch <- codecommit_create_branch

#' Creates a commit for a repository on the tip of a specified branch
#'
#' @description
#' Creates a commit for a repository on the tip of a specified branch.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_create_commit/](https://www.paws-r-sdk.com/docs/codecommit_create_commit/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository where you create the commit.
#' @param branchName &#91;required&#93; The name of the branch where you create the commit.
#' @param parentCommitId The ID of the commit that is the parent of the commit you create. Not
#' required if this is an empty repository.
#' @param authorName The name of the author who created the commit. This information is used
#' as both the author and committer for the commit.
#' @param email The email address of the person who created the commit.
#' @param commitMessage The commit message you want to include in the commit. Commit messages
#' are limited to 256 KB. If no message is specified, a default message is
#' used.
#' @param keepEmptyFolders If the commit contains deletions, whether to keep a folder or folder
#' structure if the changes leave the folders empty. If true, a ..gitkeep
#' file is created for empty folders. The default is false.
#' @param putFiles The files to add or update in this commit.
#' @param deleteFiles The files to delete in this commit. These files still exist in earlier
#' commits.
#' @param setFileModes The file modes to update for files in this commit.
#'
#' @keywords internal
#'
#' @rdname codecommit_create_commit
codecommit_create_commit <- function(repositoryName, branchName, parentCommitId = NULL, authorName = NULL, email = NULL, commitMessage = NULL, keepEmptyFolders = NULL, putFiles = NULL, deleteFiles = NULL, setFileModes = NULL) {
  op <- new_operation(
    name = "CreateCommit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$create_commit_input(repositoryName = repositoryName, branchName = branchName, parentCommitId = parentCommitId, authorName = authorName, email = email, commitMessage = commitMessage, keepEmptyFolders = keepEmptyFolders, putFiles = putFiles, deleteFiles = deleteFiles, setFileModes = setFileModes)
  output <- .codecommit$create_commit_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$create_commit <- codecommit_create_commit

#' Creates a pull request in the specified repository
#'
#' @description
#' Creates a pull request in the specified repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_create_pull_request/](https://www.paws-r-sdk.com/docs/codecommit_create_pull_request/) for full documentation.
#'
#' @param title &#91;required&#93; The title of the pull request. This title is used to identify the pull
#' request to other users in the repository.
#' @param description A description of the pull request.
#' @param targets &#91;required&#93; The targets for the pull request, including the source of the code to be
#' reviewed (the source branch) and the destination where the creator of
#' the pull request intends the code to be merged after the pull request is
#' closed (the destination branch).
#' @param clientRequestToken A unique, client-generated idempotency token that, when provided in a
#' request, ensures the request cannot be repeated with a changed
#' parameter. If a request is received with the same parameters and a token
#' is included, the request returns information about the initial request
#' that used that token.
#' 
#' The AWS SDKs prepopulate client request tokens. If you are using an AWS
#' SDK, an idempotency token is created for you.
#'
#' @keywords internal
#'
#' @rdname codecommit_create_pull_request
codecommit_create_pull_request <- function(title, description = NULL, targets, clientRequestToken = NULL) {
  op <- new_operation(
    name = "CreatePullRequest",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$create_pull_request_input(title = title, description = description, targets = targets, clientRequestToken = clientRequestToken)
  output <- .codecommit$create_pull_request_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$create_pull_request <- codecommit_create_pull_request

#' Creates an approval rule for a pull request
#'
#' @description
#' Creates an approval rule for a pull request.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_create_pull_request_approval_rule/](https://www.paws-r-sdk.com/docs/codecommit_create_pull_request_approval_rule/) for full documentation.
#'
#' @param pullRequestId &#91;required&#93; The system-generated ID of the pull request for which you want to create
#' the approval rule.
#' @param approvalRuleName &#91;required&#93; The name for the approval rule.
#' @param approvalRuleContent &#91;required&#93; The content of the approval rule, including the number of approvals
#' needed and the structure of an approval pool defined for approvals, if
#' any. For more information about approval pools, see the AWS CodeCommit
#' User Guide.
#' 
#' When you create the content of the approval rule, you can specify
#' approvers in an approval pool in one of two ways:
#' 
#' -   **CodeCommitApprovers**: This option only requires an AWS account
#'     and a resource. It can be used for both IAM users and federated
#'     access users whose name matches the provided resource name. This is
#'     a very powerful option that offers a great deal of flexibility. For
#'     example, if you specify the AWS account *123456789012* and
#'     *Mary_Major*, all of the following would be counted as approvals
#'     coming from that user:
#' 
#'     -   An IAM user in the account
#'         (arn:aws:iam::*123456789012*:user/*Mary_Major*)
#' 
#'     -   A federated user identified in IAM as Mary_Major
#'         (arn:aws:sts::*123456789012*:federated-user/*Mary_Major*)
#' 
#'     This option does not recognize an active session of someone assuming
#'     the role of CodeCommitReview with a role session name of
#'     *Mary_Major*
#'     (arn:aws:sts::*123456789012*:assumed-role/CodeCommitReview/*Mary_Major*)
#'     unless you include a wildcard (*Mary_Major).
#' 
#' -   **Fully qualified ARN**: This option allows you to specify the fully
#'     qualified Amazon Resource Name (ARN) of the IAM user or role.
#' 
#' For more information about IAM ARNs, wildcards, and formats, see [IAM
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
#' in the *IAM User Guide*.
#'
#' @keywords internal
#'
#' @rdname codecommit_create_pull_request_approval_rule
codecommit_create_pull_request_approval_rule <- function(pullRequestId, approvalRuleName, approvalRuleContent) {
  op <- new_operation(
    name = "CreatePullRequestApprovalRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$create_pull_request_approval_rule_input(pullRequestId = pullRequestId, approvalRuleName = approvalRuleName, approvalRuleContent = approvalRuleContent)
  output <- .codecommit$create_pull_request_approval_rule_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$create_pull_request_approval_rule <- codecommit_create_pull_request_approval_rule

#' Creates a new, empty repository
#'
#' @description
#' Creates a new, empty repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_create_repository/](https://www.paws-r-sdk.com/docs/codecommit_create_repository/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the new repository to be created.
#' 
#' The repository name must be unique across the calling AWS account.
#' Repository names are limited to 100 alphanumeric, dash, and underscore
#' characters, and cannot include certain characters. For more information
#' about the limits on repository names, see
#' [Limits](https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html)
#' in the *AWS CodeCommit User Guide*. The suffix .git is prohibited.
#' @param repositoryDescription A comment or description about the new repository.
#' 
#' The description field for a repository accepts all HTML characters and
#' all valid Unicode characters. Applications that do not HTML-encode the
#' description and display it in a webpage can expose users to potentially
#' malicious code. Make sure that you HTML-encode the description field in
#' any application that uses this API to display the repository description
#' on a webpage.
#' @param tags One or more tag key-value pairs to use when tagging this repository.
#'
#' @keywords internal
#'
#' @rdname codecommit_create_repository
codecommit_create_repository <- function(repositoryName, repositoryDescription = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$create_repository_input(repositoryName = repositoryName, repositoryDescription = repositoryDescription, tags = tags)
  output <- .codecommit$create_repository_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$create_repository <- codecommit_create_repository

#' Creates an unreferenced commit that represents the result of merging two
#' branches using a specified merge strategy
#'
#' @description
#' Creates an unreferenced commit that represents the result of merging two branches using a specified merge strategy. This can help you determine the outcome of a potential merge. This API cannot be used with the fast-forward merge strategy because that strategy does not create a merge commit.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_create_unreferenced_merge_commit/](https://www.paws-r-sdk.com/docs/codecommit_create_unreferenced_merge_commit/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository where you want to create the unreferenced
#' merge commit.
#' @param sourceCommitSpecifier &#91;required&#93; The branch, tag, HEAD, or other fully qualified reference used to
#' identify a commit (for example, a branch name or a full commit ID).
#' @param destinationCommitSpecifier &#91;required&#93; The branch, tag, HEAD, or other fully qualified reference used to
#' identify a commit (for example, a branch name or a full commit ID).
#' @param mergeOption &#91;required&#93; The merge option or strategy you want to use to merge the code.
#' @param conflictDetailLevel The level of conflict detail to use. If unspecified, the default
#' FILE_LEVEL is used, which returns a not-mergeable result if the same
#' file has differences in both branches. If LINE_LEVEL is specified, a
#' conflict is considered not mergeable if the same file in both branches
#' has differences on the same line.
#' @param conflictResolutionStrategy Specifies which branch to use when resolving conflicts, or whether to
#' attempt automatically merging two versions of a file. The default is
#' NONE, which requires any conflicts to be resolved manually before the
#' merge operation is successful.
#' @param authorName The name of the author who created the unreferenced commit. This
#' information is used as both the author and committer for the commit.
#' @param email The email address for the person who created the unreferenced commit.
#' @param commitMessage The commit message for the unreferenced commit.
#' @param keepEmptyFolders If the commit contains deletions, whether to keep a folder or folder
#' structure if the changes leave the folders empty. If this is specified
#' as true, a .gitkeep file is created for empty folders. The default is
#' false.
#' @param conflictResolution If AUTOMERGE is the conflict resolution strategy, a list of inputs to
#' use when resolving conflicts during a merge.
#'
#' @keywords internal
#'
#' @rdname codecommit_create_unreferenced_merge_commit
codecommit_create_unreferenced_merge_commit <- function(repositoryName, sourceCommitSpecifier, destinationCommitSpecifier, mergeOption, conflictDetailLevel = NULL, conflictResolutionStrategy = NULL, authorName = NULL, email = NULL, commitMessage = NULL, keepEmptyFolders = NULL, conflictResolution = NULL) {
  op <- new_operation(
    name = "CreateUnreferencedMergeCommit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$create_unreferenced_merge_commit_input(repositoryName = repositoryName, sourceCommitSpecifier = sourceCommitSpecifier, destinationCommitSpecifier = destinationCommitSpecifier, mergeOption = mergeOption, conflictDetailLevel = conflictDetailLevel, conflictResolutionStrategy = conflictResolutionStrategy, authorName = authorName, email = email, commitMessage = commitMessage, keepEmptyFolders = keepEmptyFolders, conflictResolution = conflictResolution)
  output <- .codecommit$create_unreferenced_merge_commit_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$create_unreferenced_merge_commit <- codecommit_create_unreferenced_merge_commit

#' Deletes a specified approval rule template
#'
#' @description
#' Deletes a specified approval rule template. Deleting a template does not remove approval rules on pull requests already created with the template.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_delete_approval_rule_template/](https://www.paws-r-sdk.com/docs/codecommit_delete_approval_rule_template/) for full documentation.
#'
#' @param approvalRuleTemplateName &#91;required&#93; The name of the approval rule template to delete.
#'
#' @keywords internal
#'
#' @rdname codecommit_delete_approval_rule_template
codecommit_delete_approval_rule_template <- function(approvalRuleTemplateName) {
  op <- new_operation(
    name = "DeleteApprovalRuleTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$delete_approval_rule_template_input(approvalRuleTemplateName = approvalRuleTemplateName)
  output <- .codecommit$delete_approval_rule_template_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$delete_approval_rule_template <- codecommit_delete_approval_rule_template

#' Deletes a branch from a repository, unless that branch is the default
#' branch for the repository
#'
#' @description
#' Deletes a branch from a repository, unless that branch is the default branch for the repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_delete_branch/](https://www.paws-r-sdk.com/docs/codecommit_delete_branch/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository that contains the branch to be deleted.
#' @param branchName &#91;required&#93; The name of the branch to delete.
#'
#' @keywords internal
#'
#' @rdname codecommit_delete_branch
codecommit_delete_branch <- function(repositoryName, branchName) {
  op <- new_operation(
    name = "DeleteBranch",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$delete_branch_input(repositoryName = repositoryName, branchName = branchName)
  output <- .codecommit$delete_branch_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$delete_branch <- codecommit_delete_branch

#' Deletes the content of a comment made on a change, file, or commit in a
#' repository
#'
#' @description
#' Deletes the content of a comment made on a change, file, or commit in a repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_delete_comment_content/](https://www.paws-r-sdk.com/docs/codecommit_delete_comment_content/) for full documentation.
#'
#' @param commentId &#91;required&#93; The unique, system-generated ID of the comment. To get this ID, use
#' [`get_comments_for_compared_commit`][codecommit_get_comments_for_compared_commit]
#' or
#' [`get_comments_for_pull_request`][codecommit_get_comments_for_pull_request].
#'
#' @keywords internal
#'
#' @rdname codecommit_delete_comment_content
codecommit_delete_comment_content <- function(commentId) {
  op <- new_operation(
    name = "DeleteCommentContent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$delete_comment_content_input(commentId = commentId)
  output <- .codecommit$delete_comment_content_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$delete_comment_content <- codecommit_delete_comment_content

#' Deletes a specified file from a specified branch
#'
#' @description
#' Deletes a specified file from a specified branch. A commit is created on the branch that contains the revision. The file still exists in the commits earlier to the commit that contains the deletion.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_delete_file/](https://www.paws-r-sdk.com/docs/codecommit_delete_file/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository that contains the file to delete.
#' @param branchName &#91;required&#93; The name of the branch where the commit that deletes the file is made.
#' @param filePath &#91;required&#93; The fully qualified path to the file that to be deleted, including the
#' full name and extension of that file. For example, /examples/file.md is
#' a fully qualified path to a file named file.md in a folder named
#' examples.
#' @param parentCommitId &#91;required&#93; The ID of the commit that is the tip of the branch where you want to
#' create the commit that deletes the file. This must be the HEAD commit
#' for the branch. The commit that deletes the file is created from this
#' commit ID.
#' @param keepEmptyFolders If a file is the only object in the folder or directory, specifies
#' whether to delete the folder or directory that contains the file. By
#' default, empty folders are deleted. This includes empty folders that are
#' part of the directory structure. For example, if the path to a file is
#' dir1/dir2/dir3/dir4, and dir2 and dir3 are empty, deleting the last file
#' in dir4 also deletes the empty folders dir4, dir3, and dir2.
#' @param commitMessage The commit message you want to include as part of deleting the file.
#' Commit messages are limited to 256 KB. If no message is specified, a
#' default message is used.
#' @param name The name of the author of the commit that deletes the file. If no name
#' is specified, the user's ARN is used as the author name and committer
#' name.
#' @param email The email address for the commit that deletes the file. If no email
#' address is specified, the email address is left blank.
#'
#' @keywords internal
#'
#' @rdname codecommit_delete_file
codecommit_delete_file <- function(repositoryName, branchName, filePath, parentCommitId, keepEmptyFolders = NULL, commitMessage = NULL, name = NULL, email = NULL) {
  op <- new_operation(
    name = "DeleteFile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$delete_file_input(repositoryName = repositoryName, branchName = branchName, filePath = filePath, parentCommitId = parentCommitId, keepEmptyFolders = keepEmptyFolders, commitMessage = commitMessage, name = name, email = email)
  output <- .codecommit$delete_file_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$delete_file <- codecommit_delete_file

#' Deletes an approval rule from a specified pull request
#'
#' @description
#' Deletes an approval rule from a specified pull request. Approval rules can be deleted from a pull request only if the pull request is open, and if the approval rule was created specifically for a pull request and not generated from an approval rule template associated with the repository where the pull request was created. You cannot delete an approval rule from a merged or closed pull request.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_delete_pull_request_approval_rule/](https://www.paws-r-sdk.com/docs/codecommit_delete_pull_request_approval_rule/) for full documentation.
#'
#' @param pullRequestId &#91;required&#93; The system-generated ID of the pull request that contains the approval
#' rule you want to delete.
#' @param approvalRuleName &#91;required&#93; The name of the approval rule you want to delete.
#'
#' @keywords internal
#'
#' @rdname codecommit_delete_pull_request_approval_rule
codecommit_delete_pull_request_approval_rule <- function(pullRequestId, approvalRuleName) {
  op <- new_operation(
    name = "DeletePullRequestApprovalRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$delete_pull_request_approval_rule_input(pullRequestId = pullRequestId, approvalRuleName = approvalRuleName)
  output <- .codecommit$delete_pull_request_approval_rule_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$delete_pull_request_approval_rule <- codecommit_delete_pull_request_approval_rule

#' Deletes a repository
#'
#' @description
#' Deletes a repository. If a specified repository was already deleted, a null repository ID is returned.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_delete_repository/](https://www.paws-r-sdk.com/docs/codecommit_delete_repository/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository to delete.
#'
#' @keywords internal
#'
#' @rdname codecommit_delete_repository
codecommit_delete_repository <- function(repositoryName) {
  op <- new_operation(
    name = "DeleteRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$delete_repository_input(repositoryName = repositoryName)
  output <- .codecommit$delete_repository_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$delete_repository <- codecommit_delete_repository

#' Returns information about one or more merge conflicts in the attempted
#' merge of two commit specifiers using the squash or three-way merge
#' strategy
#'
#' @description
#' Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the squash or three-way merge strategy. If the merge option for the attempted merge is specified as FAST_FORWARD_MERGE, an exception is thrown.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_describe_merge_conflicts/](https://www.paws-r-sdk.com/docs/codecommit_describe_merge_conflicts/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository where you want to get information about a
#' merge conflict.
#' @param destinationCommitSpecifier &#91;required&#93; The branch, tag, HEAD, or other fully qualified reference used to
#' identify a commit (for example, a branch name or a full commit ID).
#' @param sourceCommitSpecifier &#91;required&#93; The branch, tag, HEAD, or other fully qualified reference used to
#' identify a commit (for example, a branch name or a full commit ID).
#' @param mergeOption &#91;required&#93; The merge option or strategy you want to use to merge the code.
#' @param maxMergeHunks The maximum number of merge hunks to include in the output.
#' @param filePath &#91;required&#93; The path of the target files used to describe the conflicts.
#' @param conflictDetailLevel The level of conflict detail to use. If unspecified, the default
#' FILE_LEVEL is used, which returns a not-mergeable result if the same
#' file has differences in both branches. If LINE_LEVEL is specified, a
#' conflict is considered not mergeable if the same file in both branches
#' has differences on the same line.
#' @param conflictResolutionStrategy Specifies which branch to use when resolving conflicts, or whether to
#' attempt automatically merging two versions of a file. The default is
#' NONE, which requires any conflicts to be resolved manually before the
#' merge operation is successful.
#' @param nextToken An enumeration token that, when provided in a request, returns the next
#' batch of the results.
#'
#' @keywords internal
#'
#' @rdname codecommit_describe_merge_conflicts
codecommit_describe_merge_conflicts <- function(repositoryName, destinationCommitSpecifier, sourceCommitSpecifier, mergeOption, maxMergeHunks = NULL, filePath, conflictDetailLevel = NULL, conflictResolutionStrategy = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeMergeConflicts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$describe_merge_conflicts_input(repositoryName = repositoryName, destinationCommitSpecifier = destinationCommitSpecifier, sourceCommitSpecifier = sourceCommitSpecifier, mergeOption = mergeOption, maxMergeHunks = maxMergeHunks, filePath = filePath, conflictDetailLevel = conflictDetailLevel, conflictResolutionStrategy = conflictResolutionStrategy, nextToken = nextToken)
  output <- .codecommit$describe_merge_conflicts_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$describe_merge_conflicts <- codecommit_describe_merge_conflicts

#' Returns information about one or more pull request events
#'
#' @description
#' Returns information about one or more pull request events.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_describe_pull_request_events/](https://www.paws-r-sdk.com/docs/codecommit_describe_pull_request_events/) for full documentation.
#'
#' @param pullRequestId &#91;required&#93; The system-generated ID of the pull request. To get this ID, use
#' [`list_pull_requests`][codecommit_list_pull_requests].
#' @param pullRequestEventType Optional. The pull request event type about which you want to return
#' information.
#' @param actorArn The Amazon Resource Name (ARN) of the user whose actions resulted in the
#' event. Examples include updating the pull request with more commits or
#' changing the status of a pull request.
#' @param nextToken An enumeration token that, when provided in a request, returns the next
#' batch of the results.
#' @param maxResults A non-zero, non-negative integer used to limit the number of returned
#' results. The default is 100 events, which is also the maximum number of
#' events that can be returned in a result.
#'
#' @keywords internal
#'
#' @rdname codecommit_describe_pull_request_events
codecommit_describe_pull_request_events <- function(pullRequestId, pullRequestEventType = NULL, actorArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribePullRequestEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$describe_pull_request_events_input(pullRequestId = pullRequestId, pullRequestEventType = pullRequestEventType, actorArn = actorArn, nextToken = nextToken, maxResults = maxResults)
  output <- .codecommit$describe_pull_request_events_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$describe_pull_request_events <- codecommit_describe_pull_request_events

#' Removes the association between a template and a repository so that
#' approval rules based on the template are not automatically created when
#' pull requests are created in the specified repository
#'
#' @description
#' Removes the association between a template and a repository so that approval rules based on the template are not automatically created when pull requests are created in the specified repository. This does not delete any approval rules previously created for pull requests through the template association.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_disassociate_approval_rule_template_from_repository/](https://www.paws-r-sdk.com/docs/codecommit_disassociate_approval_rule_template_from_repository/) for full documentation.
#'
#' @param approvalRuleTemplateName &#91;required&#93; The name of the approval rule template to disassociate from a specified
#' repository.
#' @param repositoryName &#91;required&#93; The name of the repository you want to disassociate from the template.
#'
#' @keywords internal
#'
#' @rdname codecommit_disass_approv_rule_templa_from_reposi
codecommit_disassociate_approval_rule_template_from_repository <- function(approvalRuleTemplateName, repositoryName) {
  op <- new_operation(
    name = "DisassociateApprovalRuleTemplateFromRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$disassociate_approval_rule_template_from_repository_input(approvalRuleTemplateName = approvalRuleTemplateName, repositoryName = repositoryName)
  output <- .codecommit$disassociate_approval_rule_template_from_repository_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$disassociate_approval_rule_template_from_repository <- codecommit_disassociate_approval_rule_template_from_repository

#' Evaluates whether a pull request has met all the conditions specified in
#' its associated approval rules
#'
#' @description
#' Evaluates whether a pull request has met all the conditions specified in its associated approval rules.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_evaluate_pull_request_approval_rules/](https://www.paws-r-sdk.com/docs/codecommit_evaluate_pull_request_approval_rules/) for full documentation.
#'
#' @param pullRequestId &#91;required&#93; The system-generated ID of the pull request you want to evaluate.
#' @param revisionId &#91;required&#93; The system-generated ID for the pull request revision. To retrieve the
#' most recent revision ID for a pull request, use
#' [`get_pull_request`][codecommit_get_pull_request].
#'
#' @keywords internal
#'
#' @rdname codecommit_evaluate_pull_request_approval_rules
codecommit_evaluate_pull_request_approval_rules <- function(pullRequestId, revisionId) {
  op <- new_operation(
    name = "EvaluatePullRequestApprovalRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$evaluate_pull_request_approval_rules_input(pullRequestId = pullRequestId, revisionId = revisionId)
  output <- .codecommit$evaluate_pull_request_approval_rules_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$evaluate_pull_request_approval_rules <- codecommit_evaluate_pull_request_approval_rules

#' Returns information about a specified approval rule template
#'
#' @description
#' Returns information about a specified approval rule template.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_get_approval_rule_template/](https://www.paws-r-sdk.com/docs/codecommit_get_approval_rule_template/) for full documentation.
#'
#' @param approvalRuleTemplateName &#91;required&#93; The name of the approval rule template for which you want to get
#' information.
#'
#' @keywords internal
#'
#' @rdname codecommit_get_approval_rule_template
codecommit_get_approval_rule_template <- function(approvalRuleTemplateName) {
  op <- new_operation(
    name = "GetApprovalRuleTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$get_approval_rule_template_input(approvalRuleTemplateName = approvalRuleTemplateName)
  output <- .codecommit$get_approval_rule_template_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$get_approval_rule_template <- codecommit_get_approval_rule_template

#' Returns the base-64 encoded content of an individual blob in a
#' repository
#'
#' @description
#' Returns the base-64 encoded content of an individual blob in a repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_get_blob/](https://www.paws-r-sdk.com/docs/codecommit_get_blob/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository that contains the blob.
#' @param blobId &#91;required&#93; The ID of the blob, which is its SHA-1 pointer.
#'
#' @keywords internal
#'
#' @rdname codecommit_get_blob
codecommit_get_blob <- function(repositoryName, blobId) {
  op <- new_operation(
    name = "GetBlob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$get_blob_input(repositoryName = repositoryName, blobId = blobId)
  output <- .codecommit$get_blob_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$get_blob <- codecommit_get_blob

#' Returns information about a repository branch, including its name and
#' the last commit ID
#'
#' @description
#' Returns information about a repository branch, including its name and the last commit ID.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_get_branch/](https://www.paws-r-sdk.com/docs/codecommit_get_branch/) for full documentation.
#'
#' @param repositoryName The name of the repository that contains the branch for which you want
#' to retrieve information.
#' @param branchName The name of the branch for which you want to retrieve information.
#'
#' @keywords internal
#'
#' @rdname codecommit_get_branch
codecommit_get_branch <- function(repositoryName = NULL, branchName = NULL) {
  op <- new_operation(
    name = "GetBranch",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$get_branch_input(repositoryName = repositoryName, branchName = branchName)
  output <- .codecommit$get_branch_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$get_branch <- codecommit_get_branch

#' Returns the content of a comment made on a change, file, or commit in a
#' repository
#'
#' @description
#' Returns the content of a comment made on a change, file, or commit in a repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_get_comment/](https://www.paws-r-sdk.com/docs/codecommit_get_comment/) for full documentation.
#'
#' @param commentId &#91;required&#93; The unique, system-generated ID of the comment. To get this ID, use
#' [`get_comments_for_compared_commit`][codecommit_get_comments_for_compared_commit]
#' or
#' [`get_comments_for_pull_request`][codecommit_get_comments_for_pull_request].
#'
#' @keywords internal
#'
#' @rdname codecommit_get_comment
codecommit_get_comment <- function(commentId) {
  op <- new_operation(
    name = "GetComment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$get_comment_input(commentId = commentId)
  output <- .codecommit$get_comment_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$get_comment <- codecommit_get_comment

#' Returns information about reactions to a specified comment ID
#'
#' @description
#' Returns information about reactions to a specified comment ID. Reactions from users who have been deleted will not be included in the count.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_get_comment_reactions/](https://www.paws-r-sdk.com/docs/codecommit_get_comment_reactions/) for full documentation.
#'
#' @param commentId &#91;required&#93; The ID of the comment for which you want to get reactions information.
#' @param reactionUserArn Optional. The Amazon Resource Name (ARN) of the user or identity for
#' which you want to get reaction information.
#' @param nextToken An enumeration token that, when provided in a request, returns the next
#' batch of the results.
#' @param maxResults A non-zero, non-negative integer used to limit the number of returned
#' results. The default is the same as the allowed maximum, 1,000.
#'
#' @keywords internal
#'
#' @rdname codecommit_get_comment_reactions
codecommit_get_comment_reactions <- function(commentId, reactionUserArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetCommentReactions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$get_comment_reactions_input(commentId = commentId, reactionUserArn = reactionUserArn, nextToken = nextToken, maxResults = maxResults)
  output <- .codecommit$get_comment_reactions_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$get_comment_reactions <- codecommit_get_comment_reactions

#' Returns information about comments made on the comparison between two
#' commits
#'
#' @description
#' Returns information about comments made on the comparison between two commits.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_get_comments_for_compared_commit/](https://www.paws-r-sdk.com/docs/codecommit_get_comments_for_compared_commit/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository where you want to compare commits.
#' @param beforeCommitId To establish the directionality of the comparison, the full commit ID of
#' the before commit.
#' @param afterCommitId &#91;required&#93; To establish the directionality of the comparison, the full commit ID of
#' the after commit.
#' @param nextToken An enumeration token that when provided in a request, returns the next
#' batch of the results.
#' @param maxResults A non-zero, non-negative integer used to limit the number of returned
#' results. The default is 100 comments, but you can configure up to 500.
#'
#' @keywords internal
#'
#' @rdname codecommit_get_comments_for_compared_commit
codecommit_get_comments_for_compared_commit <- function(repositoryName, beforeCommitId = NULL, afterCommitId, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetCommentsForComparedCommit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$get_comments_for_compared_commit_input(repositoryName = repositoryName, beforeCommitId = beforeCommitId, afterCommitId = afterCommitId, nextToken = nextToken, maxResults = maxResults)
  output <- .codecommit$get_comments_for_compared_commit_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$get_comments_for_compared_commit <- codecommit_get_comments_for_compared_commit

#' Returns comments made on a pull request
#'
#' @description
#' Returns comments made on a pull request.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_get_comments_for_pull_request/](https://www.paws-r-sdk.com/docs/codecommit_get_comments_for_pull_request/) for full documentation.
#'
#' @param pullRequestId &#91;required&#93; The system-generated ID of the pull request. To get this ID, use
#' [`list_pull_requests`][codecommit_list_pull_requests].
#' @param repositoryName The name of the repository that contains the pull request.
#' @param beforeCommitId The full commit ID of the commit in the destination branch that was the
#' tip of the branch at the time the pull request was created.
#' @param afterCommitId The full commit ID of the commit in the source branch that was the tip
#' of the branch at the time the comment was made.
#' @param nextToken An enumeration token that, when provided in a request, returns the next
#' batch of the results.
#' @param maxResults A non-zero, non-negative integer used to limit the number of returned
#' results. The default is 100 comments. You can return up to 500 comments
#' with a single request.
#'
#' @keywords internal
#'
#' @rdname codecommit_get_comments_for_pull_request
codecommit_get_comments_for_pull_request <- function(pullRequestId, repositoryName = NULL, beforeCommitId = NULL, afterCommitId = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetCommentsForPullRequest",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$get_comments_for_pull_request_input(pullRequestId = pullRequestId, repositoryName = repositoryName, beforeCommitId = beforeCommitId, afterCommitId = afterCommitId, nextToken = nextToken, maxResults = maxResults)
  output <- .codecommit$get_comments_for_pull_request_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$get_comments_for_pull_request <- codecommit_get_comments_for_pull_request

#' Returns information about a commit, including commit message and
#' committer information
#'
#' @description
#' Returns information about a commit, including commit message and committer information.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_get_commit/](https://www.paws-r-sdk.com/docs/codecommit_get_commit/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository to which the commit was made.
#' @param commitId &#91;required&#93; The commit ID. Commit IDs are the full SHA ID of the commit.
#'
#' @keywords internal
#'
#' @rdname codecommit_get_commit
codecommit_get_commit <- function(repositoryName, commitId) {
  op <- new_operation(
    name = "GetCommit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$get_commit_input(repositoryName = repositoryName, commitId = commitId)
  output <- .codecommit$get_commit_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$get_commit <- codecommit_get_commit

#' Returns information about the differences in a valid commit specifier
#' (such as a branch, tag, HEAD, commit ID, or other fully qualified
#' reference)
#'
#' @description
#' Returns information about the differences in a valid commit specifier (such as a branch, tag, HEAD, commit ID, or other fully qualified reference). Results can be limited to a specified path.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_get_differences/](https://www.paws-r-sdk.com/docs/codecommit_get_differences/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository where you want to get differences.
#' @param beforeCommitSpecifier The branch, tag, HEAD, or other fully qualified reference used to
#' identify a commit (for example, the full commit ID). Optional. If not
#' specified, all changes before the `afterCommitSpecifier` value are
#' shown. If you do not use `beforeCommitSpecifier` in your request,
#' consider limiting the results with `maxResults`.
#' @param afterCommitSpecifier &#91;required&#93; The branch, tag, HEAD, or other fully qualified reference used to
#' identify a commit.
#' @param beforePath The file path in which to check for differences. Limits the results to
#' this path. Can also be used to specify the previous name of a directory
#' or folder. If `beforePath` and `afterPath` are not specified,
#' differences are shown for all paths.
#' @param afterPath The file path in which to check differences. Limits the results to this
#' path. Can also be used to specify the changed name of a directory or
#' folder, if it has changed. If not specified, differences are shown for
#' all paths.
#' @param MaxResults A non-zero, non-negative integer used to limit the number of returned
#' results.
#' @param NextToken An enumeration token that, when provided in a request, returns the next
#' batch of the results.
#'
#' @keywords internal
#'
#' @rdname codecommit_get_differences
codecommit_get_differences <- function(repositoryName, beforeCommitSpecifier = NULL, afterCommitSpecifier, beforePath = NULL, afterPath = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetDifferences",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$get_differences_input(repositoryName = repositoryName, beforeCommitSpecifier = beforeCommitSpecifier, afterCommitSpecifier = afterCommitSpecifier, beforePath = beforePath, afterPath = afterPath, MaxResults = MaxResults, NextToken = NextToken)
  output <- .codecommit$get_differences_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$get_differences <- codecommit_get_differences

#' Returns the base-64 encoded contents of a specified file and its
#' metadata
#'
#' @description
#' Returns the base-64 encoded contents of a specified file and its metadata.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_get_file/](https://www.paws-r-sdk.com/docs/codecommit_get_file/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository that contains the file.
#' @param commitSpecifier The fully quaified reference that identifies the commit that contains
#' the file. For example, you can specify a full commit ID, a tag, a branch
#' name, or a reference such as refs/heads/master. If none is provided, the
#' head commit is used.
#' @param filePath &#91;required&#93; The fully qualified path to the file, including the full name and
#' extension of the file. For example, /examples/file.md is the fully
#' qualified path to a file named file.md in a folder named examples.
#'
#' @keywords internal
#'
#' @rdname codecommit_get_file
codecommit_get_file <- function(repositoryName, commitSpecifier = NULL, filePath) {
  op <- new_operation(
    name = "GetFile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$get_file_input(repositoryName = repositoryName, commitSpecifier = commitSpecifier, filePath = filePath)
  output <- .codecommit$get_file_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$get_file <- codecommit_get_file

#' Returns the contents of a specified folder in a repository
#'
#' @description
#' Returns the contents of a specified folder in a repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_get_folder/](https://www.paws-r-sdk.com/docs/codecommit_get_folder/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository.
#' @param commitSpecifier A fully qualified reference used to identify a commit that contains the
#' version of the folder's content to return. A fully qualified reference
#' can be a commit ID, branch name, tag, or reference such as HEAD. If no
#' specifier is provided, the folder content is returned as it exists in
#' the HEAD commit.
#' @param folderPath &#91;required&#93; The fully qualified path to the folder whose contents are returned,
#' including the folder name. For example, /examples is a fully-qualified
#' path to a folder named examples that was created off of the root
#' directory (/) of a repository.
#'
#' @keywords internal
#'
#' @rdname codecommit_get_folder
codecommit_get_folder <- function(repositoryName, commitSpecifier = NULL, folderPath) {
  op <- new_operation(
    name = "GetFolder",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$get_folder_input(repositoryName = repositoryName, commitSpecifier = commitSpecifier, folderPath = folderPath)
  output <- .codecommit$get_folder_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$get_folder <- codecommit_get_folder

#' Returns information about a specified merge commit
#'
#' @description
#' Returns information about a specified merge commit.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_get_merge_commit/](https://www.paws-r-sdk.com/docs/codecommit_get_merge_commit/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository that contains the merge commit about which
#' you want to get information.
#' @param sourceCommitSpecifier &#91;required&#93; The branch, tag, HEAD, or other fully qualified reference used to
#' identify a commit (for example, a branch name or a full commit ID).
#' @param destinationCommitSpecifier &#91;required&#93; The branch, tag, HEAD, or other fully qualified reference used to
#' identify a commit (for example, a branch name or a full commit ID).
#' @param conflictDetailLevel The level of conflict detail to use. If unspecified, the default
#' FILE_LEVEL is used, which returns a not-mergeable result if the same
#' file has differences in both branches. If LINE_LEVEL is specified, a
#' conflict is considered not mergeable if the same file in both branches
#' has differences on the same line.
#' @param conflictResolutionStrategy Specifies which branch to use when resolving conflicts, or whether to
#' attempt automatically merging two versions of a file. The default is
#' NONE, which requires any conflicts to be resolved manually before the
#' merge operation is successful.
#'
#' @keywords internal
#'
#' @rdname codecommit_get_merge_commit
codecommit_get_merge_commit <- function(repositoryName, sourceCommitSpecifier, destinationCommitSpecifier, conflictDetailLevel = NULL, conflictResolutionStrategy = NULL) {
  op <- new_operation(
    name = "GetMergeCommit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$get_merge_commit_input(repositoryName = repositoryName, sourceCommitSpecifier = sourceCommitSpecifier, destinationCommitSpecifier = destinationCommitSpecifier, conflictDetailLevel = conflictDetailLevel, conflictResolutionStrategy = conflictResolutionStrategy)
  output <- .codecommit$get_merge_commit_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$get_merge_commit <- codecommit_get_merge_commit

#' Returns information about merge conflicts between the before and after
#' commit IDs for a pull request in a repository
#'
#' @description
#' Returns information about merge conflicts between the before and after commit IDs for a pull request in a repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_get_merge_conflicts/](https://www.paws-r-sdk.com/docs/codecommit_get_merge_conflicts/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository where the pull request was created.
#' @param destinationCommitSpecifier &#91;required&#93; The branch, tag, HEAD, or other fully qualified reference used to
#' identify a commit (for example, a branch name or a full commit ID).
#' @param sourceCommitSpecifier &#91;required&#93; The branch, tag, HEAD, or other fully qualified reference used to
#' identify a commit (for example, a branch name or a full commit ID).
#' @param mergeOption &#91;required&#93; The merge option or strategy you want to use to merge the code.
#' @param conflictDetailLevel The level of conflict detail to use. If unspecified, the default
#' FILE_LEVEL is used, which returns a not-mergeable result if the same
#' file has differences in both branches. If LINE_LEVEL is specified, a
#' conflict is considered not mergeable if the same file in both branches
#' has differences on the same line.
#' @param maxConflictFiles The maximum number of files to include in the output.
#' @param conflictResolutionStrategy Specifies which branch to use when resolving conflicts, or whether to
#' attempt automatically merging two versions of a file. The default is
#' NONE, which requires any conflicts to be resolved manually before the
#' merge operation is successful.
#' @param nextToken An enumeration token that, when provided in a request, returns the next
#' batch of the results.
#'
#' @keywords internal
#'
#' @rdname codecommit_get_merge_conflicts
codecommit_get_merge_conflicts <- function(repositoryName, destinationCommitSpecifier, sourceCommitSpecifier, mergeOption, conflictDetailLevel = NULL, maxConflictFiles = NULL, conflictResolutionStrategy = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "GetMergeConflicts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$get_merge_conflicts_input(repositoryName = repositoryName, destinationCommitSpecifier = destinationCommitSpecifier, sourceCommitSpecifier = sourceCommitSpecifier, mergeOption = mergeOption, conflictDetailLevel = conflictDetailLevel, maxConflictFiles = maxConflictFiles, conflictResolutionStrategy = conflictResolutionStrategy, nextToken = nextToken)
  output <- .codecommit$get_merge_conflicts_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$get_merge_conflicts <- codecommit_get_merge_conflicts

#' Returns information about the merge options available for merging two
#' specified branches
#'
#' @description
#' Returns information about the merge options available for merging two specified branches. For details about why a merge option is not available, use GetMergeConflicts or DescribeMergeConflicts.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_get_merge_options/](https://www.paws-r-sdk.com/docs/codecommit_get_merge_options/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository that contains the commits about which you
#' want to get merge options.
#' @param sourceCommitSpecifier &#91;required&#93; The branch, tag, HEAD, or other fully qualified reference used to
#' identify a commit (for example, a branch name or a full commit ID).
#' @param destinationCommitSpecifier &#91;required&#93; The branch, tag, HEAD, or other fully qualified reference used to
#' identify a commit (for example, a branch name or a full commit ID).
#' @param conflictDetailLevel The level of conflict detail to use. If unspecified, the default
#' FILE_LEVEL is used, which returns a not-mergeable result if the same
#' file has differences in both branches. If LINE_LEVEL is specified, a
#' conflict is considered not mergeable if the same file in both branches
#' has differences on the same line.
#' @param conflictResolutionStrategy Specifies which branch to use when resolving conflicts, or whether to
#' attempt automatically merging two versions of a file. The default is
#' NONE, which requires any conflicts to be resolved manually before the
#' merge operation is successful.
#'
#' @keywords internal
#'
#' @rdname codecommit_get_merge_options
codecommit_get_merge_options <- function(repositoryName, sourceCommitSpecifier, destinationCommitSpecifier, conflictDetailLevel = NULL, conflictResolutionStrategy = NULL) {
  op <- new_operation(
    name = "GetMergeOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$get_merge_options_input(repositoryName = repositoryName, sourceCommitSpecifier = sourceCommitSpecifier, destinationCommitSpecifier = destinationCommitSpecifier, conflictDetailLevel = conflictDetailLevel, conflictResolutionStrategy = conflictResolutionStrategy)
  output <- .codecommit$get_merge_options_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$get_merge_options <- codecommit_get_merge_options

#' Gets information about a pull request in a specified repository
#'
#' @description
#' Gets information about a pull request in a specified repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_get_pull_request/](https://www.paws-r-sdk.com/docs/codecommit_get_pull_request/) for full documentation.
#'
#' @param pullRequestId &#91;required&#93; The system-generated ID of the pull request. To get this ID, use
#' [`list_pull_requests`][codecommit_list_pull_requests].
#'
#' @keywords internal
#'
#' @rdname codecommit_get_pull_request
codecommit_get_pull_request <- function(pullRequestId) {
  op <- new_operation(
    name = "GetPullRequest",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$get_pull_request_input(pullRequestId = pullRequestId)
  output <- .codecommit$get_pull_request_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$get_pull_request <- codecommit_get_pull_request

#' Gets information about the approval states for a specified pull request
#'
#' @description
#' Gets information about the approval states for a specified pull request. Approval states only apply to pull requests that have one or more approval rules applied to them.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_get_pull_request_approval_states/](https://www.paws-r-sdk.com/docs/codecommit_get_pull_request_approval_states/) for full documentation.
#'
#' @param pullRequestId &#91;required&#93; The system-generated ID for the pull request.
#' @param revisionId &#91;required&#93; The system-generated ID for the pull request revision.
#'
#' @keywords internal
#'
#' @rdname codecommit_get_pull_request_approval_states
codecommit_get_pull_request_approval_states <- function(pullRequestId, revisionId) {
  op <- new_operation(
    name = "GetPullRequestApprovalStates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$get_pull_request_approval_states_input(pullRequestId = pullRequestId, revisionId = revisionId)
  output <- .codecommit$get_pull_request_approval_states_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$get_pull_request_approval_states <- codecommit_get_pull_request_approval_states

#' Returns information about whether approval rules have been set aside
#' (overridden) for a pull request, and if so, the Amazon Resource Name
#' (ARN) of the user or identity that overrode the rules and their
#' requirements for the pull request
#'
#' @description
#' Returns information about whether approval rules have been set aside (overridden) for a pull request, and if so, the Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the pull request.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_get_pull_request_override_state/](https://www.paws-r-sdk.com/docs/codecommit_get_pull_request_override_state/) for full documentation.
#'
#' @param pullRequestId &#91;required&#93; The ID of the pull request for which you want to get information about
#' whether approval rules have been set aside (overridden).
#' @param revisionId &#91;required&#93; The system-generated ID of the revision for the pull request. To
#' retrieve the most recent revision ID, use
#' [`get_pull_request`][codecommit_get_pull_request].
#'
#' @keywords internal
#'
#' @rdname codecommit_get_pull_request_override_state
codecommit_get_pull_request_override_state <- function(pullRequestId, revisionId) {
  op <- new_operation(
    name = "GetPullRequestOverrideState",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$get_pull_request_override_state_input(pullRequestId = pullRequestId, revisionId = revisionId)
  output <- .codecommit$get_pull_request_override_state_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$get_pull_request_override_state <- codecommit_get_pull_request_override_state

#' Returns information about a repository
#'
#' @description
#' Returns information about a repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_get_repository/](https://www.paws-r-sdk.com/docs/codecommit_get_repository/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository to get information about.
#'
#' @keywords internal
#'
#' @rdname codecommit_get_repository
codecommit_get_repository <- function(repositoryName) {
  op <- new_operation(
    name = "GetRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$get_repository_input(repositoryName = repositoryName)
  output <- .codecommit$get_repository_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$get_repository <- codecommit_get_repository

#' Gets information about triggers configured for a repository
#'
#' @description
#' Gets information about triggers configured for a repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_get_repository_triggers/](https://www.paws-r-sdk.com/docs/codecommit_get_repository_triggers/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository for which the trigger is configured.
#'
#' @keywords internal
#'
#' @rdname codecommit_get_repository_triggers
codecommit_get_repository_triggers <- function(repositoryName) {
  op <- new_operation(
    name = "GetRepositoryTriggers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$get_repository_triggers_input(repositoryName = repositoryName)
  output <- .codecommit$get_repository_triggers_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$get_repository_triggers <- codecommit_get_repository_triggers

#' Lists all approval rule templates in the specified AWS Region in your
#' AWS account
#'
#' @description
#' Lists all approval rule templates in the specified AWS Region in your AWS account. If an AWS Region is not specified, the AWS Region where you are signed in is used.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_list_approval_rule_templates/](https://www.paws-r-sdk.com/docs/codecommit_list_approval_rule_templates/) for full documentation.
#'
#' @param nextToken An enumeration token that, when provided in a request, returns the next
#' batch of the results.
#' @param maxResults A non-zero, non-negative integer used to limit the number of returned
#' results.
#'
#' @keywords internal
#'
#' @rdname codecommit_list_approval_rule_templates
codecommit_list_approval_rule_templates <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListApprovalRuleTemplates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$list_approval_rule_templates_input(nextToken = nextToken, maxResults = maxResults)
  output <- .codecommit$list_approval_rule_templates_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$list_approval_rule_templates <- codecommit_list_approval_rule_templates

#' Lists all approval rule templates that are associated with a specified
#' repository
#'
#' @description
#' Lists all approval rule templates that are associated with a specified repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_list_associated_approval_rule_templates_for_repository/](https://www.paws-r-sdk.com/docs/codecommit_list_associated_approval_rule_templates_for_repository/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository for which you want to list all associated
#' approval rule templates.
#' @param nextToken An enumeration token that, when provided in a request, returns the next
#' batch of the results.
#' @param maxResults A non-zero, non-negative integer used to limit the number of returned
#' results.
#'
#' @keywords internal
#'
#' @rdname codecommit_list_associ_approv_rule_templa_for_reposi
codecommit_list_associated_approval_rule_templates_for_repository <- function(repositoryName, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAssociatedApprovalRuleTemplatesForRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$list_associated_approval_rule_templates_for_repository_input(repositoryName = repositoryName, nextToken = nextToken, maxResults = maxResults)
  output <- .codecommit$list_associated_approval_rule_templates_for_repository_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$list_associated_approval_rule_templates_for_repository <- codecommit_list_associated_approval_rule_templates_for_repository

#' Gets information about one or more branches in a repository
#'
#' @description
#' Gets information about one or more branches in a repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_list_branches/](https://www.paws-r-sdk.com/docs/codecommit_list_branches/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository that contains the branches.
#' @param nextToken An enumeration token that allows the operation to batch the results.
#'
#' @keywords internal
#'
#' @rdname codecommit_list_branches
codecommit_list_branches <- function(repositoryName, nextToken = NULL) {
  op <- new_operation(
    name = "ListBranches",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$list_branches_input(repositoryName = repositoryName, nextToken = nextToken)
  output <- .codecommit$list_branches_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$list_branches <- codecommit_list_branches

#' Returns a list of pull requests for a specified repository
#'
#' @description
#' Returns a list of pull requests for a specified repository. The return list can be refined by pull request status or pull request author ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_list_pull_requests/](https://www.paws-r-sdk.com/docs/codecommit_list_pull_requests/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository for which you want to list pull requests.
#' @param authorArn Optional. The Amazon Resource Name (ARN) of the user who created the
#' pull request. If used, this filters the results to pull requests created
#' by that user.
#' @param pullRequestStatus Optional. The status of the pull request. If used, this refines the
#' results to the pull requests that match the specified status.
#' @param nextToken An enumeration token that, when provided in a request, returns the next
#' batch of the results.
#' @param maxResults A non-zero, non-negative integer used to limit the number of returned
#' results.
#'
#' @keywords internal
#'
#' @rdname codecommit_list_pull_requests
codecommit_list_pull_requests <- function(repositoryName, authorArn = NULL, pullRequestStatus = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListPullRequests",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$list_pull_requests_input(repositoryName = repositoryName, authorArn = authorArn, pullRequestStatus = pullRequestStatus, nextToken = nextToken, maxResults = maxResults)
  output <- .codecommit$list_pull_requests_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$list_pull_requests <- codecommit_list_pull_requests

#' Gets information about one or more repositories
#'
#' @description
#' Gets information about one or more repositories.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_list_repositories/](https://www.paws-r-sdk.com/docs/codecommit_list_repositories/) for full documentation.
#'
#' @param nextToken An enumeration token that allows the operation to batch the results of
#' the operation. Batch sizes are 1,000 for list repository operations.
#' When the client sends the token back to AWS CodeCommit, another page of
#' 1,000 records is retrieved.
#' @param sortBy The criteria used to sort the results of a list repositories operation.
#' @param order The order in which to sort the results of a list repositories operation.
#'
#' @keywords internal
#'
#' @rdname codecommit_list_repositories
codecommit_list_repositories <- function(nextToken = NULL, sortBy = NULL, order = NULL) {
  op <- new_operation(
    name = "ListRepositories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$list_repositories_input(nextToken = nextToken, sortBy = sortBy, order = order)
  output <- .codecommit$list_repositories_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$list_repositories <- codecommit_list_repositories

#' Lists all repositories associated with the specified approval rule
#' template
#'
#' @description
#' Lists all repositories associated with the specified approval rule template.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_list_repositories_for_approval_rule_template/](https://www.paws-r-sdk.com/docs/codecommit_list_repositories_for_approval_rule_template/) for full documentation.
#'
#' @param approvalRuleTemplateName &#91;required&#93; The name of the approval rule template for which you want to list
#' repositories that are associated with that template.
#' @param nextToken An enumeration token that, when provided in a request, returns the next
#' batch of the results.
#' @param maxResults A non-zero, non-negative integer used to limit the number of returned
#' results.
#'
#' @keywords internal
#'
#' @rdname codecommit_list_repositories_for_approval_rule_template
codecommit_list_repositories_for_approval_rule_template <- function(approvalRuleTemplateName, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListRepositoriesForApprovalRuleTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$list_repositories_for_approval_rule_template_input(approvalRuleTemplateName = approvalRuleTemplateName, nextToken = nextToken, maxResults = maxResults)
  output <- .codecommit$list_repositories_for_approval_rule_template_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$list_repositories_for_approval_rule_template <- codecommit_list_repositories_for_approval_rule_template

#' Gets information about AWS tags for a specified Amazon Resource Name
#' (ARN) in AWS CodeCommit
#'
#' @description
#' Gets information about AWS tags for a specified Amazon Resource Name (ARN) in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see [CodeCommit Resources and Operations](https://docs.aws.amazon.com/codecommit/latest/userguide/#arn-formats) in the *AWS CodeCommit User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/codecommit_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource for which you want to get
#' information about tags, if any.
#' @param nextToken An enumeration token that, when provided in a request, returns the next
#' batch of the results.
#'
#' @keywords internal
#'
#' @rdname codecommit_list_tags_for_resource
codecommit_list_tags_for_resource <- function(resourceArn, nextToken = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$list_tags_for_resource_input(resourceArn = resourceArn, nextToken = nextToken)
  output <- .codecommit$list_tags_for_resource_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$list_tags_for_resource <- codecommit_list_tags_for_resource

#' Merges two branches using the fast-forward merge strategy
#'
#' @description
#' Merges two branches using the fast-forward merge strategy.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_merge_branches_by_fast_forward/](https://www.paws-r-sdk.com/docs/codecommit_merge_branches_by_fast_forward/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository where you want to merge two branches.
#' @param sourceCommitSpecifier &#91;required&#93; The branch, tag, HEAD, or other fully qualified reference used to
#' identify a commit (for example, a branch name or a full commit ID).
#' @param destinationCommitSpecifier &#91;required&#93; The branch, tag, HEAD, or other fully qualified reference used to
#' identify a commit (for example, a branch name or a full commit ID).
#' @param targetBranch The branch where the merge is applied.
#'
#' @keywords internal
#'
#' @rdname codecommit_merge_branches_by_fast_forward
codecommit_merge_branches_by_fast_forward <- function(repositoryName, sourceCommitSpecifier, destinationCommitSpecifier, targetBranch = NULL) {
  op <- new_operation(
    name = "MergeBranchesByFastForward",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$merge_branches_by_fast_forward_input(repositoryName = repositoryName, sourceCommitSpecifier = sourceCommitSpecifier, destinationCommitSpecifier = destinationCommitSpecifier, targetBranch = targetBranch)
  output <- .codecommit$merge_branches_by_fast_forward_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$merge_branches_by_fast_forward <- codecommit_merge_branches_by_fast_forward

#' Merges two branches using the squash merge strategy
#'
#' @description
#' Merges two branches using the squash merge strategy.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_merge_branches_by_squash/](https://www.paws-r-sdk.com/docs/codecommit_merge_branches_by_squash/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository where you want to merge two branches.
#' @param sourceCommitSpecifier &#91;required&#93; The branch, tag, HEAD, or other fully qualified reference used to
#' identify a commit (for example, a branch name or a full commit ID).
#' @param destinationCommitSpecifier &#91;required&#93; The branch, tag, HEAD, or other fully qualified reference used to
#' identify a commit (for example, a branch name or a full commit ID).
#' @param targetBranch The branch where the merge is applied.
#' @param conflictDetailLevel The level of conflict detail to use. If unspecified, the default
#' FILE_LEVEL is used, which returns a not-mergeable result if the same
#' file has differences in both branches. If LINE_LEVEL is specified, a
#' conflict is considered not mergeable if the same file in both branches
#' has differences on the same line.
#' @param conflictResolutionStrategy Specifies which branch to use when resolving conflicts, or whether to
#' attempt automatically merging two versions of a file. The default is
#' NONE, which requires any conflicts to be resolved manually before the
#' merge operation is successful.
#' @param authorName The name of the author who created the commit. This information is used
#' as both the author and committer for the commit.
#' @param email The email address of the person merging the branches. This information
#' is used in the commit information for the merge.
#' @param commitMessage The commit message for the merge.
#' @param keepEmptyFolders If the commit contains deletions, whether to keep a folder or folder
#' structure if the changes leave the folders empty. If this is specified
#' as true, a .gitkeep file is created for empty folders. The default is
#' false.
#' @param conflictResolution If AUTOMERGE is the conflict resolution strategy, a list of inputs to
#' use when resolving conflicts during a merge.
#'
#' @keywords internal
#'
#' @rdname codecommit_merge_branches_by_squash
codecommit_merge_branches_by_squash <- function(repositoryName, sourceCommitSpecifier, destinationCommitSpecifier, targetBranch = NULL, conflictDetailLevel = NULL, conflictResolutionStrategy = NULL, authorName = NULL, email = NULL, commitMessage = NULL, keepEmptyFolders = NULL, conflictResolution = NULL) {
  op <- new_operation(
    name = "MergeBranchesBySquash",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$merge_branches_by_squash_input(repositoryName = repositoryName, sourceCommitSpecifier = sourceCommitSpecifier, destinationCommitSpecifier = destinationCommitSpecifier, targetBranch = targetBranch, conflictDetailLevel = conflictDetailLevel, conflictResolutionStrategy = conflictResolutionStrategy, authorName = authorName, email = email, commitMessage = commitMessage, keepEmptyFolders = keepEmptyFolders, conflictResolution = conflictResolution)
  output <- .codecommit$merge_branches_by_squash_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$merge_branches_by_squash <- codecommit_merge_branches_by_squash

#' Merges two specified branches using the three-way merge strategy
#'
#' @description
#' Merges two specified branches using the three-way merge strategy.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_merge_branches_by_three_way/](https://www.paws-r-sdk.com/docs/codecommit_merge_branches_by_three_way/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository where you want to merge two branches.
#' @param sourceCommitSpecifier &#91;required&#93; The branch, tag, HEAD, or other fully qualified reference used to
#' identify a commit (for example, a branch name or a full commit ID).
#' @param destinationCommitSpecifier &#91;required&#93; The branch, tag, HEAD, or other fully qualified reference used to
#' identify a commit (for example, a branch name or a full commit ID).
#' @param targetBranch The branch where the merge is applied.
#' @param conflictDetailLevel The level of conflict detail to use. If unspecified, the default
#' FILE_LEVEL is used, which returns a not-mergeable result if the same
#' file has differences in both branches. If LINE_LEVEL is specified, a
#' conflict is considered not mergeable if the same file in both branches
#' has differences on the same line.
#' @param conflictResolutionStrategy Specifies which branch to use when resolving conflicts, or whether to
#' attempt automatically merging two versions of a file. The default is
#' NONE, which requires any conflicts to be resolved manually before the
#' merge operation is successful.
#' @param authorName The name of the author who created the commit. This information is used
#' as both the author and committer for the commit.
#' @param email The email address of the person merging the branches. This information
#' is used in the commit information for the merge.
#' @param commitMessage The commit message to include in the commit information for the merge.
#' @param keepEmptyFolders If the commit contains deletions, whether to keep a folder or folder
#' structure if the changes leave the folders empty. If true, a .gitkeep
#' file is created for empty folders. The default is false.
#' @param conflictResolution If AUTOMERGE is the conflict resolution strategy, a list of inputs to
#' use when resolving conflicts during a merge.
#'
#' @keywords internal
#'
#' @rdname codecommit_merge_branches_by_three_way
codecommit_merge_branches_by_three_way <- function(repositoryName, sourceCommitSpecifier, destinationCommitSpecifier, targetBranch = NULL, conflictDetailLevel = NULL, conflictResolutionStrategy = NULL, authorName = NULL, email = NULL, commitMessage = NULL, keepEmptyFolders = NULL, conflictResolution = NULL) {
  op <- new_operation(
    name = "MergeBranchesByThreeWay",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$merge_branches_by_three_way_input(repositoryName = repositoryName, sourceCommitSpecifier = sourceCommitSpecifier, destinationCommitSpecifier = destinationCommitSpecifier, targetBranch = targetBranch, conflictDetailLevel = conflictDetailLevel, conflictResolutionStrategy = conflictResolutionStrategy, authorName = authorName, email = email, commitMessage = commitMessage, keepEmptyFolders = keepEmptyFolders, conflictResolution = conflictResolution)
  output <- .codecommit$merge_branches_by_three_way_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$merge_branches_by_three_way <- codecommit_merge_branches_by_three_way

#' Attempts to merge the source commit of a pull request into the specified
#' destination branch for that pull request at the specified commit using
#' the fast-forward merge strategy
#'
#' @description
#' Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the fast-forward merge strategy. If the merge is successful, it closes the pull request.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_merge_pull_request_by_fast_forward/](https://www.paws-r-sdk.com/docs/codecommit_merge_pull_request_by_fast_forward/) for full documentation.
#'
#' @param pullRequestId &#91;required&#93; The system-generated ID of the pull request. To get this ID, use
#' [`list_pull_requests`][codecommit_list_pull_requests].
#' @param repositoryName &#91;required&#93; The name of the repository where the pull request was created.
#' @param sourceCommitId The full commit ID of the original or updated commit in the pull request
#' source branch. Pass this value if you want an exception thrown if the
#' current commit ID of the tip of the source branch does not match this
#' commit ID.
#'
#' @keywords internal
#'
#' @rdname codecommit_merge_pull_request_by_fast_forward
codecommit_merge_pull_request_by_fast_forward <- function(pullRequestId, repositoryName, sourceCommitId = NULL) {
  op <- new_operation(
    name = "MergePullRequestByFastForward",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$merge_pull_request_by_fast_forward_input(pullRequestId = pullRequestId, repositoryName = repositoryName, sourceCommitId = sourceCommitId)
  output <- .codecommit$merge_pull_request_by_fast_forward_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$merge_pull_request_by_fast_forward <- codecommit_merge_pull_request_by_fast_forward

#' Attempts to merge the source commit of a pull request into the specified
#' destination branch for that pull request at the specified commit using
#' the squash merge strategy
#'
#' @description
#' Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the squash merge strategy. If the merge is successful, it closes the pull request.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_merge_pull_request_by_squash/](https://www.paws-r-sdk.com/docs/codecommit_merge_pull_request_by_squash/) for full documentation.
#'
#' @param pullRequestId &#91;required&#93; The system-generated ID of the pull request. To get this ID, use
#' [`list_pull_requests`][codecommit_list_pull_requests].
#' @param repositoryName &#91;required&#93; The name of the repository where the pull request was created.
#' @param sourceCommitId The full commit ID of the original or updated commit in the pull request
#' source branch. Pass this value if you want an exception thrown if the
#' current commit ID of the tip of the source branch does not match this
#' commit ID.
#' @param conflictDetailLevel The level of conflict detail to use. If unspecified, the default
#' FILE_LEVEL is used, which returns a not-mergeable result if the same
#' file has differences in both branches. If LINE_LEVEL is specified, a
#' conflict is considered not mergeable if the same file in both branches
#' has differences on the same line.
#' @param conflictResolutionStrategy Specifies which branch to use when resolving conflicts, or whether to
#' attempt automatically merging two versions of a file. The default is
#' NONE, which requires any conflicts to be resolved manually before the
#' merge operation is successful.
#' @param commitMessage The commit message to include in the commit information for the merge.
#' @param authorName The name of the author who created the commit. This information is used
#' as both the author and committer for the commit.
#' @param email The email address of the person merging the branches. This information
#' is used in the commit information for the merge.
#' @param keepEmptyFolders If the commit contains deletions, whether to keep a folder or folder
#' structure if the changes leave the folders empty. If true, a .gitkeep
#' file is created for empty folders. The default is false.
#' @param conflictResolution If AUTOMERGE is the conflict resolution strategy, a list of inputs to
#' use when resolving conflicts during a merge.
#'
#' @keywords internal
#'
#' @rdname codecommit_merge_pull_request_by_squash
codecommit_merge_pull_request_by_squash <- function(pullRequestId, repositoryName, sourceCommitId = NULL, conflictDetailLevel = NULL, conflictResolutionStrategy = NULL, commitMessage = NULL, authorName = NULL, email = NULL, keepEmptyFolders = NULL, conflictResolution = NULL) {
  op <- new_operation(
    name = "MergePullRequestBySquash",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$merge_pull_request_by_squash_input(pullRequestId = pullRequestId, repositoryName = repositoryName, sourceCommitId = sourceCommitId, conflictDetailLevel = conflictDetailLevel, conflictResolutionStrategy = conflictResolutionStrategy, commitMessage = commitMessage, authorName = authorName, email = email, keepEmptyFolders = keepEmptyFolders, conflictResolution = conflictResolution)
  output <- .codecommit$merge_pull_request_by_squash_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$merge_pull_request_by_squash <- codecommit_merge_pull_request_by_squash

#' Attempts to merge the source commit of a pull request into the specified
#' destination branch for that pull request at the specified commit using
#' the three-way merge strategy
#'
#' @description
#' Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the three-way merge strategy. If the merge is successful, it closes the pull request.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_merge_pull_request_by_three_way/](https://www.paws-r-sdk.com/docs/codecommit_merge_pull_request_by_three_way/) for full documentation.
#'
#' @param pullRequestId &#91;required&#93; The system-generated ID of the pull request. To get this ID, use
#' [`list_pull_requests`][codecommit_list_pull_requests].
#' @param repositoryName &#91;required&#93; The name of the repository where the pull request was created.
#' @param sourceCommitId The full commit ID of the original or updated commit in the pull request
#' source branch. Pass this value if you want an exception thrown if the
#' current commit ID of the tip of the source branch does not match this
#' commit ID.
#' @param conflictDetailLevel The level of conflict detail to use. If unspecified, the default
#' FILE_LEVEL is used, which returns a not-mergeable result if the same
#' file has differences in both branches. If LINE_LEVEL is specified, a
#' conflict is considered not mergeable if the same file in both branches
#' has differences on the same line.
#' @param conflictResolutionStrategy Specifies which branch to use when resolving conflicts, or whether to
#' attempt automatically merging two versions of a file. The default is
#' NONE, which requires any conflicts to be resolved manually before the
#' merge operation is successful.
#' @param commitMessage The commit message to include in the commit information for the merge.
#' @param authorName The name of the author who created the commit. This information is used
#' as both the author and committer for the commit.
#' @param email The email address of the person merging the branches. This information
#' is used in the commit information for the merge.
#' @param keepEmptyFolders If the commit contains deletions, whether to keep a folder or folder
#' structure if the changes leave the folders empty. If true, a .gitkeep
#' file is created for empty folders. The default is false.
#' @param conflictResolution If AUTOMERGE is the conflict resolution strategy, a list of inputs to
#' use when resolving conflicts during a merge.
#'
#' @keywords internal
#'
#' @rdname codecommit_merge_pull_request_by_three_way
codecommit_merge_pull_request_by_three_way <- function(pullRequestId, repositoryName, sourceCommitId = NULL, conflictDetailLevel = NULL, conflictResolutionStrategy = NULL, commitMessage = NULL, authorName = NULL, email = NULL, keepEmptyFolders = NULL, conflictResolution = NULL) {
  op <- new_operation(
    name = "MergePullRequestByThreeWay",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$merge_pull_request_by_three_way_input(pullRequestId = pullRequestId, repositoryName = repositoryName, sourceCommitId = sourceCommitId, conflictDetailLevel = conflictDetailLevel, conflictResolutionStrategy = conflictResolutionStrategy, commitMessage = commitMessage, authorName = authorName, email = email, keepEmptyFolders = keepEmptyFolders, conflictResolution = conflictResolution)
  output <- .codecommit$merge_pull_request_by_three_way_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$merge_pull_request_by_three_way <- codecommit_merge_pull_request_by_three_way

#' Sets aside (overrides) all approval rule requirements for a specified
#' pull request
#'
#' @description
#' Sets aside (overrides) all approval rule requirements for a specified pull request.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_override_pull_request_approval_rules/](https://www.paws-r-sdk.com/docs/codecommit_override_pull_request_approval_rules/) for full documentation.
#'
#' @param pullRequestId &#91;required&#93; The system-generated ID of the pull request for which you want to
#' override all approval rule requirements. To get this information, use
#' [`get_pull_request`][codecommit_get_pull_request].
#' @param revisionId &#91;required&#93; The system-generated ID of the most recent revision of the pull request.
#' You cannot override approval rules for anything but the most recent
#' revision of a pull request. To get the revision ID, use GetPullRequest.
#' @param overrideStatus &#91;required&#93; Whether you want to set aside approval rule requirements for the pull
#' request (OVERRIDE) or revoke a previous override and apply approval rule
#' requirements (REVOKE). REVOKE status is not stored.
#'
#' @keywords internal
#'
#' @rdname codecommit_override_pull_request_approval_rules
codecommit_override_pull_request_approval_rules <- function(pullRequestId, revisionId, overrideStatus) {
  op <- new_operation(
    name = "OverridePullRequestApprovalRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$override_pull_request_approval_rules_input(pullRequestId = pullRequestId, revisionId = revisionId, overrideStatus = overrideStatus)
  output <- .codecommit$override_pull_request_approval_rules_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$override_pull_request_approval_rules <- codecommit_override_pull_request_approval_rules

#' Posts a comment on the comparison between two commits
#'
#' @description
#' Posts a comment on the comparison between two commits.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_post_comment_for_compared_commit/](https://www.paws-r-sdk.com/docs/codecommit_post_comment_for_compared_commit/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository where you want to post a comment on the
#' comparison between commits.
#' @param beforeCommitId To establish the directionality of the comparison, the full commit ID of
#' the before commit. Required for commenting on any commit unless that
#' commit is the initial commit.
#' @param afterCommitId &#91;required&#93; To establish the directionality of the comparison, the full commit ID of
#' the after commit.
#' @param location The location of the comparison where you want to comment.
#' @param content &#91;required&#93; The content of the comment you want to make.
#' @param clientRequestToken A unique, client-generated idempotency token that, when provided in a
#' request, ensures the request cannot be repeated with a changed
#' parameter. If a request is received with the same parameters and a token
#' is included, the request returns information about the initial request
#' that used that token.
#'
#' @keywords internal
#'
#' @rdname codecommit_post_comment_for_compared_commit
codecommit_post_comment_for_compared_commit <- function(repositoryName, beforeCommitId = NULL, afterCommitId, location = NULL, content, clientRequestToken = NULL) {
  op <- new_operation(
    name = "PostCommentForComparedCommit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$post_comment_for_compared_commit_input(repositoryName = repositoryName, beforeCommitId = beforeCommitId, afterCommitId = afterCommitId, location = location, content = content, clientRequestToken = clientRequestToken)
  output <- .codecommit$post_comment_for_compared_commit_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$post_comment_for_compared_commit <- codecommit_post_comment_for_compared_commit

#' Posts a comment on a pull request
#'
#' @description
#' Posts a comment on a pull request.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_post_comment_for_pull_request/](https://www.paws-r-sdk.com/docs/codecommit_post_comment_for_pull_request/) for full documentation.
#'
#' @param pullRequestId &#91;required&#93; The system-generated ID of the pull request. To get this ID, use
#' [`list_pull_requests`][codecommit_list_pull_requests].
#' @param repositoryName &#91;required&#93; The name of the repository where you want to post a comment on a pull
#' request.
#' @param beforeCommitId &#91;required&#93; The full commit ID of the commit in the destination branch that was the
#' tip of the branch at the time the pull request was created.
#' @param afterCommitId &#91;required&#93; The full commit ID of the commit in the source branch that is the
#' current tip of the branch for the pull request when you post the
#' comment.
#' @param location The location of the change where you want to post your comment. If no
#' location is provided, the comment is posted as a general comment on the
#' pull request difference between the before commit ID and the after
#' commit ID.
#' @param content &#91;required&#93; The content of your comment on the change.
#' @param clientRequestToken A unique, client-generated idempotency token that, when provided in a
#' request, ensures the request cannot be repeated with a changed
#' parameter. If a request is received with the same parameters and a token
#' is included, the request returns information about the initial request
#' that used that token.
#'
#' @keywords internal
#'
#' @rdname codecommit_post_comment_for_pull_request
codecommit_post_comment_for_pull_request <- function(pullRequestId, repositoryName, beforeCommitId, afterCommitId, location = NULL, content, clientRequestToken = NULL) {
  op <- new_operation(
    name = "PostCommentForPullRequest",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$post_comment_for_pull_request_input(pullRequestId = pullRequestId, repositoryName = repositoryName, beforeCommitId = beforeCommitId, afterCommitId = afterCommitId, location = location, content = content, clientRequestToken = clientRequestToken)
  output <- .codecommit$post_comment_for_pull_request_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$post_comment_for_pull_request <- codecommit_post_comment_for_pull_request

#' Posts a comment in reply to an existing comment on a comparison between
#' commits or a pull request
#'
#' @description
#' Posts a comment in reply to an existing comment on a comparison between commits or a pull request.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_post_comment_reply/](https://www.paws-r-sdk.com/docs/codecommit_post_comment_reply/) for full documentation.
#'
#' @param inReplyTo &#91;required&#93; The system-generated ID of the comment to which you want to reply. To
#' get this ID, use
#' [`get_comments_for_compared_commit`][codecommit_get_comments_for_compared_commit]
#' or
#' [`get_comments_for_pull_request`][codecommit_get_comments_for_pull_request].
#' @param clientRequestToken A unique, client-generated idempotency token that, when provided in a
#' request, ensures the request cannot be repeated with a changed
#' parameter. If a request is received with the same parameters and a token
#' is included, the request returns information about the initial request
#' that used that token.
#' @param content &#91;required&#93; The contents of your reply to a comment.
#'
#' @keywords internal
#'
#' @rdname codecommit_post_comment_reply
codecommit_post_comment_reply <- function(inReplyTo, clientRequestToken = NULL, content) {
  op <- new_operation(
    name = "PostCommentReply",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$post_comment_reply_input(inReplyTo = inReplyTo, clientRequestToken = clientRequestToken, content = content)
  output <- .codecommit$post_comment_reply_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$post_comment_reply <- codecommit_post_comment_reply

#' Adds or updates a reaction to a specified comment for the user whose
#' identity is used to make the request
#'
#' @description
#' Adds or updates a reaction to a specified comment for the user whose identity is used to make the request. You can only add or update a reaction for yourself. You cannot add, modify, or delete a reaction for another user.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_put_comment_reaction/](https://www.paws-r-sdk.com/docs/codecommit_put_comment_reaction/) for full documentation.
#'
#' @param commentId &#91;required&#93; The ID of the comment to which you want to add or update a reaction.
#' @param reactionValue &#91;required&#93; The emoji reaction you want to add or update. To remove a reaction,
#' provide a value of blank or null. You can also provide the value of
#' none. For information about emoji reaction values supported in AWS
#' CodeCommit, see the [AWS CodeCommit User
#' Guide](https://docs.aws.amazon.com/codecommit/latest/userguide/how-to-commit-comment.html#emoji-reaction-table).
#'
#' @keywords internal
#'
#' @rdname codecommit_put_comment_reaction
codecommit_put_comment_reaction <- function(commentId, reactionValue) {
  op <- new_operation(
    name = "PutCommentReaction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$put_comment_reaction_input(commentId = commentId, reactionValue = reactionValue)
  output <- .codecommit$put_comment_reaction_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$put_comment_reaction <- codecommit_put_comment_reaction

#' Adds or updates a file in a branch in an AWS CodeCommit repository, and
#' generates a commit for the addition in the specified branch
#'
#' @description
#' Adds or updates a file in a branch in an AWS CodeCommit repository, and generates a commit for the addition in the specified branch.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_put_file/](https://www.paws-r-sdk.com/docs/codecommit_put_file/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository where you want to add or update the file.
#' @param branchName &#91;required&#93; The name of the branch where you want to add or update the file. If this
#' is an empty repository, this branch is created.
#' @param fileContent &#91;required&#93; The content of the file, in binary object format.
#' @param filePath &#91;required&#93; The name of the file you want to add or update, including the relative
#' path to the file in the repository.
#' 
#' If the path does not currently exist in the repository, the path is
#' created as part of adding the file.
#' @param fileMode The file mode permissions of the blob. Valid file mode permissions are
#' listed here.
#' @param parentCommitId The full commit ID of the head commit in the branch where you want to
#' add or update the file. If this is an empty repository, no commit ID is
#' required. If this is not an empty repository, a commit ID is required.
#' 
#' The commit ID must match the ID of the head commit at the time of the
#' operation. Otherwise, an error occurs, and the file is not added or
#' updated.
#' @param commitMessage A message about why this file was added or updated. Although it is
#' optional, a message makes the commit history for your repository more
#' useful.
#' @param name The name of the person adding or updating the file. Although it is
#' optional, a name makes the commit history for your repository more
#' useful.
#' @param email An email address for the person adding or updating the file.
#'
#' @keywords internal
#'
#' @rdname codecommit_put_file
codecommit_put_file <- function(repositoryName, branchName, fileContent, filePath, fileMode = NULL, parentCommitId = NULL, commitMessage = NULL, name = NULL, email = NULL) {
  op <- new_operation(
    name = "PutFile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$put_file_input(repositoryName = repositoryName, branchName = branchName, fileContent = fileContent, filePath = filePath, fileMode = fileMode, parentCommitId = parentCommitId, commitMessage = commitMessage, name = name, email = email)
  output <- .codecommit$put_file_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$put_file <- codecommit_put_file

#' Replaces all triggers for a repository
#'
#' @description
#' Replaces all triggers for a repository. Used to create or delete triggers.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_put_repository_triggers/](https://www.paws-r-sdk.com/docs/codecommit_put_repository_triggers/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository where you want to create or update the
#' trigger.
#' @param triggers &#91;required&#93; The JSON block of configuration information for each trigger.
#'
#' @keywords internal
#'
#' @rdname codecommit_put_repository_triggers
codecommit_put_repository_triggers <- function(repositoryName, triggers) {
  op <- new_operation(
    name = "PutRepositoryTriggers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$put_repository_triggers_input(repositoryName = repositoryName, triggers = triggers)
  output <- .codecommit$put_repository_triggers_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$put_repository_triggers <- codecommit_put_repository_triggers

#' Adds or updates tags for a resource in AWS CodeCommit
#'
#' @description
#' Adds or updates tags for a resource in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see [CodeCommit Resources and Operations](https://docs.aws.amazon.com/codecommit/latest/userguide/#arn-formats) in the *AWS CodeCommit User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_tag_resource/](https://www.paws-r-sdk.com/docs/codecommit_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to which you want to add
#' or update tags.
#' @param tags &#91;required&#93; The key-value pair to use when tagging this repository.
#'
#' @keywords internal
#'
#' @rdname codecommit_tag_resource
codecommit_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .codecommit$tag_resource_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$tag_resource <- codecommit_tag_resource

#' Tests the functionality of repository triggers by sending information to
#' the trigger target
#'
#' @description
#' Tests the functionality of repository triggers by sending information to the trigger target. If real data is available in the repository, the test sends data from the last commit. If no data is available, sample data is generated.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_test_repository_triggers/](https://www.paws-r-sdk.com/docs/codecommit_test_repository_triggers/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository in which to test the triggers.
#' @param triggers &#91;required&#93; The list of triggers to test.
#'
#' @keywords internal
#'
#' @rdname codecommit_test_repository_triggers
codecommit_test_repository_triggers <- function(repositoryName, triggers) {
  op <- new_operation(
    name = "TestRepositoryTriggers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$test_repository_triggers_input(repositoryName = repositoryName, triggers = triggers)
  output <- .codecommit$test_repository_triggers_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$test_repository_triggers <- codecommit_test_repository_triggers

#' Removes tags for a resource in AWS CodeCommit
#'
#' @description
#' Removes tags for a resource in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see [CodeCommit Resources and Operations](https://docs.aws.amazon.com/codecommit/latest/userguide/#arn-formats) in the *AWS CodeCommit User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_untag_resource/](https://www.paws-r-sdk.com/docs/codecommit_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to which you want to
#' remove tags.
#' @param tagKeys &#91;required&#93; The tag key for each tag that you want to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname codecommit_untag_resource
codecommit_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .codecommit$untag_resource_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$untag_resource <- codecommit_untag_resource

#' Updates the content of an approval rule template
#'
#' @description
#' Updates the content of an approval rule template. You can change the number of required approvals, the membership of the approval rule, and whether an approval pool is defined.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_update_approval_rule_template_content/](https://www.paws-r-sdk.com/docs/codecommit_update_approval_rule_template_content/) for full documentation.
#'
#' @param approvalRuleTemplateName &#91;required&#93; The name of the approval rule template where you want to update the
#' content of the rule.
#' @param newRuleContent &#91;required&#93; The content that replaces the existing content of the rule. Content
#' statements must be complete. You cannot provide only the changes.
#' @param existingRuleContentSha256 The SHA-256 hash signature for the content of the approval rule. You can
#' retrieve this information by using
#' [`get_pull_request`][codecommit_get_pull_request].
#'
#' @keywords internal
#'
#' @rdname codecommit_update_approval_rule_template_content
codecommit_update_approval_rule_template_content <- function(approvalRuleTemplateName, newRuleContent, existingRuleContentSha256 = NULL) {
  op <- new_operation(
    name = "UpdateApprovalRuleTemplateContent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$update_approval_rule_template_content_input(approvalRuleTemplateName = approvalRuleTemplateName, newRuleContent = newRuleContent, existingRuleContentSha256 = existingRuleContentSha256)
  output <- .codecommit$update_approval_rule_template_content_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$update_approval_rule_template_content <- codecommit_update_approval_rule_template_content

#' Updates the description for a specified approval rule template
#'
#' @description
#' Updates the description for a specified approval rule template.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_update_approval_rule_template_description/](https://www.paws-r-sdk.com/docs/codecommit_update_approval_rule_template_description/) for full documentation.
#'
#' @param approvalRuleTemplateName &#91;required&#93; The name of the template for which you want to update the description.
#' @param approvalRuleTemplateDescription &#91;required&#93; The updated description of the approval rule template.
#'
#' @keywords internal
#'
#' @rdname codecommit_update_approval_rule_template_description
codecommit_update_approval_rule_template_description <- function(approvalRuleTemplateName, approvalRuleTemplateDescription) {
  op <- new_operation(
    name = "UpdateApprovalRuleTemplateDescription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$update_approval_rule_template_description_input(approvalRuleTemplateName = approvalRuleTemplateName, approvalRuleTemplateDescription = approvalRuleTemplateDescription)
  output <- .codecommit$update_approval_rule_template_description_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$update_approval_rule_template_description <- codecommit_update_approval_rule_template_description

#' Updates the name of a specified approval rule template
#'
#' @description
#' Updates the name of a specified approval rule template.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_update_approval_rule_template_name/](https://www.paws-r-sdk.com/docs/codecommit_update_approval_rule_template_name/) for full documentation.
#'
#' @param oldApprovalRuleTemplateName &#91;required&#93; The current name of the approval rule template.
#' @param newApprovalRuleTemplateName &#91;required&#93; The new name you want to apply to the approval rule template.
#'
#' @keywords internal
#'
#' @rdname codecommit_update_approval_rule_template_name
codecommit_update_approval_rule_template_name <- function(oldApprovalRuleTemplateName, newApprovalRuleTemplateName) {
  op <- new_operation(
    name = "UpdateApprovalRuleTemplateName",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$update_approval_rule_template_name_input(oldApprovalRuleTemplateName = oldApprovalRuleTemplateName, newApprovalRuleTemplateName = newApprovalRuleTemplateName)
  output <- .codecommit$update_approval_rule_template_name_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$update_approval_rule_template_name <- codecommit_update_approval_rule_template_name

#' Replaces the contents of a comment
#'
#' @description
#' Replaces the contents of a comment.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_update_comment/](https://www.paws-r-sdk.com/docs/codecommit_update_comment/) for full documentation.
#'
#' @param commentId &#91;required&#93; The system-generated ID of the comment you want to update. To get this
#' ID, use
#' [`get_comments_for_compared_commit`][codecommit_get_comments_for_compared_commit]
#' or
#' [`get_comments_for_pull_request`][codecommit_get_comments_for_pull_request].
#' @param content &#91;required&#93; The updated content to replace the existing content of the comment.
#'
#' @keywords internal
#'
#' @rdname codecommit_update_comment
codecommit_update_comment <- function(commentId, content) {
  op <- new_operation(
    name = "UpdateComment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$update_comment_input(commentId = commentId, content = content)
  output <- .codecommit$update_comment_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$update_comment <- codecommit_update_comment

#' Sets or changes the default branch name for the specified repository
#'
#' @description
#' Sets or changes the default branch name for the specified repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_update_default_branch/](https://www.paws-r-sdk.com/docs/codecommit_update_default_branch/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository to set or change the default branch for.
#' @param defaultBranchName &#91;required&#93; The name of the branch to set as the default.
#'
#' @keywords internal
#'
#' @rdname codecommit_update_default_branch
codecommit_update_default_branch <- function(repositoryName, defaultBranchName) {
  op <- new_operation(
    name = "UpdateDefaultBranch",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$update_default_branch_input(repositoryName = repositoryName, defaultBranchName = defaultBranchName)
  output <- .codecommit$update_default_branch_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$update_default_branch <- codecommit_update_default_branch

#' Updates the structure of an approval rule created specifically for a
#' pull request
#'
#' @description
#' Updates the structure of an approval rule created specifically for a pull request. For example, you can change the number of required approvers and the approval pool for approvers.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_update_pull_request_approval_rule_content/](https://www.paws-r-sdk.com/docs/codecommit_update_pull_request_approval_rule_content/) for full documentation.
#'
#' @param pullRequestId &#91;required&#93; The system-generated ID of the pull request.
#' @param approvalRuleName &#91;required&#93; The name of the approval rule you want to update.
#' @param existingRuleContentSha256 The SHA-256 hash signature for the content of the approval rule. You can
#' retrieve this information by using
#' [`get_pull_request`][codecommit_get_pull_request].
#' @param newRuleContent &#91;required&#93; The updated content for the approval rule.
#' 
#' When you update the content of the approval rule, you can specify
#' approvers in an approval pool in one of two ways:
#' 
#' -   **CodeCommitApprovers**: This option only requires an AWS account
#'     and a resource. It can be used for both IAM users and federated
#'     access users whose name matches the provided resource name. This is
#'     a very powerful option that offers a great deal of flexibility. For
#'     example, if you specify the AWS account *123456789012* and
#'     *Mary_Major*, all of the following are counted as approvals coming
#'     from that user:
#' 
#'     -   An IAM user in the account
#'         (arn:aws:iam::*123456789012*:user/*Mary_Major*)
#' 
#'     -   A federated user identified in IAM as Mary_Major
#'         (arn:aws:sts::*123456789012*:federated-user/*Mary_Major*)
#' 
#'     This option does not recognize an active session of someone assuming
#'     the role of CodeCommitReview with a role session name of
#'     *Mary_Major*
#'     (arn:aws:sts::*123456789012*:assumed-role/CodeCommitReview/*Mary_Major*)
#'     unless you include a wildcard (*Mary_Major).
#' 
#' -   **Fully qualified ARN**: This option allows you to specify the fully
#'     qualified Amazon Resource Name (ARN) of the IAM user or role.
#' 
#' For more information about IAM ARNs, wildcards, and formats, see [IAM
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
#' in the *IAM User Guide*.
#'
#' @keywords internal
#'
#' @rdname codecommit_update_pull_request_approval_rule_content
codecommit_update_pull_request_approval_rule_content <- function(pullRequestId, approvalRuleName, existingRuleContentSha256 = NULL, newRuleContent) {
  op <- new_operation(
    name = "UpdatePullRequestApprovalRuleContent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$update_pull_request_approval_rule_content_input(pullRequestId = pullRequestId, approvalRuleName = approvalRuleName, existingRuleContentSha256 = existingRuleContentSha256, newRuleContent = newRuleContent)
  output <- .codecommit$update_pull_request_approval_rule_content_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$update_pull_request_approval_rule_content <- codecommit_update_pull_request_approval_rule_content

#' Updates the state of a user's approval on a pull request
#'
#' @description
#' Updates the state of a user's approval on a pull request. The user is derived from the signed-in account when the request is made.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_update_pull_request_approval_state/](https://www.paws-r-sdk.com/docs/codecommit_update_pull_request_approval_state/) for full documentation.
#'
#' @param pullRequestId &#91;required&#93; The system-generated ID of the pull request.
#' @param revisionId &#91;required&#93; The system-generated ID of the revision.
#' @param approvalState &#91;required&#93; The approval state to associate with the user on the pull request.
#'
#' @keywords internal
#'
#' @rdname codecommit_update_pull_request_approval_state
codecommit_update_pull_request_approval_state <- function(pullRequestId, revisionId, approvalState) {
  op <- new_operation(
    name = "UpdatePullRequestApprovalState",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$update_pull_request_approval_state_input(pullRequestId = pullRequestId, revisionId = revisionId, approvalState = approvalState)
  output <- .codecommit$update_pull_request_approval_state_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$update_pull_request_approval_state <- codecommit_update_pull_request_approval_state

#' Replaces the contents of the description of a pull request
#'
#' @description
#' Replaces the contents of the description of a pull request.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_update_pull_request_description/](https://www.paws-r-sdk.com/docs/codecommit_update_pull_request_description/) for full documentation.
#'
#' @param pullRequestId &#91;required&#93; The system-generated ID of the pull request. To get this ID, use
#' [`list_pull_requests`][codecommit_list_pull_requests].
#' @param description &#91;required&#93; The updated content of the description for the pull request. This
#' content replaces the existing description.
#'
#' @keywords internal
#'
#' @rdname codecommit_update_pull_request_description
codecommit_update_pull_request_description <- function(pullRequestId, description) {
  op <- new_operation(
    name = "UpdatePullRequestDescription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$update_pull_request_description_input(pullRequestId = pullRequestId, description = description)
  output <- .codecommit$update_pull_request_description_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$update_pull_request_description <- codecommit_update_pull_request_description

#' Updates the status of a pull request
#'
#' @description
#' Updates the status of a pull request.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_update_pull_request_status/](https://www.paws-r-sdk.com/docs/codecommit_update_pull_request_status/) for full documentation.
#'
#' @param pullRequestId &#91;required&#93; The system-generated ID of the pull request. To get this ID, use
#' [`list_pull_requests`][codecommit_list_pull_requests].
#' @param pullRequestStatus &#91;required&#93; The status of the pull request. The only valid operations are to update
#' the status from `OPEN` to `OPEN`, `OPEN` to `CLOSED` or from `CLOSED` to
#' `CLOSED`.
#'
#' @keywords internal
#'
#' @rdname codecommit_update_pull_request_status
codecommit_update_pull_request_status <- function(pullRequestId, pullRequestStatus) {
  op <- new_operation(
    name = "UpdatePullRequestStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$update_pull_request_status_input(pullRequestId = pullRequestId, pullRequestStatus = pullRequestStatus)
  output <- .codecommit$update_pull_request_status_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$update_pull_request_status <- codecommit_update_pull_request_status

#' Replaces the title of a pull request
#'
#' @description
#' Replaces the title of a pull request.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_update_pull_request_title/](https://www.paws-r-sdk.com/docs/codecommit_update_pull_request_title/) for full documentation.
#'
#' @param pullRequestId &#91;required&#93; The system-generated ID of the pull request. To get this ID, use
#' [`list_pull_requests`][codecommit_list_pull_requests].
#' @param title &#91;required&#93; The updated title of the pull request. This replaces the existing title.
#'
#' @keywords internal
#'
#' @rdname codecommit_update_pull_request_title
codecommit_update_pull_request_title <- function(pullRequestId, title) {
  op <- new_operation(
    name = "UpdatePullRequestTitle",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$update_pull_request_title_input(pullRequestId = pullRequestId, title = title)
  output <- .codecommit$update_pull_request_title_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$update_pull_request_title <- codecommit_update_pull_request_title

#' Sets or changes the comment or description for a repository
#'
#' @description
#' Sets or changes the comment or description for a repository.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_update_repository_description/](https://www.paws-r-sdk.com/docs/codecommit_update_repository_description/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository to set or change the comment or description
#' for.
#' @param repositoryDescription The new comment or description for the specified repository. Repository
#' descriptions are limited to 1,000 characters.
#'
#' @keywords internal
#'
#' @rdname codecommit_update_repository_description
codecommit_update_repository_description <- function(repositoryName, repositoryDescription = NULL) {
  op <- new_operation(
    name = "UpdateRepositoryDescription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$update_repository_description_input(repositoryName = repositoryName, repositoryDescription = repositoryDescription)
  output <- .codecommit$update_repository_description_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$update_repository_description <- codecommit_update_repository_description

#' Renames a repository
#'
#' @description
#' Renames a repository. The repository name must be unique across the calling AWS account. Repository names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. The suffix .git is prohibited. For more information about the limits on repository names, see [Limits](https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html) in the AWS CodeCommit User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/codecommit_update_repository_name/](https://www.paws-r-sdk.com/docs/codecommit_update_repository_name/) for full documentation.
#'
#' @param oldName &#91;required&#93; The current name of the repository.
#' @param newName &#91;required&#93; The new name for the repository.
#'
#' @keywords internal
#'
#' @rdname codecommit_update_repository_name
codecommit_update_repository_name <- function(oldName, newName) {
  op <- new_operation(
    name = "UpdateRepositoryName",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codecommit$update_repository_name_input(oldName = oldName, newName = newName)
  output <- .codecommit$update_repository_name_output()
  config <- get_config()
  svc <- .codecommit$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codecommit$operations$update_repository_name <- codecommit_update_repository_name
