% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codegurureviewer_operations.R
\name{codegurureviewer_tag_resource}
\alias{codegurureviewer_tag_resource}
\title{Adds one or more tags to an associated repository}
\usage{
codegurureviewer_tag_resource(resourceArn, Tags)
}
\arguments{
\item{resourceArn}{[required] The Amazon Resource Name (ARN) of the
\href{https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html}{\code{RepositoryAssociation}}
object. You can retrieve this ARN by calling
\href{https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html}{\code{list_repository_associations}}
.}

\item{Tags}{[required] An array of key-value pairs used to tag an associated repository. A tag
is a custom attribute label with two parts:
\itemize{
\item A \emph{tag key} (for example, \code{CostCenter}, \code{Environment}, \code{Project}, or
\code{Secret}). Tag keys are case sensitive.
\item An optional field known as a \emph{tag value} (for example,
\code{111122223333}, \code{Production}, or a team name). Omitting the tag
value is the same as using an empty string. Like tag keys, tag
values are case sensitive.
}}
}
\description{
Adds one or more tags to an associated repository.

See \url{https://paws-r.github.io/docs/codegurureviewer/tag_resource.html} for full documentation.
}
\keyword{internal}
