% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codestar_operations.R
\name{codestar_delete_project}
\alias{codestar_delete_project}
\title{Deletes a project, including project resources}
\usage{
codestar_delete_project(id, clientRequestToken = NULL, deleteStack = NULL)
}
\arguments{
\item{id}{[required] The ID of the project to be deleted in AWS CodeStar.}

\item{clientRequestToken}{A user- or system-generated token that identifies the entity that
requested project deletion. This token can be used to repeat the
request.}

\item{deleteStack}{Whether to send a delete request for the primary stack in AWS
CloudFormation originally used to generate the project and its
resources. This option will delete all AWS resources for the project
(except for any buckets in Amazon S3) as well as deleting the project
itself. Recommended for most use cases.}
}
\description{
Deletes a project, including project resources. Does not delete users associated with the project, but does delete the IAM roles that allowed access to the project.

See \url{https://paws-r.github.io/docs/codestar/delete_project.html} for full documentation.
}
\keyword{internal}
