% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codepipeline_operations.R
\name{codepipeline_poll_for_jobs}
\alias{codepipeline_poll_for_jobs}
\title{Returns information about any jobs for AWS CodePipeline to act on}
\usage{
codepipeline_poll_for_jobs(
  actionTypeId,
  maxBatchSize = NULL,
  queryParam = NULL
)
}
\arguments{
\item{actionTypeId}{[required] Represents information about an action type.}

\item{maxBatchSize}{The maximum number of jobs to return in a poll for jobs call.}

\item{queryParam}{A map of property names and values. For an action type with no queryable
properties, this value must be null or an empty map. For an action type
with a queryable property, you must supply that property as a key in the
map. Only jobs whose action configuration matches the mapped value are
returned.}
}
\description{
Returns information about any jobs for AWS CodePipeline to act on. \code{\link[=codepipeline_poll_for_jobs]{poll_for_jobs}} is valid only for action types with "Custom" in the owner field. If the action type contains "AWS" or "ThirdParty" in the owner field, the \code{\link[=codepipeline_poll_for_jobs]{poll_for_jobs}} action returns an error.

See \url{https://paws-r.github.io/docs/codepipeline/poll_for_jobs.html} for full documentation.
}
\keyword{internal}
