% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codegurureviewer_operations.R
\name{codegurureviewer_describe_recommendation_feedback}
\alias{codegurureviewer_describe_recommendation_feedback}
\title{Describes the customer feedback for a CodeGuru Reviewer recommendation}
\usage{
codegurureviewer_describe_recommendation_feedback(
  CodeReviewArn,
  RecommendationId,
  UserId = NULL
)
}
\arguments{
\item{CodeReviewArn}{[required] The Amazon Resource Name (ARN) of the
\href{https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html}{\code{CodeReview}}
object.}

\item{RecommendationId}{[required] The recommendation ID that can be used to track the provided
recommendations and then to collect the feedback.}

\item{UserId}{Optional parameter to describe the feedback for a given user. If this is
not supplied, it defaults to the user making the request.

The \code{UserId} is an IAM principal that can be specified as an Amazon Web
Services account ID or an Amazon Resource Name (ARN). For more
information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying}{Specifying a Principal}
in the \emph{Amazon Web Services Identity and Access Management User Guide}.}
}
\description{
Describes the customer feedback for a CodeGuru Reviewer recommendation.

See \url{https://paws-r.github.io/docs/codegurureviewer/describe_recommendation_feedback.html} for full documentation.
}
\keyword{internal}
