% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_override_pull_request_approval_rules}
\alias{codecommit_override_pull_request_approval_rules}
\title{Sets aside (overrides) all approval rule requirements for a specified
pull request}
\usage{
codecommit_override_pull_request_approval_rules(
  pullRequestId,
  revisionId,
  overrideStatus
)
}
\arguments{
\item{pullRequestId}{[required] The system-generated ID of the pull request for which you want to
override all approval rule requirements. To get this information, use
\code{\link[=codecommit_get_pull_request]{get_pull_request}}.}

\item{revisionId}{[required] The system-generated ID of the most recent revision of the pull request.
You cannot override approval rules for anything but the most recent
revision of a pull request. To get the revision ID, use GetPullRequest.}

\item{overrideStatus}{[required] Whether you want to set aside approval rule requirements for the pull
request (OVERRIDE) or revoke a previous override and apply approval rule
requirements (REVOKE). REVOKE status is not stored.}
}
\description{
Sets aside (overrides) all approval rule requirements for a specified pull request.

See \url{https://paws-r.github.io/docs/codecommit/override_pull_request_approval_rules.html} for full documentation.
}
\keyword{internal}
