% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_batch_get_report_groups}
\alias{codebuild_batch_get_report_groups}
\title{Returns an array of report groups}
\usage{
codebuild_batch_get_report_groups(reportGroupArns)
}
\arguments{
\item{reportGroupArns}{[required] An array of report group ARNs that identify the report groups to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  reportGroups = list(
    list(
      arn = "string",
      name = "string",
      type = "TEST"|"CODE_COVERAGE",
      exportConfig = list(
        exportConfigType = "S3"|"NO_EXPORT",
        s3Destination = list(
          bucket = "string",
          path = "string",
          packaging = "ZIP"|"NONE",
          encryptionKey = "string",
          encryptionDisabled = TRUE|FALSE
        )
      ),
      created = as.POSIXct(
        "2015-01-01"
      ),
      lastModified = as.POSIXct(
        "2015-01-01"
      ),
      tags = list(
        list(
          key = "string",
          value = "string"
        )
      ),
      status = "ACTIVE"|"DELETING"
    )
  ),
  reportGroupsNotFound = list(
    "string"
  )
)
}
}
\description{
Returns an array of report groups.
}
\section{Request syntax}{
\preformatted{svc$batch_get_report_groups(
  reportGroupArns = list(
    "string"
  )
)
}
}

\keyword{internal}
