% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timestreamwrite_operations.R
\name{timestreamwrite_update_table}
\alias{timestreamwrite_update_table}
\title{Modifies the retention duration of the memory store and magnetic store
for your Timestream table}
\usage{
timestreamwrite_update_table(
  DatabaseName,
  TableName,
  RetentionProperties = NULL,
  MagneticStoreWriteProperties = NULL,
  Schema = NULL
)
}
\arguments{
\item{DatabaseName}{[required] The name of the Timestream database.}

\item{TableName}{[required] The name of the Timestream table.}

\item{RetentionProperties}{The retention duration of the memory store and the magnetic store.}

\item{MagneticStoreWriteProperties}{Contains properties to set on the table when enabling magnetic store
writes.}

\item{Schema}{The schema of the table.}
}
\description{
Modifies the retention duration of the memory store and magnetic store for your Timestream table. Note that the change in retention duration takes effect immediately. For example, if the retention period of the memory store was initially set to 2 hours and then changed to 24 hours, the memory store will be capable of holding 24 hours of data, but will be populated with 24 hours of data 22 hours after this change was made. Timestream does not retrieve data from the magnetic store to populate the memory store.

See \url{https://www.paws-r-sdk.com/docs/timestreamwrite_update_table/} for full documentation.
}
\keyword{internal}
