% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_db_snapshot_tenant_databases}
\alias{rds_describe_db_snapshot_tenant_databases}
\title{Describes the tenant databases that exist in a DB snapshot}
\usage{
rds_describe_db_snapshot_tenant_databases(
  DBInstanceIdentifier = NULL,
  DBSnapshotIdentifier = NULL,
  SnapshotType = NULL,
  Filters = NULL,
  MaxRecords = NULL,
  Marker = NULL,
  DbiResourceId = NULL
)
}
\arguments{
\item{DBInstanceIdentifier}{The ID of the DB instance used to create the DB snapshots. This
parameter isn't case-sensitive.

Constraints:
\itemize{
\item If supplied, must match the identifier of an existing \code{DBInstance}.
}}

\item{DBSnapshotIdentifier}{The ID of a DB snapshot that contains the tenant databases to describe.
This value is stored as a lowercase string.

Constraints:
\itemize{
\item If you specify this parameter, the value must match the ID of an
existing DB snapshot.
\item If you specify an automatic snapshot, you must also specify
\code{SnapshotType}.
}}

\item{SnapshotType}{The type of DB snapshots to be returned. You can specify one of the
following values:
\itemize{
\item \code{automated} – All DB snapshots that have been automatically taken by
Amazon RDS for my Amazon Web Services account.
\item \code{manual} – All DB snapshots that have been taken by my Amazon Web
Services account.
\item \code{shared} – All manual DB snapshots that have been shared to my
Amazon Web Services account.
\item \code{public} – All DB snapshots that have been marked as public.
\item \code{awsbackup} – All DB snapshots managed by the Amazon Web Services
Backup service.
}}

\item{Filters}{A filter that specifies one or more tenant databases to describe.

Supported filters:
\itemize{
\item \code{tenant-db-name} - Tenant database names. The results list only
includes information about the tenant databases that match these
tenant DB names.
\item \code{tenant-database-resource-id} - Tenant database resource
identifiers. The results list only includes information about the
tenant databases contained within the DB snapshots.
\item \code{dbi-resource-id} - DB instance resource identifiers. The results
list only includes information about snapshots containing tenant
databases contained within the DB instances identified by these
resource identifiers.
\item \code{db-instance-id} - Accepts DB instance identifiers and DB instance
Amazon Resource Names (ARNs).
\item \code{db-snapshot-id} - Accepts DB snapshot identifiers.
\item \code{snapshot-type} - Accepts types of DB snapshots.
}}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that you can retrieve the
remaining results.}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=rds_describe_db_snapshot_tenant_databases]{describe_db_snapshot_tenant_databases}}
request. If this parameter is specified, the response includes only
records beyond the marker, up to the value specified by \code{MaxRecords}.}

\item{DbiResourceId}{A specific DB resource identifier to describe.}
}
\description{
Describes the tenant databases that exist in a DB snapshot. This command only applies to RDS for Oracle DB instances in the multi-tenant configuration.

See \url{https://www.paws-r-sdk.com/docs/rds_describe_db_snapshot_tenant_databases/} for full documentation.
}
\keyword{internal}
