% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_copy_db_snapshot}
\alias{rds_copy_db_snapshot}
\title{Copies the specified DB snapshot}
\usage{
rds_copy_db_snapshot(
  SourceDBSnapshotIdentifier,
  TargetDBSnapshotIdentifier,
  KmsKeyId = NULL,
  Tags = NULL,
  CopyTags = NULL,
  PreSignedUrl = NULL,
  OptionGroupName = NULL,
  TargetCustomAvailabilityZone = NULL,
  CopyOptionGroup = NULL
)
}
\arguments{
\item{SourceDBSnapshotIdentifier}{[required] The identifier for the source DB snapshot.

If the source snapshot is in the same Amazon Web Services Region as the
copy, specify a valid DB snapshot identifier. For example, you might
specify \code{rds:mysql-instance1-snapshot-20130805}.

If the source snapshot is in a different Amazon Web Services Region than
the copy, specify a valid DB snapshot ARN. For example, you might
specify
\code{arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805}.

If you are copying from a shared manual DB snapshot, this parameter must
be the Amazon Resource Name (ARN) of the shared DB snapshot.

If you are copying an encrypted snapshot this parameter must be in the
ARN format for the source Amazon Web Services Region.

Constraints:
\itemize{
\item Must specify a valid system snapshot in the "available" state.
}

Example: \code{rds:mydb-2012-04-02-00-01}

Example:
\code{arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805}}

\item{TargetDBSnapshotIdentifier}{[required] The identifier for the copy of the snapshot.

Constraints:
\itemize{
\item Can't be null, empty, or blank
\item Must contain from 1 to 255 letters, numbers, or hyphens
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
}

Example: \code{my-db-snapshot}}

\item{KmsKeyId}{The Amazon Web Services KMS key identifier for an encrypted DB snapshot.
The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
ARN, or alias name for the KMS key.

If you copy an encrypted DB snapshot from your Amazon Web Services
account, you can specify a value for this parameter to encrypt the copy
with a new KMS key. If you don't specify a value for this parameter,
then the copy of the DB snapshot is encrypted with the same Amazon Web
Services KMS key as the source DB snapshot.

If you copy an encrypted DB snapshot that is shared from another Amazon
Web Services account, then you must specify a value for this parameter.

If you specify this parameter when you copy an unencrypted snapshot, the
copy is encrypted.

If you copy an encrypted snapshot to a different Amazon Web Services
Region, then you must specify an Amazon Web Services KMS key identifier
for the destination Amazon Web Services Region. KMS keys are specific to
the Amazon Web Services Region that they are created in, and you can't
use KMS keys from one Amazon Web Services Region in another Amazon Web
Services Region.}

\item{Tags}{}

\item{CopyTags}{Specifies whether to copy all tags from the source DB snapshot to the
target DB snapshot. By default, tags aren't copied.}

\item{PreSignedUrl}{When you are copying a snapshot from one Amazon Web Services GovCloud
(US) Region to another, the URL that contains a Signature Version 4
signed request for the \code{\link[=rds_copy_db_snapshot]{copy_db_snapshot}} API
operation in the source Amazon Web Services Region that contains the
source DB snapshot to copy.

This setting applies only to Amazon Web Services GovCloud (US) Regions.
It's ignored in other Amazon Web Services Regions.

You must specify this parameter when you copy an encrypted DB snapshot
from another Amazon Web Services Region by using the Amazon RDS API.
Don't specify \code{PreSignedUrl} when you are copying an encrypted DB
snapshot in the same Amazon Web Services Region.

The presigned URL must be a valid request for the
\code{\link[=rds_copy_db_cluster_snapshot]{copy_db_cluster_snapshot}} API operation
that can run in the source Amazon Web Services Region that contains the
encrypted DB cluster snapshot to copy. The presigned URL request must
contain the following parameter values:
\itemize{
\item \code{DestinationRegion} - The Amazon Web Services Region that the
encrypted DB snapshot is copied to. This Amazon Web Services Region
is the same one where the \code{\link[=rds_copy_db_snapshot]{copy_db_snapshot}}
operation is called that contains this presigned URL.

For example, if you copy an encrypted DB snapshot from the us-west-2
Amazon Web Services Region to the us-east-1 Amazon Web Services
Region, then you call the \code{\link[=rds_copy_db_snapshot]{copy_db_snapshot}}
operation in the us-east-1 Amazon Web Services Region and provide a
presigned URL that contains a call to the
\code{\link[=rds_copy_db_snapshot]{copy_db_snapshot}} operation in the
us-west-2 Amazon Web Services Region. For this example, the
\code{DestinationRegion} in the presigned URL must be set to the
us-east-1 Amazon Web Services Region.
\item \code{KmsKeyId} - The KMS key identifier for the KMS key to use to
encrypt the copy of the DB snapshot in the destination Amazon Web
Services Region. This is the same identifier for both the
\code{\link[=rds_copy_db_snapshot]{copy_db_snapshot}} operation that is called
in the destination Amazon Web Services Region, and the operation
contained in the presigned URL.
\item \code{SourceDBSnapshotIdentifier} - The DB snapshot identifier for the
encrypted snapshot to be copied. This identifier must be in the
Amazon Resource Name (ARN) format for the source Amazon Web Services
Region. For example, if you are copying an encrypted DB snapshot
from the us-west-2 Amazon Web Services Region, then your
\code{SourceDBSnapshotIdentifier} looks like the following example:
\code{arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115}.
}

To learn how to generate a Signature Version 4 signed request, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html}{Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)}
and \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_sigv.html}{Signature Version 4 Signing Process}.

If you are using an Amazon Web Services SDK tool or the CLI, you can
specify \code{SourceRegion} (or \code{--source-region} for the CLI) instead of
specifying \code{PreSignedUrl} manually. Specifying \code{SourceRegion}
autogenerates a presigned URL that is a valid request for the operation
that can run in the source Amazon Web Services Region.}

\item{OptionGroupName}{The name of an option group to associate with the copy of the snapshot.

Specify this option if you are copying a snapshot from one Amazon Web
Services Region to another, and your DB instance uses a nondefault
option group. If your source DB instance uses Transparent Data
Encryption for Oracle or Microsoft SQL Server, you must specify this
option when copying across Amazon Web Services Regions. For more
information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopySnapshot.Options}{Option group considerations}
in the \emph{Amazon RDS User Guide}.}

\item{TargetCustomAvailabilityZone}{The external custom Availability Zone (CAZ) identifier for the target
CAZ.

Example: \code{rds-caz-aiqhTgQv}.}

\item{CopyOptionGroup}{Specifies whether to copy the DB option group associated with the source
DB snapshot to the target Amazon Web Services account and associate with
the target DB snapshot. The associated option group can be copied only
with cross-account snapshot copy calls.}
}
\description{
Copies the specified DB snapshot. The source DB snapshot must be in the \code{available} state.

See \url{https://www.paws-r-sdk.com/docs/rds_copy_db_snapshot/} for full documentation.
}
\keyword{internal}
