% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_copy_db_cluster_snapshot}
\alias{rds_copy_db_cluster_snapshot}
\title{Copies a snapshot of a DB cluster}
\usage{
rds_copy_db_cluster_snapshot(
  SourceDBClusterSnapshotIdentifier,
  TargetDBClusterSnapshotIdentifier,
  KmsKeyId = NULL,
  PreSignedUrl = NULL,
  CopyTags = NULL,
  Tags = NULL
)
}
\arguments{
\item{SourceDBClusterSnapshotIdentifier}{[required] The identifier of the DB cluster snapshot to copy. This parameter isn't
case-sensitive.

You can't copy an encrypted, shared DB cluster snapshot from one Amazon
Web Services Region to another.

Constraints:
\itemize{
\item Must specify a valid system snapshot in the "available" state.
\item If the source snapshot is in the same Amazon Web Services Region as
the copy, specify a valid DB snapshot identifier.
\item If the source snapshot is in a different Amazon Web Services Region
than the copy, specify a valid DB cluster snapshot ARN. For more
information, go to \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-copy-snapshot.html#USER_CopySnapshot.AcrossRegions}{Copying Snapshots Across Amazon Web Services Regions}
in the \emph{Amazon Aurora User Guide}.
}

Example: \code{my-cluster-snapshot1}}

\item{TargetDBClusterSnapshotIdentifier}{[required] The identifier of the new DB cluster snapshot to create from the source
DB cluster snapshot. This parameter isn't case-sensitive.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}

Example: \code{my-cluster-snapshot2}}

\item{KmsKeyId}{The Amazon Web Services KMS key identifier for an encrypted DB cluster
snapshot. The Amazon Web Services KMS key identifier is the key ARN, key
ID, alias ARN, or alias name for the Amazon Web Services KMS key.

If you copy an encrypted DB cluster snapshot from your Amazon Web
Services account, you can specify a value for \code{KmsKeyId} to encrypt the
copy with a new KMS key. If you don't specify a value for \code{KmsKeyId},
then the copy of the DB cluster snapshot is encrypted with the same KMS
key as the source DB cluster snapshot.

If you copy an encrypted DB cluster snapshot that is shared from another
Amazon Web Services account, then you must specify a value for
\code{KmsKeyId}.

To copy an encrypted DB cluster snapshot to another Amazon Web Services
Region, you must set \code{KmsKeyId} to the Amazon Web Services KMS key
identifier you want to use to encrypt the copy of the DB cluster
snapshot in the destination Amazon Web Services Region. KMS keys are
specific to the Amazon Web Services Region that they are created in, and
you can't use KMS keys from one Amazon Web Services Region in another
Amazon Web Services Region.

If you copy an unencrypted DB cluster snapshot and specify a value for
the \code{KmsKeyId} parameter, an error is returned.}

\item{PreSignedUrl}{When you are copying a DB cluster snapshot from one Amazon Web Services
GovCloud (US) Region to another, the URL that contains a Signature
Version 4 signed request for the
\code{\link[=rds_copy_db_cluster_snapshot]{copy_db_cluster_snapshot}} API operation
in the Amazon Web Services Region that contains the source DB cluster
snapshot to copy. Use the \code{PreSignedUrl} parameter when copying an
encrypted DB cluster snapshot from another Amazon Web Services Region.
Don't specify \code{PreSignedUrl} when copying an encrypted DB cluster
snapshot in the same Amazon Web Services Region.

This setting applies only to Amazon Web Services GovCloud (US) Regions.
It's ignored in other Amazon Web Services Regions.

The presigned URL must be a valid request for the
\code{\link[=rds_copy_db_cluster_snapshot]{copy_db_cluster_snapshot}} API operation
that can run in the source Amazon Web Services Region that contains the
encrypted DB cluster snapshot to copy. The presigned URL request must
contain the following parameter values:
\itemize{
\item \code{KmsKeyId} - The KMS key identifier for the KMS key to use to
encrypt the copy of the DB cluster snapshot in the destination
Amazon Web Services Region. This is the same identifier for both the
\code{\link[=rds_copy_db_cluster_snapshot]{copy_db_cluster_snapshot}} operation
that is called in the destination Amazon Web Services Region, and
the operation contained in the presigned URL.
\item \code{DestinationRegion} - The name of the Amazon Web Services Region
that the DB cluster snapshot is to be created in.
\item \code{SourceDBClusterSnapshotIdentifier} - The DB cluster snapshot
identifier for the encrypted DB cluster snapshot to be copied. This
identifier must be in the Amazon Resource Name (ARN) format for the
source Amazon Web Services Region. For example, if you are copying
an encrypted DB cluster snapshot from the us-west-2 Amazon Web
Services Region, then your \code{SourceDBClusterSnapshotIdentifier} looks
like the following example:
\code{arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115}.
}

To learn how to generate a Signature Version 4 signed request, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html}{Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)}
and \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_sigv.html}{Signature Version 4 Signing Process}.

If you are using an Amazon Web Services SDK tool or the CLI, you can
specify \code{SourceRegion} (or \code{--source-region} for the CLI) instead of
specifying \code{PreSignedUrl} manually. Specifying \code{SourceRegion}
autogenerates a presigned URL that is a valid request for the operation
that can run in the source Amazon Web Services Region.}

\item{CopyTags}{Specifies whether to copy all tags from the source DB cluster snapshot
to the target DB cluster snapshot. By default, tags are not copied.}

\item{Tags}{}
}
\description{
Copies a snapshot of a DB cluster.

See \url{https://www.paws-r-sdk.com/docs/rds_copy_db_cluster_snapshot/} for full documentation.
}
\keyword{internal}
