% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_modify_db_cluster}
\alias{neptune_modify_db_cluster}
\title{Modify a setting for a DB cluster}
\usage{
neptune_modify_db_cluster(
  DBClusterIdentifier,
  NewDBClusterIdentifier = NULL,
  ApplyImmediately = NULL,
  BackupRetentionPeriod = NULL,
  DBClusterParameterGroupName = NULL,
  VpcSecurityGroupIds = NULL,
  Port = NULL,
  MasterUserPassword = NULL,
  OptionGroupName = NULL,
  PreferredBackupWindow = NULL,
  PreferredMaintenanceWindow = NULL,
  EnableIAMDatabaseAuthentication = NULL,
  CloudwatchLogsExportConfiguration = NULL,
  EngineVersion = NULL,
  AllowMajorVersionUpgrade = NULL,
  DBInstanceParameterGroupName = NULL,
  DeletionProtection = NULL,
  CopyTagsToSnapshot = NULL,
  ServerlessV2ScalingConfiguration = NULL,
  StorageType = NULL
)
}
\arguments{
\item{DBClusterIdentifier}{[required] The DB cluster identifier for the cluster being modified. This parameter
is not case-sensitive.

Constraints:
\itemize{
\item Must match the identifier of an existing DBCluster.
}}

\item{NewDBClusterIdentifier}{The new DB cluster identifier for the DB cluster when renaming a DB
cluster. This value is stored as a lowercase string.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens
\item The first character must be a letter
\item Cannot end with a hyphen or contain two consecutive hyphens
}

Example: \code{my-cluster2}}

\item{ApplyImmediately}{A value that specifies whether the modifications in this request and any
pending modifications are asynchronously applied as soon as possible,
regardless of the \code{PreferredMaintenanceWindow} setting for the DB
cluster. If this parameter is set to \code{false}, changes to the DB cluster
are applied during the next maintenance window.

The \code{ApplyImmediately} parameter only affects \code{NewDBClusterIdentifier}
values. If you set the \code{ApplyImmediately} parameter value to false, then
changes to \code{NewDBClusterIdentifier} values are applied during the next
maintenance window. All other changes are applied immediately,
regardless of the value of the \code{ApplyImmediately} parameter.

Default: \code{false}}

\item{BackupRetentionPeriod}{The number of days for which automated backups are retained. You must
specify a minimum value of 1.

Default: 1

Constraints:
\itemize{
\item Must be a value from 1 to 35
}}

\item{DBClusterParameterGroupName}{The name of the DB cluster parameter group to use for the DB cluster.}

\item{VpcSecurityGroupIds}{A list of VPC security groups that the DB cluster will belong to.}

\item{Port}{The port number on which the DB cluster accepts connections.

Constraints: Value must be \code{1150-65535}

Default: The same port as the original DB cluster.}

\item{MasterUserPassword}{Not supported by Neptune.}

\item{OptionGroupName}{\emph{Not supported by Neptune.}}

\item{PreferredBackupWindow}{The daily time range during which automated backups are created if
automated backups are enabled, using the \code{BackupRetentionPeriod}
parameter.

The default is a 30-minute window selected at random from an 8-hour
block of time for each Amazon Region.

Constraints:
\itemize{
\item Must be in the format \code{hh24:mi-hh24:mi}.
\item Must be in Universal Coordinated Time (UTC).
\item Must not conflict with the preferred maintenance window.
\item Must be at least 30 minutes.
}}

\item{PreferredMaintenanceWindow}{The weekly time range during which system maintenance can occur, in
Universal Coordinated Time (UTC).

Format: \code{ddd:hh24:mi-ddd:hh24:mi}

The default is a 30-minute window selected at random from an 8-hour
block of time for each Amazon Region, occurring on a random day of the
week.

Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.

Constraints: Minimum 30-minute window.}

\item{EnableIAMDatabaseAuthentication}{True to enable mapping of Amazon Identity and Access Management (IAM)
accounts to database accounts, and otherwise false.

Default: \code{false}}

\item{CloudwatchLogsExportConfiguration}{The configuration setting for the log types to be enabled for export to
CloudWatch Logs for a specific DB cluster. See \href{https://docs.aws.amazon.com/neptune/latest/userguide/cloudwatch-logs.html#cloudwatch-logs-cli}{Using the CLI to publish Neptune audit logs to CloudWatch Logs}.}

\item{EngineVersion}{The version number of the database engine to which you want to upgrade.
Changing this parameter results in an outage. The change is applied
during the next maintenance window unless the \code{ApplyImmediately}
parameter is set to true.

For a list of valid engine versions, see \href{https://docs.aws.amazon.com/neptune/latest/userguide/engine-releases.html}{Engine Releases for Amazon Neptune},
or call
\code{\link[=neptune_describe_db_engine_versions]{describe_db_engine_versions}}.}

\item{AllowMajorVersionUpgrade}{A value that indicates whether upgrades between different major versions
are allowed.

Constraints: You must set the allow-major-version-upgrade flag when
providing an \code{EngineVersion} parameter that uses a different major
version than the DB cluster's current version.}

\item{DBInstanceParameterGroupName}{The name of the DB parameter group to apply to all instances of the DB
cluster.

When you apply a parameter group using \code{DBInstanceParameterGroupName},
parameter changes aren't applied during the next maintenance window but
instead are applied immediately.

Default: The existing name setting

Constraints:
\itemize{
\item The DB parameter group must be in the same DB parameter group family
as the target DB cluster version.
\item The \code{DBInstanceParameterGroupName} parameter is only valid in
combination with the \code{AllowMajorVersionUpgrade} parameter.
}}

\item{DeletionProtection}{A value that indicates whether the DB cluster has deletion protection
enabled. The database can't be deleted when deletion protection is
enabled. By default, deletion protection is disabled.}

\item{CopyTagsToSnapshot}{\emph{If set to true, tags are copied to any snapshot of the DB cluster that
is created.}}

\item{ServerlessV2ScalingConfiguration}{Contains the scaling configuration of a Neptune Serverless DB cluster.

For more information, see \href{https://docs.aws.amazon.com/neptune/latest/userguide/neptune-serverless-using.html}{Using Amazon Neptune Serverless}
in the \emph{Amazon Neptune User Guide}.}

\item{StorageType}{The storage type to associate with the DB cluster.

Valid Values:
\itemize{
\item \code{standard | iopt1}
}

Default:
\itemize{
\item \code{standard}
}}
}
\description{
Modify a setting for a DB cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.

See \url{https://www.paws-r-sdk.com/docs/neptune_modify_db_cluster/} for full documentation.
}
\keyword{internal}
