# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include redshiftdataapiservice_service.R
NULL

#' Runs one or more SQL statements, which can be data manipulation language
#' (DML) or data definition language (DDL)
#'
#' @description
#' Runs one or more SQL statements, which can be data manipulation language (DML) or data definition language (DDL). Depending on the authorization method, use one of the following combinations of request parameters:
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftdataapiservice_batch_execute_statement/](https://www.paws-r-sdk.com/docs/redshiftdataapiservice_batch_execute_statement/) for full documentation.
#'
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param ClusterIdentifier The cluster identifier. This parameter is required when connecting to a
#' cluster and authenticating using either Secrets Manager or temporary
#' credentials.
#' @param Database The name of the database. This parameter is required when authenticating
#' using either Secrets Manager or temporary credentials.
#' @param DbUser The database user name. This parameter is required when connecting to a
#' cluster as a database user and authenticating using temporary
#' credentials.
#' @param SecretArn The name or ARN of the secret that enables access to the database. This
#' parameter is required when authenticating using Secrets Manager.
#' @param SessionId The session identifier of the query.
#' @param SessionKeepAliveSeconds The number of seconds to keep the session alive after the query
#' finishes. The maximum time a session can keep alive is 24 hours. After
#' 24 hours, the session is forced closed and the query is terminated.
#' @param Sqls &#91;required&#93; One or more SQL statements to run.
#' 
#'      The SQL statements are run as a single transaction. They run serially in the order of the array. Subsequent SQL statements don\'t start until the previous statement in the array completes. If any SQL statement fails, then because they are run as one transaction, all work is rolled back.</p> 
#' @param StatementName The name of the SQL statements. You can name the SQL statements when you
#' create them to identify the query.
#' @param WithEvent A value that indicates whether to send an event to the Amazon
#' EventBridge event bus after the SQL statements run.
#' @param WorkgroupName The serverless workgroup name or Amazon Resource Name (ARN). This
#' parameter is required when connecting to a serverless workgroup and
#' authenticating using either Secrets Manager or temporary credentials.
#'
#' @keywords internal
#'
#' @rdname redshiftdataapiservice_batch_execute_statement
redshiftdataapiservice_batch_execute_statement <- function(ClientToken = NULL, ClusterIdentifier = NULL, Database = NULL, DbUser = NULL, SecretArn = NULL, SessionId = NULL, SessionKeepAliveSeconds = NULL, Sqls, StatementName = NULL, WithEvent = NULL, WorkgroupName = NULL) {
  op <- new_operation(
    name = "BatchExecuteStatement",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .redshiftdataapiservice$batch_execute_statement_input(ClientToken = ClientToken, ClusterIdentifier = ClusterIdentifier, Database = Database, DbUser = DbUser, SecretArn = SecretArn, SessionId = SessionId, SessionKeepAliveSeconds = SessionKeepAliveSeconds, Sqls = Sqls, StatementName = StatementName, WithEvent = WithEvent, WorkgroupName = WorkgroupName)
  output <- .redshiftdataapiservice$batch_execute_statement_output()
  config <- get_config()
  svc <- .redshiftdataapiservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftdataapiservice$operations$batch_execute_statement <- redshiftdataapiservice_batch_execute_statement

#' Cancels a running query
#'
#' @description
#' Cancels a running query. To be canceled, a query must be running.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftdataapiservice_cancel_statement/](https://www.paws-r-sdk.com/docs/redshiftdataapiservice_cancel_statement/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the SQL statement to cancel. This value is a
#' universally unique identifier (UUID) generated by Amazon Redshift Data
#' API. This identifier is returned by `BatchExecuteStatment`,
#' `ExecuteStatment`, and
#' [`list_statements`][redshiftdataapiservice_list_statements].
#'
#' @keywords internal
#'
#' @rdname redshiftdataapiservice_cancel_statement
redshiftdataapiservice_cancel_statement <- function(Id) {
  op <- new_operation(
    name = "CancelStatement",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .redshiftdataapiservice$cancel_statement_input(Id = Id)
  output <- .redshiftdataapiservice$cancel_statement_output()
  config <- get_config()
  svc <- .redshiftdataapiservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftdataapiservice$operations$cancel_statement <- redshiftdataapiservice_cancel_statement

#' Describes the details about a specific instance when a query was run by
#' the Amazon Redshift Data API
#'
#' @description
#' Describes the details about a specific instance when a query was run by the Amazon Redshift Data API. The information includes when the query started, when it finished, the query status, the number of rows returned, and the SQL statement.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftdataapiservice_describe_statement/](https://www.paws-r-sdk.com/docs/redshiftdataapiservice_describe_statement/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the SQL statement to describe. This value is a
#' universally unique identifier (UUID) generated by Amazon Redshift Data
#' API. A suffix indicates the number of the SQL statement. For example,
#' `d9b6c0c9-0747-4bf4-b142-e8883122f766:2` has a suffix of `:2` that
#' indicates the second SQL statement of a batch query. This identifier is
#' returned by `BatchExecuteStatment`,
#' [`execute_statement`][redshiftdataapiservice_execute_statement], and
#' [`list_statements`][redshiftdataapiservice_list_statements].
#'
#' @keywords internal
#'
#' @rdname redshiftdataapiservice_describe_statement
redshiftdataapiservice_describe_statement <- function(Id) {
  op <- new_operation(
    name = "DescribeStatement",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .redshiftdataapiservice$describe_statement_input(Id = Id)
  output <- .redshiftdataapiservice$describe_statement_output()
  config <- get_config()
  svc <- .redshiftdataapiservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftdataapiservice$operations$describe_statement <- redshiftdataapiservice_describe_statement

#' Describes the detailed information about a table from metadata in the
#' cluster
#'
#' @description
#' Describes the detailed information about a table from metadata in the cluster. The information includes its columns. A token is returned to page through the column list. Depending on the authorization method, use one of the following combinations of request parameters:
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftdataapiservice_describe_table/](https://www.paws-r-sdk.com/docs/redshiftdataapiservice_describe_table/) for full documentation.
#'
#' @param ClusterIdentifier The cluster identifier. This parameter is required when connecting to a
#' cluster and authenticating using either Secrets Manager or temporary
#' credentials.
#' @param ConnectedDatabase A database name. The connected database is specified when you connect
#' with your authentication credentials.
#' @param Database &#91;required&#93; The name of the database that contains the tables to be described. If
#' `ConnectedDatabase` is not specified, this is also the database to
#' connect to with your authentication credentials.
#' @param DbUser The database user name. This parameter is required when connecting to a
#' cluster as a database user and authenticating using temporary
#' credentials.
#' @param MaxResults The maximum number of tables to return in the response. If more tables
#' exist than fit in one response, then `NextToken` is returned to page
#' through the results.
#' @param NextToken A value that indicates the starting point for the next set of response
#' records in a subsequent request. If a value is returned in a response,
#' you can retrieve the next set of records by providing this returned
#' NextToken value in the next NextToken parameter and retrying the
#' command. If the NextToken field is empty, all response records have been
#' retrieved for the request.
#' @param Schema The schema that contains the table. If no schema is specified, then
#' matching tables for all schemas are returned.
#' @param SecretArn The name or ARN of the secret that enables access to the database. This
#' parameter is required when authenticating using Secrets Manager.
#' @param Table The table name. If no table is specified, then all tables for all
#' matching schemas are returned. If no table and no schema is specified,
#' then all tables for all schemas in the database are returned
#' @param WorkgroupName The serverless workgroup name or Amazon Resource Name (ARN). This
#' parameter is required when connecting to a serverless workgroup and
#' authenticating using either Secrets Manager or temporary credentials.
#'
#' @keywords internal
#'
#' @rdname redshiftdataapiservice_describe_table
redshiftdataapiservice_describe_table <- function(ClusterIdentifier = NULL, ConnectedDatabase = NULL, Database, DbUser = NULL, MaxResults = NULL, NextToken = NULL, Schema = NULL, SecretArn = NULL, Table = NULL, WorkgroupName = NULL) {
  op <- new_operation(
    name = "DescribeTable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ColumnList")
  )
  input <- .redshiftdataapiservice$describe_table_input(ClusterIdentifier = ClusterIdentifier, ConnectedDatabase = ConnectedDatabase, Database = Database, DbUser = DbUser, MaxResults = MaxResults, NextToken = NextToken, Schema = Schema, SecretArn = SecretArn, Table = Table, WorkgroupName = WorkgroupName)
  output <- .redshiftdataapiservice$describe_table_output()
  config <- get_config()
  svc <- .redshiftdataapiservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftdataapiservice$operations$describe_table <- redshiftdataapiservice_describe_table

#' Runs an SQL statement, which can be data manipulation language (DML) or
#' data definition language (DDL)
#'
#' @description
#' Runs an SQL statement, which can be data manipulation language (DML) or data definition language (DDL). This statement must be a single SQL statement. Depending on the authorization method, use one of the following combinations of request parameters:
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftdataapiservice_execute_statement/](https://www.paws-r-sdk.com/docs/redshiftdataapiservice_execute_statement/) for full documentation.
#'
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param ClusterIdentifier The cluster identifier. This parameter is required when connecting to a
#' cluster and authenticating using either Secrets Manager or temporary
#' credentials.
#' @param Database The name of the database. This parameter is required when authenticating
#' using either Secrets Manager or temporary credentials.
#' @param DbUser The database user name. This parameter is required when connecting to a
#' cluster as a database user and authenticating using temporary
#' credentials.
#' @param Parameters The parameters for the SQL statement.
#' @param SecretArn The name or ARN of the secret that enables access to the database. This
#' parameter is required when authenticating using Secrets Manager.
#' @param SessionId The session identifier of the query.
#' @param SessionKeepAliveSeconds The number of seconds to keep the session alive after the query
#' finishes. The maximum time a session can keep alive is 24 hours. After
#' 24 hours, the session is forced closed and the query is terminated.
#' @param Sql &#91;required&#93; The SQL statement text to run.
#' @param StatementName The name of the SQL statement. You can name the SQL statement when you
#' create it to identify the query.
#' @param WithEvent A value that indicates whether to send an event to the Amazon
#' EventBridge event bus after the SQL statement runs.
#' @param WorkgroupName The serverless workgroup name or Amazon Resource Name (ARN). This
#' parameter is required when connecting to a serverless workgroup and
#' authenticating using either Secrets Manager or temporary credentials.
#'
#' @keywords internal
#'
#' @rdname redshiftdataapiservice_execute_statement
redshiftdataapiservice_execute_statement <- function(ClientToken = NULL, ClusterIdentifier = NULL, Database = NULL, DbUser = NULL, Parameters = NULL, SecretArn = NULL, SessionId = NULL, SessionKeepAliveSeconds = NULL, Sql, StatementName = NULL, WithEvent = NULL, WorkgroupName = NULL) {
  op <- new_operation(
    name = "ExecuteStatement",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .redshiftdataapiservice$execute_statement_input(ClientToken = ClientToken, ClusterIdentifier = ClusterIdentifier, Database = Database, DbUser = DbUser, Parameters = Parameters, SecretArn = SecretArn, SessionId = SessionId, SessionKeepAliveSeconds = SessionKeepAliveSeconds, Sql = Sql, StatementName = StatementName, WithEvent = WithEvent, WorkgroupName = WorkgroupName)
  output <- .redshiftdataapiservice$execute_statement_output()
  config <- get_config()
  svc <- .redshiftdataapiservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftdataapiservice$operations$execute_statement <- redshiftdataapiservice_execute_statement

#' Fetches the temporarily cached result of an SQL statement
#'
#' @description
#' Fetches the temporarily cached result of an SQL statement. A token is returned to page through the statement results.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftdataapiservice_get_statement_result/](https://www.paws-r-sdk.com/docs/redshiftdataapiservice_get_statement_result/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the SQL statement whose results are to be fetched.
#' This value is a universally unique identifier (UUID) generated by Amazon
#' Redshift Data API. A suffix indicates then number of the SQL statement.
#' For example, `d9b6c0c9-0747-4bf4-b142-e8883122f766:2` has a suffix of
#' `:2` that indicates the second SQL statement of a batch query. This
#' identifier is returned by `BatchExecuteStatment`, `ExecuteStatment`, and
#' [`list_statements`][redshiftdataapiservice_list_statements].
#' @param NextToken A value that indicates the starting point for the next set of response
#' records in a subsequent request. If a value is returned in a response,
#' you can retrieve the next set of records by providing this returned
#' NextToken value in the next NextToken parameter and retrying the
#' command. If the NextToken field is empty, all response records have been
#' retrieved for the request.
#'
#' @keywords internal
#'
#' @rdname redshiftdataapiservice_get_statement_result
redshiftdataapiservice_get_statement_result <- function(Id, NextToken = NULL) {
  op <- new_operation(
    name = "GetStatementResult",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "Records")
  )
  input <- .redshiftdataapiservice$get_statement_result_input(Id = Id, NextToken = NextToken)
  output <- .redshiftdataapiservice$get_statement_result_output()
  config <- get_config()
  svc <- .redshiftdataapiservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftdataapiservice$operations$get_statement_result <- redshiftdataapiservice_get_statement_result

#' List the databases in a cluster
#'
#' @description
#' List the databases in a cluster. A token is returned to page through the database list. Depending on the authorization method, use one of the following combinations of request parameters:
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftdataapiservice_list_databases/](https://www.paws-r-sdk.com/docs/redshiftdataapiservice_list_databases/) for full documentation.
#'
#' @param ClusterIdentifier The cluster identifier. This parameter is required when connecting to a
#' cluster and authenticating using either Secrets Manager or temporary
#' credentials.
#' @param Database &#91;required&#93; The name of the database. This parameter is required when authenticating
#' using either Secrets Manager or temporary credentials.
#' @param DbUser The database user name. This parameter is required when connecting to a
#' cluster as a database user and authenticating using temporary
#' credentials.
#' @param MaxResults The maximum number of databases to return in the response. If more
#' databases exist than fit in one response, then `NextToken` is returned
#' to page through the results.
#' @param NextToken A value that indicates the starting point for the next set of response
#' records in a subsequent request. If a value is returned in a response,
#' you can retrieve the next set of records by providing this returned
#' NextToken value in the next NextToken parameter and retrying the
#' command. If the NextToken field is empty, all response records have been
#' retrieved for the request.
#' @param SecretArn The name or ARN of the secret that enables access to the database. This
#' parameter is required when authenticating using Secrets Manager.
#' @param WorkgroupName The serverless workgroup name or Amazon Resource Name (ARN). This
#' parameter is required when connecting to a serverless workgroup and
#' authenticating using either Secrets Manager or temporary credentials.
#'
#' @keywords internal
#'
#' @rdname redshiftdataapiservice_list_databases
redshiftdataapiservice_list_databases <- function(ClusterIdentifier = NULL, Database, DbUser = NULL, MaxResults = NULL, NextToken = NULL, SecretArn = NULL, WorkgroupName = NULL) {
  op <- new_operation(
    name = "ListDatabases",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Databases")
  )
  input <- .redshiftdataapiservice$list_databases_input(ClusterIdentifier = ClusterIdentifier, Database = Database, DbUser = DbUser, MaxResults = MaxResults, NextToken = NextToken, SecretArn = SecretArn, WorkgroupName = WorkgroupName)
  output <- .redshiftdataapiservice$list_databases_output()
  config <- get_config()
  svc <- .redshiftdataapiservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftdataapiservice$operations$list_databases <- redshiftdataapiservice_list_databases

#' Lists the schemas in a database
#'
#' @description
#' Lists the schemas in a database. A token is returned to page through the schema list. Depending on the authorization method, use one of the following combinations of request parameters:
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftdataapiservice_list_schemas/](https://www.paws-r-sdk.com/docs/redshiftdataapiservice_list_schemas/) for full documentation.
#'
#' @param ClusterIdentifier The cluster identifier. This parameter is required when connecting to a
#' cluster and authenticating using either Secrets Manager or temporary
#' credentials.
#' @param ConnectedDatabase A database name. The connected database is specified when you connect
#' with your authentication credentials.
#' @param Database &#91;required&#93; The name of the database that contains the schemas to list. If
#' `ConnectedDatabase` is not specified, this is also the database to
#' connect to with your authentication credentials.
#' @param DbUser The database user name. This parameter is required when connecting to a
#' cluster as a database user and authenticating using temporary
#' credentials.
#' @param MaxResults The maximum number of schemas to return in the response. If more schemas
#' exist than fit in one response, then `NextToken` is returned to page
#' through the results.
#' @param NextToken A value that indicates the starting point for the next set of response
#' records in a subsequent request. If a value is returned in a response,
#' you can retrieve the next set of records by providing this returned
#' NextToken value in the next NextToken parameter and retrying the
#' command. If the NextToken field is empty, all response records have been
#' retrieved for the request.
#' @param SchemaPattern A pattern to filter results by schema name. Within a schema pattern, "%"
#' means match any substring of 0 or more characters and "_" means match
#' any one character. Only schema name entries matching the search pattern
#' are returned.
#' @param SecretArn The name or ARN of the secret that enables access to the database. This
#' parameter is required when authenticating using Secrets Manager.
#' @param WorkgroupName The serverless workgroup name or Amazon Resource Name (ARN). This
#' parameter is required when connecting to a serverless workgroup and
#' authenticating using either Secrets Manager or temporary credentials.
#'
#' @keywords internal
#'
#' @rdname redshiftdataapiservice_list_schemas
redshiftdataapiservice_list_schemas <- function(ClusterIdentifier = NULL, ConnectedDatabase = NULL, Database, DbUser = NULL, MaxResults = NULL, NextToken = NULL, SchemaPattern = NULL, SecretArn = NULL, WorkgroupName = NULL) {
  op <- new_operation(
    name = "ListSchemas",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Schemas")
  )
  input <- .redshiftdataapiservice$list_schemas_input(ClusterIdentifier = ClusterIdentifier, ConnectedDatabase = ConnectedDatabase, Database = Database, DbUser = DbUser, MaxResults = MaxResults, NextToken = NextToken, SchemaPattern = SchemaPattern, SecretArn = SecretArn, WorkgroupName = WorkgroupName)
  output <- .redshiftdataapiservice$list_schemas_output()
  config <- get_config()
  svc <- .redshiftdataapiservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftdataapiservice$operations$list_schemas <- redshiftdataapiservice_list_schemas

#' List of SQL statements
#'
#' @description
#' List of SQL statements. By default, only finished statements are shown. A token is returned to page through the statement list.
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftdataapiservice_list_statements/](https://www.paws-r-sdk.com/docs/redshiftdataapiservice_list_statements/) for full documentation.
#'
#' @param MaxResults The maximum number of SQL statements to return in the response. If more
#' SQL statements exist than fit in one response, then `NextToken` is
#' returned to page through the results.
#' @param NextToken A value that indicates the starting point for the next set of response
#' records in a subsequent request. If a value is returned in a response,
#' you can retrieve the next set of records by providing this returned
#' NextToken value in the next NextToken parameter and retrying the
#' command. If the NextToken field is empty, all response records have been
#' retrieved for the request.
#' @param RoleLevel A value that filters which statements to return in the response. If
#' true, all statements run by the caller's IAM role are returned. If
#' false, only statements run by the caller's IAM role in the current IAM
#' session are returned. The default is true.
#' @param StatementName The name of the SQL statement specified as input to
#' [`batch_execute_statement`][redshiftdataapiservice_batch_execute_statement]
#' or [`execute_statement`][redshiftdataapiservice_execute_statement] to
#' identify the query. You can list multiple statements by providing a
#' prefix that matches the beginning of the statement name. For example, to
#' list myStatement1, myStatement2, myStatement3, and so on, then provide
#' the a value of `myStatement`. Data API does a case-sensitive match of
#' SQL statement names to the prefix value you provide.
#' @param Status The status of the SQL statement to list. Status values are defined as
#' follows:
#' 
#' -   ABORTED - The query run was stopped by the user.
#' 
#' -   ALL - A status value that includes all query statuses. This value
#'     can be used to filter results.
#' 
#' -   FAILED - The query run failed.
#' 
#' -   FINISHED - The query has finished running.
#' 
#' -   PICKED - The query has been chosen to be run.
#' 
#' -   STARTED - The query run has started.
#' 
#' -   SUBMITTED - The query was submitted, but not yet processed.
#'
#' @keywords internal
#'
#' @rdname redshiftdataapiservice_list_statements
redshiftdataapiservice_list_statements <- function(MaxResults = NULL, NextToken = NULL, RoleLevel = NULL, StatementName = NULL, Status = NULL) {
  op <- new_operation(
    name = "ListStatements",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Statements")
  )
  input <- .redshiftdataapiservice$list_statements_input(MaxResults = MaxResults, NextToken = NextToken, RoleLevel = RoleLevel, StatementName = StatementName, Status = Status)
  output <- .redshiftdataapiservice$list_statements_output()
  config <- get_config()
  svc <- .redshiftdataapiservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftdataapiservice$operations$list_statements <- redshiftdataapiservice_list_statements

#' List the tables in a database
#'
#' @description
#' List the tables in a database. If neither `SchemaPattern` nor `TablePattern` are specified, then all tables in the database are returned. A token is returned to page through the table list. Depending on the authorization method, use one of the following combinations of request parameters:
#'
#' See [https://www.paws-r-sdk.com/docs/redshiftdataapiservice_list_tables/](https://www.paws-r-sdk.com/docs/redshiftdataapiservice_list_tables/) for full documentation.
#'
#' @param ClusterIdentifier The cluster identifier. This parameter is required when connecting to a
#' cluster and authenticating using either Secrets Manager or temporary
#' credentials.
#' @param ConnectedDatabase A database name. The connected database is specified when you connect
#' with your authentication credentials.
#' @param Database &#91;required&#93; The name of the database that contains the tables to list. If
#' `ConnectedDatabase` is not specified, this is also the database to
#' connect to with your authentication credentials.
#' @param DbUser The database user name. This parameter is required when connecting to a
#' cluster as a database user and authenticating using temporary
#' credentials.
#' @param MaxResults The maximum number of tables to return in the response. If more tables
#' exist than fit in one response, then `NextToken` is returned to page
#' through the results.
#' @param NextToken A value that indicates the starting point for the next set of response
#' records in a subsequent request. If a value is returned in a response,
#' you can retrieve the next set of records by providing this returned
#' NextToken value in the next NextToken parameter and retrying the
#' command. If the NextToken field is empty, all response records have been
#' retrieved for the request.
#' @param SchemaPattern A pattern to filter results by schema name. Within a schema pattern, "%"
#' means match any substring of 0 or more characters and "_" means match
#' any one character. Only schema name entries matching the search pattern
#' are returned. If `SchemaPattern` is not specified, then all tables that
#' match `TablePattern` are returned. If neither `SchemaPattern` or
#' `TablePattern` are specified, then all tables are returned.
#' @param SecretArn The name or ARN of the secret that enables access to the database. This
#' parameter is required when authenticating using Secrets Manager.
#' @param TablePattern A pattern to filter results by table name. Within a table pattern, "%"
#' means match any substring of 0 or more characters and "_" means match
#' any one character. Only table name entries matching the search pattern
#' are returned. If `TablePattern` is not specified, then all tables that
#' match `SchemaPattern`are returned. If neither `SchemaPattern` or
#' `TablePattern` are specified, then all tables are returned.
#' @param WorkgroupName The serverless workgroup name or Amazon Resource Name (ARN). This
#' parameter is required when connecting to a serverless workgroup and
#' authenticating using either Secrets Manager or temporary credentials.
#'
#' @keywords internal
#'
#' @rdname redshiftdataapiservice_list_tables
redshiftdataapiservice_list_tables <- function(ClusterIdentifier = NULL, ConnectedDatabase = NULL, Database, DbUser = NULL, MaxResults = NULL, NextToken = NULL, SchemaPattern = NULL, SecretArn = NULL, TablePattern = NULL, WorkgroupName = NULL) {
  op <- new_operation(
    name = "ListTables",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Tables")
  )
  input <- .redshiftdataapiservice$list_tables_input(ClusterIdentifier = ClusterIdentifier, ConnectedDatabase = ConnectedDatabase, Database = Database, DbUser = DbUser, MaxResults = MaxResults, NextToken = NextToken, SchemaPattern = SchemaPattern, SecretArn = SecretArn, TablePattern = TablePattern, WorkgroupName = WorkgroupName)
  output <- .redshiftdataapiservice$list_tables_output()
  config <- get_config()
  svc <- .redshiftdataapiservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshiftdataapiservice$operations$list_tables <- redshiftdataapiservice_list_tables
