% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_option_group}
\alias{rds_create_option_group}
\title{Creates a new option group}
\usage{
rds_create_option_group(
  OptionGroupName,
  EngineName,
  MajorEngineVersion,
  OptionGroupDescription,
  Tags = NULL
)
}
\arguments{
\item{OptionGroupName}{[required] Specifies the name of the option group to be created.

Constraints:
\itemize{
\item Must be 1 to 255 letters, numbers, or hyphens
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
}

Example: \code{myoptiongroup}}

\item{EngineName}{[required] The name of the engine to associate this option group with.

Valid Values:
\itemize{
\item \code{db2-ae}
\item \code{db2-se}
\item \code{mariadb}
\item \code{mysql}
\item \code{oracle-ee}
\item \code{oracle-ee-cdb}
\item \code{oracle-se2}
\item \code{oracle-se2-cdb}
\item \code{postgres}
\item \code{sqlserver-ee}
\item \code{sqlserver-se}
\item \code{sqlserver-ex}
\item \code{sqlserver-web}
}}

\item{MajorEngineVersion}{[required] Specifies the major version of the engine that this option group should
be associated with.}

\item{OptionGroupDescription}{[required] The description of the option group.}

\item{Tags}{Tags to assign to the option group.}
}
\description{
Creates a new option group. You can create up to 20 option groups.

See \url{https://www.paws-r-sdk.com/docs/rds_create_option_group/} for full documentation.
}
\keyword{internal}
