% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_blue_green_deployment}
\alias{rds_create_blue_green_deployment}
\title{Creates a blue/green deployment}
\usage{
rds_create_blue_green_deployment(
  BlueGreenDeploymentName,
  Source,
  TargetEngineVersion = NULL,
  TargetDBParameterGroupName = NULL,
  TargetDBClusterParameterGroupName = NULL,
  Tags = NULL
)
}
\arguments{
\item{BlueGreenDeploymentName}{[required] The name of the blue/green deployment.

Constraints:
\itemize{
\item Can't be the same as an existing blue/green deployment name in the
same account and Amazon Web Services Region.
}}

\item{Source}{[required] The Amazon Resource Name (ARN) of the source production database.

Specify the database that you want to clone. The blue/green deployment
creates this database in the green environment. You can make updates to
the database in the green environment, such as an engine version
upgrade. When you are ready, you can switch the database in the green
environment to be the production database.}

\item{TargetEngineVersion}{The engine version of the database in the green environment.

Specify the engine version to upgrade to in the green environment.}

\item{TargetDBParameterGroupName}{The DB parameter group associated with the DB instance in the green
environment.

To test parameter changes, specify a DB parameter group that is
different from the one associated with the source DB instance.}

\item{TargetDBClusterParameterGroupName}{The DB cluster parameter group associated with the Aurora DB cluster in
the green environment.

To test parameter changes, specify a DB cluster parameter group that is
different from the one associated with the source DB cluster.}

\item{Tags}{Tags to assign to the blue/green deployment.}
}
\description{
Creates a blue/green deployment.

See \url{https://www.paws-r-sdk.com/docs/rds_create_blue_green_deployment/} for full documentation.
}
\keyword{internal}
