% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timestreamwrite_operations.R
\name{timestreamwrite_write_records}
\alias{timestreamwrite_write_records}
\title{The WriteRecords operation enables you to write your time series data
into Timestream}
\usage{
timestreamwrite_write_records(
  DatabaseName,
  TableName,
  CommonAttributes = NULL,
  Records
)
}
\arguments{
\item{DatabaseName}{[required] The name of the Timestream database.}

\item{TableName}{[required] The name of the Timestream table.}

\item{CommonAttributes}{A record containing the common measure, dimension, time, and version
attributes shared across all the records in the request. The measure and
dimension attributes specified will be merged with the measure and
dimension attributes in the records object when the data is written into
Timestream. Dimensions may not overlap, or a \code{ValidationException} will
be thrown. In other words, a record must contain dimensions with unique
names.}

\item{Records}{[required] An array of records containing the unique measure, dimension, time, and
version attributes for each time series data point.}
}
\description{
The WriteRecords operation enables you to write your time series data into Timestream. You can specify a single data point or a batch of data points to be inserted into the system. Timestream offers you with a flexible schema that auto detects the column names and data types for your Timestream tables based on the dimension names and data types of the data points you specify when invoking writes into the database. Timestream support eventual consistency read semantics. This means that when you query data immediately after writing a batch of data into Timestream, the query results might not reflect the results of a recently completed write operation. The results may also include some stale data. If you repeat the query request after a short time, the results should return the latest data. \href{https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html}{Service quotas apply}.

See \url{https://paws-r.github.io/docs/timestreamwrite/write_records.html} for full documentation.
}
\keyword{internal}
