% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_describe_pending_maintenance_actions}
\alias{neptune_describe_pending_maintenance_actions}
\title{Returns a list of resources (for example, DB instances) that have at
least one pending maintenance action}
\usage{
neptune_describe_pending_maintenance_actions(
  ResourceIdentifier = NULL,
  Filters = NULL,
  Marker = NULL,
  MaxRecords = NULL
)
}
\arguments{
\item{ResourceIdentifier}{The ARN of a resource to return pending maintenance actions for.}

\item{Filters}{A filter that specifies one or more resources to return pending
maintenance actions for.

Supported filters:
\itemize{
\item \code{db-cluster-id} - Accepts DB cluster identifiers and DB cluster
Amazon Resource Names (ARNs). The results list will only include
pending maintenance actions for the DB clusters identified by these
ARNs.
\item \code{db-instance-id} - Accepts DB instance identifiers and DB instance
ARNs. The results list will only include pending maintenance actions
for the DB instances identified by these ARNs.
}}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=neptune_describe_pending_maintenance_actions]{describe_pending_maintenance_actions}}
request. If this parameter is specified, the response includes only
records beyond the marker, up to a number of records specified by
\code{MaxRecords}.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that the remaining
results can be retrieved.

Default: 100

Constraints: Minimum 20, maximum 100.}
}
\description{
Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.

See \url{https://paws-r.github.io/docs/neptune/describe_pending_maintenance_actions.html} for full documentation.
}
\keyword{internal}
