% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshiftdataapiservice_operations.R
\name{redshiftdataapiservice_list_statements}
\alias{redshiftdataapiservice_list_statements}
\title{List of SQL statements}
\usage{
redshiftdataapiservice_list_statements(
  MaxResults = NULL,
  NextToken = NULL,
  RoleLevel = NULL,
  StatementName = NULL,
  Status = NULL
)
}
\arguments{
\item{MaxResults}{The maximum number of SQL statements to return in the response. If more
SQL statements exist than fit in one response, then \code{NextToken} is
returned to page through the results.}

\item{NextToken}{A value that indicates the starting point for the next set of response
records in a subsequent request. If a value is returned in a response,
you can retrieve the next set of records by providing this returned
NextToken value in the next NextToken parameter and retrying the
command. If the NextToken field is empty, all response records have been
retrieved for the request.}

\item{RoleLevel}{A value that filters which statements to return in the response. If
true, all statements run by the caller's IAM role are returned. If
false, only statements run by the caller's IAM role in the current IAM
session are returned. The default is true.}

\item{StatementName}{The name of the SQL statement specified as input to
\code{\link[=redshiftdataapiservice_batch_execute_statement]{batch_execute_statement}}
or \code{\link[=redshiftdataapiservice_execute_statement]{execute_statement}} to
identify the query. You can list multiple statements by providing a
prefix that matches the beginning of the statement name. For example, to
list myStatement1, myStatement2, myStatement3, and so on, then provide
the a value of \code{myStatement}. Data API does a case-sensitive match of
SQL statement names to the prefix value you provide.}

\item{Status}{The status of the SQL statement to list. Status values are defined as
follows:
\itemize{
\item ABORTED - The query run was stopped by the user.
\item ALL - A status value that includes all query statuses. This value
can be used to filter results.
\item FAILED - The query run failed.
\item FINISHED - The query has finished running.
\item PICKED - The query has been chosen to be run.
\item STARTED - The query run has started.
\item SUBMITTED - The query was submitted, but not yet processed.
}}
}
\description{
List of SQL statements. By default, only finished statements are shown. A token is returned to page through the statement list.

See \url{https://paws-r.github.io/docs/redshiftdataapiservice/list_statements.html} for full documentation.
}
\keyword{internal}
